/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.dstore.universal.miners.filesystem;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.server.SecuredThread;
import org.eclipse.dstore.core.server.SystemServiceManager;
import org.eclipse.dstore.core.util.StringCompare;
import org.eclipse.dstore.internal.core.util.MemoryManager;
import org.eclipse.rse.dstore.universal.miners.ICancellableHandler;
import org.eclipse.rse.dstore.universal.miners.UniversalFileSystemMiner;
import org.eclipse.rse.dstore.universal.miners.UniversalServerUtilities;
import org.eclipse.rse.services.clientserver.SystemFileClassifier;
import org.eclipse.rse.services.clientserver.SystemSearchString;
import org.eclipse.rse.services.clientserver.archiveutils.AbsoluteVirtualPath;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.archiveutils.VirtualChild;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.clientserver.search.SystemSearchFileNameMatcher;
import org.eclipse.rse.services.clientserver.search.SystemSearchLineMatch;
import org.eclipse.rse.services.clientserver.search.SystemSearchStringMatchLocator;
import org.eclipse.rse.services.clientserver.search.SystemSearchStringMatcher;

public class UniversalSearchHandler
extends SecuredThread
implements ICancellableHandler {
    protected HashSet _alreadySearched;
    private File _rootFile;
    protected boolean _isCancelled;
    protected boolean _isDone;
    protected int _depth = -1;
    protected UniversalFileSystemMiner _miner;
    protected DataElement _status;
    protected SystemSearchString _searchString;
    protected SystemSearchStringMatcher _stringMatcher;
    protected boolean _isFileSearch;
    protected SystemSearchFileNameMatcher _fileNameMatcher;
    protected String _classificationString;
    protected DataElement _deGrep;
    protected DataElement _deFile;
    protected DataElement _deFolder;
    protected DataElement _deArchiveFile;
    protected DataElement _deVirtualFile;
    protected boolean _fsCaseSensitive;
    private MemoryManager _memoryManager;
    private boolean _searchOnlyUniqueFolders = true;

    public UniversalSearchHandler(DataStore dataStore, UniversalFileSystemMiner miner, SystemSearchString searchString, boolean fsCaseSensitive, File theFile, DataElement status) {
        super(dataStore);
        this._memoryManager = MemoryManager.getInstance((DataStore)dataStore);
        this._miner = miner;
        this._searchString = searchString;
        this._fsCaseSensitive = fsCaseSensitive;
        this._alreadySearched = new HashSet();
        this._deGrep = this._dataStore.findObjectDescriptor("grep");
        this._deFile = this._dataStore.findObjectDescriptor("universal.FileObject");
        this._deFolder = this._dataStore.findObjectDescriptor("universal.FolderObject");
        this._deArchiveFile = this._dataStore.findObjectDescriptor("universal.ArchiveFileObject");
        this._deVirtualFile = this._dataStore.findObjectDescriptor("universal.VirtualFileObject");
        boolean includeSubfolders = searchString.isIncludeSubfolders();
        String searchUnique = System.getProperty("DSTORE_SEARCH_ONLY_UNIQUE_FOLDERS");
        if (searchUnique != null && searchUnique.equals("false")) {
            this._searchOnlyUniqueFolders = false;
        }
        this._depth = includeSubfolders ? -1 : 1;
        this._rootFile = theFile;
        this._status = status;
        this._isCancelled = false;
        this._isDone = false;
        this._stringMatcher = new SystemSearchStringMatcher(this._searchString.getTextString(), this._searchString.isCaseSensitive(), this._searchString.isTextStringRegex());
        this._isFileSearch = this._stringMatcher.isSearchStringEmpty() || this._stringMatcher.isSearchStringAsterisk();
        boolean fileNamesCaseSensitive = fsCaseSensitive;
        if (fileNamesCaseSensitive) {
            fileNamesCaseSensitive = searchString.isFileNamesCaseSensitive();
        }
        this._fileNameMatcher = new SystemSearchFileNameMatcher(this._searchString.getFileNamesString(), fileNamesCaseSensitive, this._searchString.isFileNamesRegex());
        this._classificationString = this._searchString.getClassificationString();
    }

    public void run() {
        super.run();
        try {
            this.internalSearch(this._rootFile, this._depth);
        }
        catch (Exception e) {
            UniversalServerUtilities.logError(this._miner.getName(), "Error occured when calling internal search", e, this._dataStore);
        }
        this._isDone = true;
        if (this._isCancelled) {
            this._miner.statusCancelled(this._status);
        } else {
            this._status.setAttribute(2, "done");
            this._dataStore.refresh(this._status);
        }
        this._alreadySearched.clear();
        this._dataStore.disconnectObjects(this._status);
    }

    public boolean isCancelled() {
        return this._isCancelled;
    }

    public boolean isDone() {
        return this._isDone;
    }

    public void cancel() {
        this._isCancelled = true;
    }

    protected boolean hasSearched(File file) {
        boolean result = false;
        String path = null;
        if (!this._searchOnlyUniqueFolders) {
            path = file.getAbsolutePath();
            result = this._alreadySearched.contains(path);
        } else {
            try {
                path = file.getCanonicalPath();
                result = this._alreadySearched.contains(path);
            }
            catch (Exception e) {
                result = this._alreadySearched.contains(file.getAbsolutePath());
                this._dataStore.trace((Throwable)e);
            }
        }
        return result;
    }

    protected void internalSearch(File theFile, int depth) throws SystemMessageException {
        if (!this.hasSearched(theFile)) {
            if (!this._searchOnlyUniqueFolders) {
                this._alreadySearched.add(theFile.getAbsolutePath());
            } else {
                try {
                    this._alreadySearched.add(theFile.getCanonicalPath());
                }
                catch (Exception e) {
                    this._alreadySearched.add(theFile.getAbsolutePath());
                    this._dataStore.trace((Throwable)e);
                }
            }
            boolean isDirectory = theFile.isDirectory();
            boolean isArchive = ArchiveHandlerManager.getInstance().isArchive(theFile);
            String absPath = theFile.getAbsolutePath();
            String compareStr = theFile.getName();
            boolean isVirtual = ArchiveHandlerManager.isVirtual((String)absPath);
            boolean isVirtualDirectory = false;
            if (isVirtual) {
                VirtualChild vc = ArchiveHandlerManager.getInstance().getVirtualObject(absPath);
                boolean bl = isVirtualDirectory = isVirtual && vc.isDirectory;
            }
            if (!isDirectory && (!isArchive || this._isFileSearch) && !isVirtualDirectory && this.doesFilePatternMatch(compareStr) && this.doesClassificationMatch(absPath)) {
                DataElement deObj = null;
                if (ArchiveHandlerManager.isVirtual((String)absPath)) {
                    VirtualChild vc = ArchiveHandlerManager.getInstance().getVirtualObject(absPath);
                    if (!vc.isDirectory) {
                        deObj = this._dataStore.createObject(null, this._deVirtualFile, compareStr);
                        if (vc.path.equals("")) {
                            deObj.setAttribute(3, vc.getContainingArchive().getAbsolutePath());
                        } else {
                            deObj.setAttribute(3, String.valueOf(vc.getContainingArchive().getAbsolutePath()) + "#virtual#/" + vc.path);
                        }
                        deObj.setAttribute(4, this._miner.setProperties(vc));
                        SystemSearchLineMatch[] results = null;
                        if (!this._isFileSearch) {
                            results = vc.getHandler().search(vc.fullName, this._stringMatcher, null);
                            if (results != null && results.length > 0) {
                                this.convert(deObj, absPath, results);
                                deObj.setParent(this._status);
                                this._status.addNestedData(deObj, false);
                            }
                        } else {
                            deObj.setParent(this._status);
                            this._status.addNestedData(deObj, false);
                        }
                    }
                } else {
                    deObj = !isArchive ? this._dataStore.createObject(null, this._deFile, compareStr) : this._dataStore.createObject(null, this._deArchiveFile, compareStr);
                    deObj.setAttribute(3, theFile.getParentFile().getAbsolutePath());
                    deObj.setAttribute(4, this._miner.setProperties(theFile));
                    if (this._isFileSearch || this.internalSearchWithinFile(deObj, absPath, theFile)) {
                        deObj.setParent(this._status);
                        this._status.addNestedData(deObj, false);
                    }
                }
                this._dataStore.refresh(this._status);
                this._dataStore.disconnectObjects(this._status);
            }
            if (depth != 0 && (isDirectory || (isArchive || isVirtualDirectory) && this._searchString.isIncludeArchives())) {
                File[] children = null;
                if (isArchive || isVirtualDirectory) {
                    AbsoluteVirtualPath avp = new AbsoluteVirtualPath(absPath);
                    File archive = new File(avp.getContainingArchiveString());
                    String virtualPath = avp.getVirtualPart();
                    VirtualChild[] virtualchildren = null;
                    try {
                        virtualchildren = ArchiveHandlerManager.getInstance().getContents(archive, virtualPath);
                    }
                    catch (Exception e) {
                        UniversalServerUtilities.logError(this._miner.getName(), "Error occured trying to get the canonical file", e, this._dataStore);
                    }
                    if (virtualchildren != null) {
                        children = new File[virtualchildren.length];
                        int i = 0;
                        while (i < virtualchildren.length) {
                            AbsoluteVirtualPath newAvp = new AbsoluteVirtualPath(absPath);
                            newAvp.setVirtualPart(virtualchildren[i].fullName);
                            children[i] = new File(newAvp.toString());
                            ++i;
                        }
                        if (virtualchildren.length == 0) {
                            children = null;
                        }
                    }
                } else {
                    children = theFile.listFiles();
                }
                if (children != null) {
                    int i = 0;
                    while (i < children.length && !this._isCancelled) {
                        this.checkAndClearupMemory();
                        File child = children[i];
                        this.internalSearch(child, depth - 1);
                        ++i;
                    }
                }
            }
        }
    }

    protected boolean internalSearchWithinFile(DataElement remoteFile, String absPath, File theFile) {
        BufferedReader bufReader;
        long MAX_FILE;
        block8: {
            InputStreamReader reader;
            block9: {
                if (this._isFileSearch) {
                    return true;
                }
                FileInputStream inputStream = null;
                MAX_FILE = Runtime.getRuntime().freeMemory() / 4L;
                long fileLength = theFile.length();
                inputStream = new FileInputStream(theFile);
                reader = new InputStreamReader(inputStream);
                bufReader = new BufferedReader(reader);
                if (!this.isUnreadableBinary(bufReader) && fileLength <= MAX_FILE) break block8;
                long size = theFile.length();
                if (!this.simpleSearch(inputStream, size, this._stringMatcher)) break block9;
                bufReader.close();
                reader.close();
                return true;
            }
            bufReader.close();
            reader.close();
            return false;
        }
        try {
            boolean foundMatches;
            SystemSearchStringMatchLocator locator = new SystemSearchStringMatchLocator((Reader)bufReader, this._stringMatcher);
            SystemSearchLineMatch[] matches = locator.locateMatches();
            boolean bl = foundMatches = matches != null && matches.length > 0;
            if (foundMatches && (long)(matches.length * 500) < MAX_FILE) {
                this.convert(remoteFile, absPath, matches);
            }
            return foundMatches;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (SystemServiceManager.getInstance().getSystemService() == null) {
                System.exit(-1);
            }
            return false;
        }
        catch (Exception e) {
            UniversalServerUtilities.logError(this._miner.getName(), "Error occured when trying to locate matches", e, this._dataStore);
            remoteFile.setAttribute(3, e.getMessage());
            return false;
        }
    }

    private boolean simpleSearch(FileInputStream stream, long size, SystemSearchStringMatcher matcher) {
        byte[] bytes = new byte[(int)size];
        try {
            stream.read(bytes, 0, (int)size);
        }
        catch (Exception exception) {}
        String str = new String(bytes);
        return this._stringMatcher.matches(str);
    }

    private boolean isUnreadableBinary(BufferedReader reader) {
        try {
            reader.mark(1);
            reader.read();
            reader.reset();
        }
        catch (Exception exception) {
            return true;
        }
        return false;
    }

    protected boolean doesFilePatternMatch(String compareStr) {
        return this._fileNameMatcher.matches(compareStr);
    }

    protected boolean doesClassificationMatch(String absolutePath) {
        if (this._classificationString == null || this._classificationString.equals("")) {
            return true;
        }
        String classification = SystemFileClassifier.getInstance().classifyFile(absolutePath);
        return StringCompare.compare((String)this._classificationString, (String)classification, (boolean)true);
    }

    protected void convert(DataElement deObj, String absPath, SystemSearchLineMatch[] lineMatches) {
        SystemSearchLineMatch match = null;
        int i = 0;
        while (i < lineMatches.length) {
            match = lineMatches[i];
            DataElement obj = this._dataStore.createObject(deObj, this._deGrep, match.getLine(), absPath);
            obj.setAttribute(4, String.valueOf(obj.getSource()) + ':' + match.getLineNumber());
            ++i;
        }
        this._dataStore.disconnectObjects(deObj);
    }

    public void checkAndClearupMemory() {
        this._memoryManager.checkAndClearupMemory();
    }
}

