/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeleteExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;

public class CPPASTDeleteExpression
extends ASTNode
implements ICPPASTDeleteExpression {
    private IASTExpression operand;
    private boolean isGlobal;
    private boolean isVectored;
    private IASTImplicitName[] implicitNames = null;

    public CPPASTDeleteExpression() {
    }

    public CPPASTDeleteExpression(IASTExpression operand) {
        this.setOperand(operand);
    }

    public CPPASTDeleteExpression(CPPASTDeleteExpression from) {
        this.setOperand(from.operand);
    }

    public CPPASTDeleteExpression copy() {
        CPPASTDeleteExpression copy = new CPPASTDeleteExpression(this.operand == null ? null : this.operand.copy());
        copy.isGlobal = this.isGlobal;
        copy.isVectored = this.isVectored;
        copy.setOffsetAndLength(this);
        return copy;
    }

    public IASTExpression getOperand() {
        return this.operand;
    }

    public void setOperand(IASTExpression expression) {
        this.assertNotFrozen();
        this.operand = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(OPERAND);
        }
    }

    public void setIsGlobal(boolean global) {
        this.assertNotFrozen();
        this.isGlobal = global;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public void setIsVectored(boolean vectored) {
        this.assertNotFrozen();
        this.isVectored = vectored;
    }

    public boolean isVectored() {
        return this.isVectored;
    }

    public IASTImplicitName[] getImplicitNames() {
        if (this.implicitNames == null) {
            ICPPFunction deleteOperator;
            ICPPFunction destructor;
            ArrayList<CPPASTImplicitName> names = new ArrayList<CPPASTImplicitName>();
            if (!this.isVectored && (destructor = CPPSemantics.findImplicitlyCalledDestructor(this)) != null) {
                CPPASTImplicitName destructorName = new CPPASTImplicitName(destructor.getNameCharArray(), (IASTNode)this);
                destructorName.setBinding(destructor);
                destructorName.computeOperatorOffsets(this.operand, false);
                names.add(destructorName);
            }
            if (!this.isGlobal && (deleteOperator = CPPSemantics.findOverloadedOperator(this)) != null) {
                CPPASTImplicitName deleteName = new CPPASTImplicitName(deleteOperator.getNameCharArray(), (IASTNode)this);
                deleteName.setOperator(true);
                deleteName.setBinding(deleteOperator);
                deleteName.computeOperatorOffsets(this.operand, false);
                names.add(deleteName);
            }
            this.implicitNames = names.isEmpty() ? IASTImplicitName.EMPTY_NAME_ARRAY : names.toArray(new IASTImplicitName[names.size()]);
        }
        return this.implicitNames;
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (action.shouldVisitImplicitNames) {
            IASTImplicitName[] iASTImplicitNameArray = this.getImplicitNames();
            int n = iASTImplicitNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTImplicitName name = iASTImplicitNameArray[n2];
                if (!name.accept(action)) {
                    return false;
                }
                ++n2;
            }
        }
        if (this.operand != null && !this.operand.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public IType getExpressionType() {
        return CPPSemantics.VOID_TYPE;
    }

    public boolean isLValue() {
        return false;
    }
}

