/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui.views.variable;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.ptp.debug.internal.ui.PixelConverter;
import org.eclipse.ptp.debug.internal.ui.views.variable.ICheckProvider;
import org.eclipse.ptp.debug.internal.ui.views.variable.PVariableViewerSorter;
import org.eclipse.ptp.debug.ui.messages.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class PVariableCheckboxTableViewer
extends TableViewer
implements ICheckable {
    private ListenerList checkStateListeners = new ListenerList();
    private ICheckProvider checkProvider = null;
    protected static final String YES_VALUE = Messages.PVariableCheckboxTableViewer_0;
    protected static final String NO_VALUE = Messages.PVariableCheckboxTableViewer_1;
    private static final String CP_NAME = "name";
    private static final String CP_JOB = "job";
    private static final String CL_NAME = Messages.PVariableCheckboxTableViewer_2;
    private static final String CL_JOB = Messages.PVariableCheckboxTableViewer_3;

    public PVariableCheckboxTableViewer(Composite parent, int style) {
        super(parent, 0x20 | style);
        Table table = this.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        TableColumn[] columns = table.getColumns();
        columns[0].setResizable(false);
        columns[1].setResizable(true);
        columns[2].setResizable(true);
        columns[0].setText("");
        columns[1].setText(CL_NAME);
        columns[2].setText(CL_JOB);
        columns[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((PVariableViewerSorter)PVariableCheckboxTableViewer.this.getSorter()).setColumn(0);
                PVariableCheckboxTableViewer.this.refresh();
            }
        });
        columns[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((PVariableViewerSorter)PVariableCheckboxTableViewer.this.getSorter()).setColumn(1);
                PVariableCheckboxTableViewer.this.refresh();
            }
        });
        columns[2].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((PVariableViewerSorter)PVariableCheckboxTableViewer.this.getSorter()).setColumn(2);
                PVariableCheckboxTableViewer.this.refresh();
            }
        });
        PixelConverter pc = new PixelConverter((Control)parent);
        columns[0].setWidth(pc.convertWidthInCharsToPixels(3));
        columns[1].setWidth(pc.convertWidthInCharsToPixels(20));
        columns[2].setWidth(pc.convertWidthInCharsToPixels(20));
        this.setColumnProperties(new String[]{"", CP_NAME, CP_JOB});
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.checkStateListeners.add((Object)listener);
    }

    public void removeCheckStateListener(ICheckStateListener listener) {
        this.checkStateListeners.remove((Object)listener);
    }

    public void setCheckProvider(ICheckProvider checkProvider) {
        this.checkProvider = checkProvider;
    }

    private void fireCheckStateChanged(final CheckStateChangedEvent event) {
        Object[] array = this.checkStateListeners.getListeners();
        int i = 0;
        while (i < array.length) {
            final ICheckStateListener l = (ICheckStateListener)array[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.checkStateChanged(event);
                }
            });
            ++i;
        }
    }

    public void handleSelect(SelectionEvent event) {
        if (event.detail == 32) {
            super.handleSelect(event);
            TableItem item = (TableItem)event.item;
            Object data = item.getData();
            if (data != null) {
                this.fireCheckStateChanged(new CheckStateChangedEvent((ICheckable)this, data, item.getChecked()));
            }
        } else {
            super.handleSelect(event);
        }
    }

    public boolean getChecked(Object element) {
        Widget widget = this.findItem(element);
        if (widget instanceof TableItem) {
            return ((TableItem)widget).getChecked();
        }
        return false;
    }

    public boolean setChecked(Object element, boolean state) {
        Assert.isNotNull((Object)element);
        Widget widget = this.findItem(element);
        if (widget instanceof TableItem) {
            ((TableItem)widget).setChecked(state);
            return true;
        }
        return false;
    }

    protected void doUpdateItem(Widget widget, Object element, boolean fullMap) {
        super.doUpdateItem(widget, element, fullMap);
        if (widget instanceof TableItem && this.checkProvider != null) {
            ((TableItem)widget).setChecked(this.checkProvider.isCheck(element));
        }
    }
}

