/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.core.remotemake;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.internal.rdt.core.index.IndexBuildSequenceController;
import org.eclipse.ptp.internal.rdt.core.remotemake.RemoteProcessClosure;
import org.eclipse.ptp.rdt.core.serviceproviders.IRemoteExecutionServiceProvider;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.RemoteProcessAdapter;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.ProjectNotConfiguredException;
import org.eclipse.ptp.services.core.ServiceModelManager;

public class RemoteCommandLauncher
implements ICommandLauncher {
    protected IProject fProject;
    protected Process fProcess;
    protected IRemoteProcess fRemoteProcess;
    protected boolean fShowCommand;
    protected String[] fCommandArgs;
    protected String lineSeparator = "\r\n";
    protected String fErrorMessage;
    protected Map<String, String> remoteEnvMap;
    private boolean isCleanBuild;
    protected static final long DELAY = 50L;

    private boolean isCleanBuild(String[] args) {
        int i = 0;
        while (i < args.length) {
            if ("clean".equals(args[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Process execute(IPath commandPath, String[] args, String[] env, IPath changeToDirectory, IProgressMonitor monitor) throws CoreException {
        IServiceConfiguration serviceConfig;
        this.isCleanBuild = this.isCleanBuild(args);
        IndexBuildSequenceController projectStatus = IndexBuildSequenceController.getIndexBuildSequenceController(this.getProject());
        if (projectStatus != null) {
            projectStatus.setRuntimeBuildStatus(null);
        }
        this.fCommandArgs = this.constructCommandArray(commandPath.toPortableString(), args);
        if (this.getProject() == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rdt.core", "RemoteCommandLauncher has not been associated with a project."));
        }
        ServiceModelManager smm = ServiceModelManager.getInstance();
        try {
            serviceConfig = smm.getActiveConfiguration(this.getProject());
        }
        catch (ProjectNotConfiguredException projectNotConfiguredException) {
            return null;
        }
        IService buildService = smm.getService("org.eclipse.ptp.rdt.core.BuildService");
        IServiceProvider provider = serviceConfig.getServiceProvider(buildService);
        IRemoteExecutionServiceProvider executionProvider = null;
        if (provider instanceof IRemoteExecutionServiceProvider) {
            executionProvider = (IRemoteExecutionServiceProvider)provider;
        }
        if (executionProvider != null) {
            IRemoteConnection connection;
            IRemoteServices remoteServices = executionProvider.getRemoteServices();
            if (!remoteServices.isInitialized()) {
                remoteServices.initialize();
            }
            if (!(connection = executionProvider.getConnection()).isOpen()) {
                try {
                    connection.open(monitor);
                }
                catch (RemoteConnectionException e1) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rdt.core", "Error opening connection.", (Throwable)e1));
                }
            }
            LinkedList<String> command = new LinkedList<String>();
            command.add(commandPath.toString());
            int k = 0;
            while (k < args.length) {
                command.add(args[k]);
                ++k;
            }
            IRemoteProcessBuilder processBuilder = remoteServices.getProcessBuilder(connection, command);
            this.remoteEnvMap = processBuilder.environment();
            String[] stringArray = env;
            int n = env.length;
            int n2 = 0;
            while (n2 < n) {
                String envVar = stringArray[n2];
                String[] splitStr = envVar.split("=");
                this.remoteEnvMap.put(splitStr[0], splitStr[1]);
                ++n2;
            }
            IRemoteFileManager fileManager = remoteServices.getFileManager(connection);
            if (changeToDirectory != null && fileManager != null) {
                processBuilder.directory(fileManager.getResource(changeToDirectory.toString()));
            }
            processBuilder.redirectErrorStream(true);
            IRemoteProcess p = null;
            try {
                p = processBuilder.start();
            }
            catch (IOException e) {
                if (projectStatus != null) {
                    projectStatus.setRuntimeBuildStatus(IndexBuildSequenceController.STATUS_INCOMPLETE);
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rdt.core", "Error launching remote process.", (Throwable)e));
            }
            if (projectStatus != null && !this.isCleanBuild) {
                projectStatus.setBuildRunning();
            }
            this.fRemoteProcess = p;
            this.fProcess = new RemoteProcessAdapter(p);
            while (!p.isCompleted()) {
                try {
                    p.waitFor();
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.fProcess;
        }
        return null;
    }

    private String getCommandLine(String[] commandArgs) {
        if (this.fProject == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        if (this.fCommandArgs != null) {
            String[] stringArray = commandArgs;
            int n = commandArgs.length;
            int n2 = 0;
            while (n2 < n) {
                String commandArg = stringArray[n2];
                buf.append(commandArg);
                buf.append(' ');
                ++n2;
            }
            buf.append(this.lineSeparator);
        }
        return buf.toString();
    }

    protected String[] constructCommandArray(String command, String[] commandArgs) {
        String[] args = new String[1 + commandArgs.length];
        args[0] = command;
        System.arraycopy(commandArgs, 0, args, 1, commandArgs.length);
        return args;
    }

    public String getCommandLine() {
        return this.getCommandLine(this.getCommandArgs());
    }

    public String[] getCommandArgs() {
        return this.fCommandArgs;
    }

    public Properties getEnvironment() {
        return this.convertEnvMapToProperties();
    }

    private Properties convertEnvMapToProperties() {
        Properties properties = new Properties();
        for (String key : this.remoteEnvMap.keySet()) {
            properties.put(key, this.remoteEnvMap.get(key));
        }
        return properties;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public void setErrorMessage(String error) {
        this.fErrorMessage = error;
    }

    public void showCommand(boolean show) {
        this.fShowCommand = show;
    }

    protected void printCommandLine(OutputStream os) {
        if (os != null) {
            String cmd = this.getCommandLine(this.getCommandArgs());
            try {
                os.write(cmd.getBytes());
                os.flush();
            }
            catch (IOException iOException) {}
        }
    }

    public int waitAndRead(OutputStream out, OutputStream err) {
        if (this.fShowCommand) {
            this.printCommandLine(out);
        }
        if (this.fProcess == null) {
            return -1;
        }
        RemoteProcessClosure closure = new RemoteProcessClosure(this.fRemoteProcess, out, err);
        closure.runBlocking();
        return 0;
    }

    public int waitAndRead(OutputStream output, OutputStream err, IProgressMonitor monitor) {
        if (this.fShowCommand) {
            this.printCommandLine(output);
        }
        if (this.fProcess == null) {
            return -1;
        }
        RemoteProcessClosure closure = new RemoteProcessClosure(this.fRemoteProcess, output, err);
        closure.runNonBlocking();
        while (!monitor.isCanceled() && closure.isAlive()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        int state = 0;
        IndexBuildSequenceController projectStatus = IndexBuildSequenceController.getIndexBuildSequenceController(this.getProject());
        if (monitor.isCanceled()) {
            closure.terminate();
            state = 1;
            this.setErrorMessage(CCorePlugin.getResourceString((String)"CommandLauncher.error.commandCanceled"));
            if (projectStatus != null) {
                projectStatus.setRuntimeBuildStatus(IndexBuildSequenceController.STATUS_INCOMPLETE);
            }
        }
        try {
            this.fProcess.waitFor();
        }
        catch (InterruptedException interruptedException) {}
        try {
            this.getProject().refreshLocal(2, null);
        }
        catch (CoreException coreException) {}
        if (projectStatus != null) {
            if (this.isCleanBuild) {
                projectStatus.setBuildInCompletedForCleanBuild();
            } else if (projectStatus.isIndexAfterBuildSet()) {
                projectStatus.invokeIndex();
            } else {
                projectStatus.setFinalBuildStatus();
            }
        }
        return state;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }
}

