/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.sdm.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.sdm.core.SDMDebugCorePlugin;
import org.eclipse.ptp.debug.sdm.core.messages.Messages;
import org.eclipse.ptp.debug.sdm.core.utils.DebugUtil;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDMRunner
extends Job {
    private List<String> command;
    private String workDir = null;
    private SDMMasterState sdmState = SDMMasterState.STARTING;
    private IPJob ipJob = null;
    private IResourceManagerControl rmControl = null;
    private IRemoteProcess sdmProcess;

    public SDMRunner(IResourceManagerControl rmControl) {
        super(Messages.SDMRunner_0);
        this.setPriority(30);
        this.setSystem(true);
        this.rmControl = rmControl;
        DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING_MORE, Messages.SDMRunner_4);
    }

    public void setCommand(List<String> command) {
        DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING_MORE, Messages.SDMRunner_5, command.toString());
        this.command = command;
    }

    public void setWorkDir(String workDir) {
        DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING_MORE, Messages.SDMRunner_6, workDir);
        this.workDir = workDir;
    }

    public synchronized SDMMasterState getSdmState() {
        return this.sdmState;
    }

    protected synchronized void setSdmState(SDMMasterState sdmState) {
        DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING_MORE, Messages.SDMRunner_7, sdmState.toString());
        this.sdmState = sdmState;
        ((Object)((Object)this)).notifyAll();
    }

    public void setJob(IPJob ipJob) {
        DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING_MORE, Messages.SDMRunner_8, ipJob.getID());
        this.ipJob = ipJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        IStatus iStatus;
        assert (this.command != null);
        assert (this.sdmProcess == null);
        DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, Messages.SDMRunner_9);
        try {
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            IResourceManagerConfiguration configuration = this.rmControl.getConfiguration();
            IRemoteServices remoteServices = PTPRemoteCorePlugin.getDefault().getRemoteServices(configuration.getRemoteServicesId());
            IRemoteConnectionManager connectionManager = remoteServices.getConnectionManager();
            IRemoteConnection connection = connectionManager.getConnection(configuration.getConnectionName());
            IRemoteFileManager fileManager = remoteServices.getFileManager(connection);
            IRemoteProcessBuilder sdmProcessBuilder = remoteServices.getProcessBuilder(connection, this.command);
            if (this.workDir != null) {
                sdmProcessBuilder.directory(fileManager.getResource(this.workDir));
            }
            DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, Messages.SDMRunner_10);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            SDMRunner sDMRunner = this;
            synchronized (sDMRunner) {
                ((Object)((Object)this)).wait(3000L);
            }
            DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, Messages.SDMRunner_11);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            sDMRunner = this;
            synchronized (sDMRunner) {
                this.sdmProcess = sdmProcessBuilder.start();
            }
            final BufferedReader err_reader = new BufferedReader(new InputStreamReader(this.sdmProcess.getErrorStream()));
            final BufferedReader out_reader = new BufferedReader(new InputStreamReader(this.sdmProcess.getInputStream()));
            if (DebugUtil.SDM_MASTER_OUTPUT_TRACING) {
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            String output;
                            while ((output = out_reader.readLine()) != null) {
                                System.out.println(String.valueOf(Messages.SDMRunner_12) + output);
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }, Messages.SDMRunner_13).start();
            }
            if (DebugUtil.SDM_MASTER_OUTPUT_TRACING) {
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            String line;
                            while ((line = err_reader.readLine()) != null) {
                                System.err.println(String.valueOf(Messages.SDMRunner_14) + line);
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }, Messages.SDMRunner_15).start();
            }
            this.setSdmState(SDMMasterState.RUNNING);
            DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING_MORE, Messages.SDMRunner_16);
            while (!this.sdmProcess.isCompleted()) {
                SDMRunner sDMRunner2 = this;
                synchronized (sDMRunner2) {
                    ((Object)((Object)this)).wait(500L);
                }
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
            DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, Messages.SDMRunner_17, this.sdmProcess.exitValue());
            if (this.sdmProcess.exitValue() != 0) {
                if (!monitor.isCanceled()) {
                    throw new CoreException((IStatus)new Status(4, SDMDebugCorePlugin.getUniqueIdentifier(), NLS.bind((String)Messages.SDMRunner_2, (Object)this.sdmProcess.exitValue())));
                }
                DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, Messages.SDMRunner_18);
            }
            this.setSdmState(SDMMasterState.FINISHED);
            iStatus = Status.OK_STATUS;
        }
        catch (Exception e) {
            block47: {
                block46: {
                    IStatus iStatus2;
                    try {
                        DebugUtil.error(DebugUtil.SDM_MASTER_TRACING, Messages.SDMRunner_19, e);
                        this.setSdmState(SDMMasterState.ERROR);
                        SDMRunner remoteServices = this;
                        synchronized (remoteServices) {
                            DebugUtil.error(DebugUtil.SDM_MASTER_TRACING, Messages.SDMRunner_20, e);
                            this.sdmProcess.destroy();
                        }
                        try {
                            DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, Messages.SDMRunner_21, this.ipJob.getID());
                            this.rmControl.terminateJob(this.ipJob);
                        }
                        catch (CoreException e1) {
                            PTPDebugCorePlugin.log((Throwable)e1);
                        }
                        if (!(e instanceof InterruptedException)) break block46;
                        iStatus2 = Status.CANCEL_STATUS;
                    }
                    catch (Throwable throwable) {
                        DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, Messages.SDMRunner_22);
                        SDMRunner sDMRunner = this;
                        synchronized (sDMRunner) {
                            this.sdmProcess = null;
                        }
                        throw throwable;
                    }
                    DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, Messages.SDMRunner_22);
                    SDMRunner sDMRunner = this;
                    synchronized (sDMRunner) {
                        this.sdmProcess = null;
                    }
                    return iStatus2;
                }
                if (!(e instanceof CoreException)) break block47;
                IStatus iStatus3 = ((CoreException)((Object)e)).getStatus();
                DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, Messages.SDMRunner_22);
                SDMRunner sDMRunner = this;
                synchronized (sDMRunner) {
                    this.sdmProcess = null;
                }
                return iStatus3;
            }
            Status status = new Status(4, SDMDebugCorePlugin.getUniqueIdentifier(), Messages.SDMRunner_3, (Throwable)e);
            DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, Messages.SDMRunner_22);
            SDMRunner sDMRunner = this;
            synchronized (sDMRunner) {
                this.sdmProcess = null;
            }
            return status;
        }
        DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, Messages.SDMRunner_22);
        SDMRunner sDMRunner = this;
        synchronized (sDMRunner) {
            this.sdmProcess = null;
        }
        return iStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void canceling() {
        SDMRunner sDMRunner = this;
        synchronized (sDMRunner) {
            if (this.sdmProcess != null) {
                this.sdmProcess.destroy();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SDMMasterState {
        UNKNOWN,
        STARTING,
        RUNNING,
        FINISHED,
        ERROR;

    }
}

