/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.pbs.jproxy.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ptp.rm.proxy.core.attributes.AttributeDefinition;
import org.eclipse.ptp.rm.proxy.core.element.Element;
import org.eclipse.ptp.rm.proxy.core.element.IElement;
import org.eclipse.ptp.rm.proxy.core.parser.IParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QstatQueuesReader
implements IParser {
    private Set<IElement> queues;

    private void _parse(InputStream in, AttributeDefinition attrDef) throws IOException, IElement.UnknownValueExecption {
        String line;
        this.queues = new HashSet<IElement>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        Pattern queuepattern = Pattern.compile("^[Qq]ueue:(.*)$");
        Pattern keyvalpattern = Pattern.compile("^([^=]+)=(.+)$");
        ArrayList qhashes = new ArrayList();
        HashMap<String, String> thisqueue = new HashMap<String, String>();
        boolean firstqueue = true;
        while ((line = reader.readLine()) != null) {
            Matcher matcher = queuepattern.matcher(line);
            boolean newqueue = matcher.find();
            if (newqueue) {
                if (!firstqueue) {
                    qhashes.add(thisqueue);
                } else {
                    firstqueue = false;
                }
                thisqueue = new HashMap();
                thisqueue.put("name", matcher.group(1).trim());
                continue;
            }
            Matcher mkv = keyvalpattern.matcher(line);
            if (!mkv.find() || mkv.groupCount() != 2) continue;
            String skey = mkv.group(1).trim().toLowerCase();
            String svalue = mkv.group(2).trim();
            thisqueue.put(skey, svalue);
        }
        if (!firstqueue) {
            qhashes.add(thisqueue);
        }
        for (HashMap hashMap : qhashes) {
            Element e = attrDef.createElement();
            for (String attr : attrDef.getRequiredAttributes()) {
                e.setAttribute(attr, (String)hashMap.get(attr));
            }
            this.queues.add((IElement)e);
        }
    }

    private Set<IElement> getQueues() {
        return this.queues;
    }

    public Set<IElement> parse(AttributeDefinition attrDef, InputStream in) throws IOException, IElement.UnknownValueExecption {
        HashSet<IElement> queues = new HashSet();
        this._parse(in, attrDef);
        queues = this.getQueues();
        return queues;
    }
}

