/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;

public class CPPASTNamespaceDefinition
extends ASTNode
implements ICPPASTNamespaceDefinition,
IASTAmbiguityParent {
    private IASTName fName;
    private IASTDeclaration[] fAllDeclarations;
    private IASTDeclaration[] fActiveDeclarations;
    private int fLastDeclaration = -1;

    public CPPASTNamespaceDefinition() {
    }

    public CPPASTNamespaceDefinition(IASTName name) {
        this.setName(name);
    }

    public CPPASTNamespaceDefinition copy() {
        CPPASTNamespaceDefinition copy = new CPPASTNamespaceDefinition(this.fName == null ? null : this.fName.copy());
        IASTDeclaration[] iASTDeclarationArray = this.getDeclarations();
        int n = iASTDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration declaration = iASTDeclarationArray[n2];
            copy.addDeclaration(declaration == null ? null : declaration.copy());
            ++n2;
        }
        copy.setOffsetAndLength(this);
        return copy;
    }

    public IASTName getName() {
        return this.fName;
    }

    public void setName(IASTName name) {
        this.assertNotFrozen();
        this.fName = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(NAMESPACE_NAME);
        }
    }

    public final void addDeclaration(IASTDeclaration decl) {
        if (decl != null) {
            decl.setParent(this);
            decl.setPropertyInParent(OWNED_DECLARATION);
            this.fAllDeclarations = (IASTDeclaration[])ArrayUtil.append(IASTDeclaration.class, this.fAllDeclarations, ++this.fLastDeclaration, decl);
            this.fActiveDeclarations = null;
        }
    }

    public final IASTDeclaration[] getDeclarations() {
        IASTDeclaration[] active = this.fActiveDeclarations;
        if (active == null) {
            active = ASTQueries.extractActiveDeclarations(this.fAllDeclarations, this.fLastDeclaration + 1);
            this.fActiveDeclarations = active;
        }
        return active;
    }

    public final IASTDeclaration[] getDeclarations(boolean includeInactive) {
        if (includeInactive) {
            this.fAllDeclarations = (IASTDeclaration[])ArrayUtil.removeNullsAfter(IASTDeclaration.class, this.fAllDeclarations, this.fLastDeclaration);
            return this.fAllDeclarations;
        }
        return this.getDeclarations();
    }

    public IScope getScope() {
        try {
            return ((ICPPNamespace)this.fName.resolveBinding()).getNamespaceScope();
        }
        catch (DOMException e) {
            return e.getProblem();
        }
    }

    public boolean accept(ASTVisitor action) {
        IASTDeclaration[] decls;
        if (action.shouldVisitNamespaces && action instanceof ICPPASTVisitor) {
            switch (((ICPPASTVisitor)((Object)action)).visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.fName != null && !this.fName.accept(action)) {
            return false;
        }
        IASTDeclaration[] iASTDeclarationArray = decls = this.getDeclarations(action.includeInactiveNodes);
        int n = decls.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration decl = iASTDeclarationArray[n2];
            if (!decl.accept(action)) {
                return false;
            }
            ++n2;
        }
        return !action.shouldVisitNamespaces || !(action instanceof ICPPASTVisitor) || ((ICPPASTVisitor)((Object)action)).leave(this) != 2;
    }

    public int getRoleForName(IASTName n) {
        if (this.fName == n) {
            return 2;
        }
        return 3;
    }

    public void replace(IASTNode child, IASTNode other) {
        assert (child.isActive() == other.isActive());
        int i = 0;
        while (i <= this.fLastDeclaration) {
            if (this.fAllDeclarations[i] == child) {
                other.setParent(child.getParent());
                other.setPropertyInParent(child.getPropertyInParent());
                this.fAllDeclarations[i] = (IASTDeclaration)other;
                this.fActiveDeclarations = null;
                return;
            }
            ++i;
        }
    }
}

