/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.util.List;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDirective;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.internal.core.parser.scanner.AbstractCharArray;
import org.eclipse.cdt.internal.core.parser.scanner.IncludeSearchPathElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalFileContent
extends FileContent {
    private final InclusionKind fKind;
    private final AbstractCharArray fSource;
    private final List<IIndexMacro> fMacroDefinitions;
    private final List<ICPPUsingDirective> fUsingDirectives;
    private final String fFileLocation;
    private boolean fHeuristic;
    private boolean fIsSource = false;
    private List<IIndexFile> fFiles;
    private IncludeSearchPathElement fFoundOnPath;

    public InternalFileContent(String fileLocation, InclusionKind kind) throws IllegalArgumentException {
        if (fileLocation == null || kind != InclusionKind.SKIP_FILE) {
            throw new IllegalArgumentException();
        }
        this.fKind = kind;
        this.fFileLocation = fileLocation;
        this.fMacroDefinitions = null;
        this.fUsingDirectives = null;
        this.fSource = null;
    }

    public InternalFileContent(String filePath, AbstractCharArray content) throws IllegalArgumentException {
        if (content == null) {
            throw new IllegalArgumentException();
        }
        this.fKind = InclusionKind.USE_SOURCE;
        this.fFileLocation = filePath;
        this.fSource = content;
        this.fMacroDefinitions = null;
        this.fUsingDirectives = null;
        if (this.fFileLocation == null) {
            throw new IllegalArgumentException();
        }
    }

    public InternalFileContent(String fileLocation, List<IIndexMacro> macroDefinitions, List<ICPPUsingDirective> usingDirectives, List<IIndexFile> files) {
        this.fKind = InclusionKind.FOUND_IN_INDEX;
        this.fFileLocation = fileLocation;
        this.fSource = null;
        this.fUsingDirectives = usingDirectives;
        this.fMacroDefinitions = macroDefinitions;
        this.fFiles = files;
    }

    public InclusionKind getKind() {
        return this.fKind;
    }

    @Override
    public String getFileLocation() {
        return this.fFileLocation;
    }

    @Override
    public long getContentsHash() {
        return this.fSource != null ? this.fSource.getContentsHash() : 0L;
    }

    public AbstractCharArray getSource() {
        return this.fSource;
    }

    public List<IIndexMacro> getMacroDefinitions() {
        return this.fMacroDefinitions;
    }

    public List<ICPPUsingDirective> getUsingDirectives() {
        return this.fUsingDirectives;
    }

    public List<IIndexFile> getFilesIncluded() {
        return this.fFiles;
    }

    public boolean isFoundByHeuristics() {
        return this.fHeuristic;
    }

    public void setFoundByHeuristics(boolean val) {
        this.fHeuristic = val;
    }

    public boolean isSource() {
        return this.fIsSource;
    }

    public void setIsSource(boolean isSource) {
        this.fIsSource = isSource;
    }

    public IncludeSearchPathElement getFoundOnPath() {
        return this.fFoundOnPath;
    }

    public void setFoundOnPath(IncludeSearchPathElement isp) {
        this.fFoundOnPath = isp;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InclusionKind {
        SKIP_FILE,
        FOUND_IN_INDEX,
        USE_SOURCE;

    }
}

