/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.gem.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.window.Window;
import org.eclipse.ptp.gem.GemPlugin;
import org.eclipse.ptp.gem.messages.Messages;
import org.eclipse.ptp.gem.util.CommandThread;
import org.eclipse.ptp.gem.util.NumProcsValidator;
import org.eclipse.ptp.gem.util.Transitions;
import org.eclipse.ptp.gem.views.GemAnalyzer;
import org.eclipse.ptp.gem.views.GemBrowser;
import org.eclipse.ptp.gem.views.GemConsole;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class GemUtilities {
    private static Process process;
    private static IRemoteProcess remoteProcess;
    private static GemAnalyzer analyzer;
    private static GemBrowser browser;
    private static GemConsole console;
    protected static TaskStatus taskStatus;
    private static boolean doCompile;
    private static boolean doVerify;
    private static String consoleStdOutMessage;
    private static String consoleStdErrMessage;
    private static String outputSameMessage;
    private static String outputSameDetails;
    private static IFile gemInputFile;
    private static IFile gemLogFile;
    private static final Thread updateGemConsoleThread;

    static {
        updateGemConsoleThread = new Thread(){

            public void run() {
                IWorkbench wb = PlatformUI.getWorkbench();
                IWorkbenchWindow window = wb.getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                GemConsole gemConsole = null;
                IViewPart gemViewPart = null;
                try {
                    page.showView("org.eclipse.ptp.gem.views.GemConsole");
                    gemViewPart = page.findView("org.eclipse.ptp.gem.views.GemConsole");
                    gemConsole = (GemConsole)gemViewPart;
                    gemConsole.writeStdOut(consoleStdOutMessage);
                    gemConsole.writeStdErr(consoleStdErrMessage);
                }
                catch (Exception e) {
                    GemUtilities.logExceptionDetail(e);
                }
            }
        };
    }

    private static void cancelAnalysis() {
        analyzer.clear();
        browser.clear();
        console.cancel();
        taskStatus = TaskStatus.IDLE;
    }

    private static void compareOutput(String consoleStdIn) {
        ArrayList<String> outputs = new ArrayList<String>();
        Scanner scanner = new Scanner(consoleStdIn);
        int interIndex = -1;
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (line.contains("INTERLEAVING :")) {
                outputs.add("");
                ++interIndex;
                continue;
            }
            outputs.set(interIndex, ((String)outputs.get(interIndex)).concat("\n" + line));
        }
        interIndex = 1;
        while (interIndex < outputs.size()) {
            if (!((String)outputs.get(0)).equals(outputs.get(interIndex))) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(Messages.GemUtilities_19);
                stringBuffer.append((String)outputs.get(0));
                stringBuffer.append("\n");
                stringBuffer.append("\n");
                stringBuffer.append(Messages.GemUtilities_22);
                stringBuffer.append((String)outputs.get(interIndex));
                outputSameDetails = stringBuffer.toString();
                stringBuffer.setLength(0);
                stringBuffer.append(Messages.GemUtilities_23);
                stringBuffer.append(" ");
                stringBuffer.append(interIndex - 1);
                stringBuffer.append(" ");
                stringBuffer.append(Messages.GemUtilities_26);
                outputSameMessage = stringBuffer.toString();
                return;
            }
            ++interIndex;
        }
        outputSameMessage = Messages.GemUtilities_27;
    }

    public static void doHbv(IFile inputFile) {
        String projectName = inputFile.getProject().getName();
        IProject currentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        String relativeLogFilePath = GemUtilities.getLogfilePath(inputFile);
        IFile logFile = currentProject.getFile((IPath)new Path(relativeLogFilePath));
        GemUtilities.refreshProject(currentProject);
        if (!logFile.exists()) {
            GemUtilities.showInformationDialog(Messages.GemUtilities_2);
            if (GemUtilities.doIspcc(inputFile) != -1) {
                GemUtilities.doIsp(inputFile);
            }
        }
        IFolder gemFolder = currentProject.getFolder((IPath)new Path("gem"));
        Path fullLogFilePath = new Path(gemFolder.getLocationURI().getPath());
        fullLogFilePath = fullLogFilePath.append(currentProject.getName()).removeFileExtension().addFileExtension("gem.log");
        String hbvPath = GemPlugin.getDefault().getPreferenceStore().getString("hbvPath");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(hbvPath);
        stringBuffer.append(hbvPath == "" ? "" : "/");
        stringBuffer.append("ispUI ");
        stringBuffer.append(fullLogFilePath);
        String hbvCommand = stringBuffer.toString();
        GemUtilities.runCommandAsThread(hbvCommand);
    }

    public static void doIsp(IFile inputFile) {
        IPreferenceStore pstore = GemPlugin.getDefault().getPreferenceStore();
        IProject currentProject = inputFile.getProject();
        gemLogFile = currentProject.getFile(GemUtilities.getLogfilePath(inputFile));
        IFolder gemFolder = currentProject.getFolder((IPath)new Path("gem"));
        if (!gemFolder.exists()) {
            try {
                gemFolder.create(true, true, null);
                GemUtilities.refreshProject(currentProject);
            }
            catch (CoreException e) {
                GemUtilities.logExceptionDetail((Exception)((Object)e));
            }
        }
        Path executablePath = null;
        if (inputFile.getFileExtension().equals("gem")) {
            executablePath = new Path(inputFile.getLocationURI().getPath());
        } else {
            executablePath = new Path(gemFolder.getLocationURI().getPath());
            executablePath = executablePath.append(currentProject.getName()).removeFileExtension().addFileExtension("gem");
        }
        Path logFilePath = new Path(gemFolder.getLocationURI().getPath());
        logFilePath = logFilePath.append(currentProject.getName()).removeFileExtension().addFileExtension("gem.log");
        int numprocs = pstore.getInt("numprocsPreference");
        int portnum = pstore.getInt("portPreference");
        int reportnum = pstore.getInt("reportNumPreference");
        boolean fibPreference = pstore.getBoolean("fibPreference");
        boolean mpiCallsPreference = pstore.getBoolean("mpiCallsPreference");
        boolean openmpPreference = pstore.getBoolean("openmpPreference");
        boolean blockingSendsPreference = pstore.getBoolean("blockingSendsPreference");
        boolean compareOutputPreference = pstore.getBoolean("compareOutput");
        boolean reportPreference = pstore.getBoolean("reportPreference");
        boolean unixSocketsPreference = pstore.getBoolean("unixSockets");
        boolean verbosePreference = pstore.getBoolean("verbosePreference");
        String hostName = pstore.getString("hostName");
        String ispExePath = pstore.getString(GemUtilities.isRemoteProject() ? "remoteIspPath" : "ispPath");
        ispExePath = String.valueOf(ispExePath) + (ispExePath == "" ? "" : "/");
        String cmdArgs = pstore.getString("cmdArgs");
        boolean available = GemUtilities.isPortAvailable(portnum);
        while (!available) {
            if (portnum < 1025) {
                portnum = 9999;
            }
            available = GemUtilities.isPortAvailable(--portnum);
        }
        pstore.setValue("portPreference", portnum);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ispExePath);
        stringBuffer.append("isp -n ");
        stringBuffer.append(numprocs);
        stringBuffer.append(" -p ");
        stringBuffer.append(portnum);
        stringBuffer.append(" ");
        stringBuffer.append(blockingSendsPreference ? "-b " : "");
        stringBuffer.append(compareOutputPreference ? "-P " : "");
        stringBuffer.append(mpiCallsPreference ? "-m " : "");
        stringBuffer.append(unixSocketsPreference ? "-x " : "");
        stringBuffer.append(!hostName.trim().equals("") ? "-h " : "");
        stringBuffer.append(!hostName.trim().equals("") ? String.valueOf(hostName) + " " : "");
        stringBuffer.append(verbosePreference ? "-O " : "");
        stringBuffer.append(openmpPreference ? "-s " : "");
        stringBuffer.append(reportPreference ? "-r " : "");
        stringBuffer.append(reportPreference ? String.valueOf(reportnum) + " " : "");
        stringBuffer.append(fibPreference ? "-f " : "");
        stringBuffer.append("-l ");
        stringBuffer.append(logFilePath);
        stringBuffer.append(" ");
        stringBuffer.append(executablePath);
        stringBuffer.append(" ");
        stringBuffer.append(cmdArgs);
        String ispCmd = stringBuffer.toString();
        String processName = executablePath.lastSegment();
        pstore.setValue("processName", processName);
        GemUtilities.runCommand(ispCmd, true);
        GemUtilities.refreshProject(currentProject);
    }

    public static int doIspcc(IFile inputFile) {
        Path gemFolderPath = new Path("gem");
        String projectName = inputFile.getProject().getName();
        IProject currentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IFolder gemFolder = currentProject.getFolder((IPath)gemFolderPath);
        if (!gemFolder.exists()) {
            try {
                gemFolder.create(1, true, null);
                GemUtilities.refreshProject(currentProject);
            }
            catch (CoreException e) {
                GemUtilities.logExceptionDetail((Exception)((Object)e));
            }
        }
        Path executablePath = new Path(gemFolder.getLocationURI().getPath());
        executablePath = executablePath.append(currentProject.getName()).addFileExtension("gem");
        String fileExtension = inputFile.getFileExtension();
        int exitValue = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (fileExtension.equals("c")) {
            String ispccPath = GemPlugin.getDefault().getPreferenceStore().getString(GemUtilities.isRemoteProject() ? "remoteIspccPath" : "ispccPath");
            stringBuffer.append(ispccPath);
            stringBuffer.append(ispccPath == "" ? "" : "/");
            stringBuffer.append("ispcc -o ");
            stringBuffer.append(executablePath);
            stringBuffer.append(" ");
            stringBuffer.append(inputFile.getLocationURI().getPath());
            String ispccStr = stringBuffer.toString();
            exitValue = GemUtilities.runCommand(ispccStr, true);
        } else {
            String ispCppPath = GemPlugin.getDefault().getPreferenceStore().getString(GemUtilities.isRemoteProject() ? "remoteIspcppPath" : "ispcppPath");
            stringBuffer.append(ispCppPath);
            stringBuffer.append(ispCppPath == "" ? "" : "/");
            stringBuffer.append("ispCC -o ");
            stringBuffer.append(executablePath);
            stringBuffer.append(" ");
            stringBuffer.append(inputFile.getLocationURI().getPath());
            String ispCppStr = stringBuffer.toString();
            exitValue = GemUtilities.runCommand(ispCppStr, true);
        }
        return exitValue;
    }

    public static int generateLogFile(IFile inputFile, boolean compile, boolean verify) {
        int exitStatus = 0;
        if (compile && taskStatus != TaskStatus.ABORTED) {
            exitStatus = GemUtilities.doIspcc(inputFile);
            if (exitStatus != -1 && taskStatus != TaskStatus.ABORTED) {
                GemUtilities.doIsp(inputFile);
            }
        } else if (verify && taskStatus != TaskStatus.ABORTED) {
            GemUtilities.doIsp(inputFile);
        }
        return exitStatus;
    }

    public static String getIspVersion() {
        String exePath = GemPlugin.getDefault().getPreferenceStore().getString(GemUtilities.isRemoteProject() ? "remoteIspPath" : "ispPath");
        exePath = String.valueOf(exePath) + (exePath == "" ? "" : "/");
        if (GemUtilities.runCommand(exePath = String.valueOf(exePath) + "isp -v", false) == -1) {
            return null;
        }
        Scanner scanner = new Scanner(consoleStdOutMessage);
        String version = scanner.nextLine();
        scanner.close();
        Pattern intraCbRegex = Pattern.compile("([0-9]+.[0-9]+.[0-9]+)$");
        Matcher versionMatcher = intraCbRegex.matcher(version);
        if (versionMatcher.find()) {
            return versionMatcher.group(1);
        }
        return null;
    }

    public static String getLogfilePath(IFile inputFile) {
        Path gemFolderPath;
        String projectName = inputFile.getProject().getName();
        IProject currentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IFolder gemFolder = currentProject.getFolder((IPath)(gemFolderPath = new Path("gem")));
        if (!gemFolder.exists()) {
            try {
                gemFolder.create(1, true, null);
            }
            catch (CoreException e) {
                GemUtilities.logExceptionDetail((Exception)((Object)e));
            }
        }
        IPath logFilePath = gemFolderPath.append(currentProject.getName()).removeFileExtension();
        logFilePath = logFilePath.addFileExtension("gem.log");
        return logFilePath.toString();
    }

    public static URI getMostRecentURI() {
        IPreferenceStore pstore = GemPlugin.getDefault().getPreferenceStore();
        String mostRecentURIStr = pstore.getString("mostRecentFile");
        URI mostRecentURI = null;
        try {
            mostRecentURI = new URI(mostRecentURIStr);
        }
        catch (URISyntaxException e) {
            GemUtilities.logExceptionDetail(e);
        }
        return mostRecentURI;
    }

    public static String getOutputSameDetails() {
        return outputSameDetails;
    }

    public static String getOutputSameMessage() {
        return outputSameMessage;
    }

    public static IFile getProjectLogFile() {
        return gemLogFile;
    }

    public static IRemoteConnection getRemoteConnection(IRemoteServices service) {
        IRemoteConnection currentConnection = null;
        IRemoteConnectionManager connectionManager = null;
        IRemoteConnection[] connections = null;
        if (service != null) {
            connectionManager = service.getConnectionManager();
        }
        if (connectionManager != null) {
            connections = connectionManager.getConnections();
        }
        if (connections != null) {
            IRemoteConnection[] iRemoteConnectionArray = connections;
            int n = connections.length;
            int n2 = 0;
            while (n2 < n) {
                IRemoteConnection connection = iRemoteConnectionArray[n2];
                if (connection.isOpen()) {
                    currentConnection = connection;
                    break;
                }
                ++n2;
            }
        }
        return currentConnection;
    }

    public static IRemoteFileManager getRemoteFileManager(IFile projectResource) {
        URI projectURI = projectResource.getProject().getLocationURI();
        String scheme = projectURI.getScheme();
        IRemoteServices service = GemUtilities.getRemoteService(scheme);
        IRemoteFileManager remoteFileManager = service.getFileManager(GemUtilities.getRemoteConnection(GemUtilities.getRemoteService(scheme)));
        return remoteFileManager;
    }

    public static IRemoteProcessBuilder getRemoteProcessBuilder(IProject currentProject, String[] args) {
        URI projectURI = currentProject.getLocationURI();
        String scheme = projectURI.getScheme();
        IRemoteServices currentService = GemUtilities.getRemoteService(scheme);
        IRemoteConnection currentConnection = GemUtilities.getRemoteConnection(currentService);
        IRemoteProcessBuilder rpb = currentService.getProcessBuilder(currentConnection, args);
        return rpb;
    }

    public static IRemoteServices getRemoteService(String scheme) {
        IRemoteServices[] services;
        IRemoteServices currentService = null;
        IRemoteServices[] iRemoteServicesArray = services = PTPRemoteCorePlugin.getDefault().getAllRemoteServices();
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            IRemoteServices service = iRemoteServicesArray[n2];
            if (service.getScheme().equals(scheme)) {
                currentService = service;
                break;
            }
            ++n2;
        }
        return currentService;
    }

    public static IFile getSourceFile(String fullPath, IResource resource) {
        String projectName = resource.getProject().getName();
        IProject currentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        String currentProjectPath = currentProject.getLocationURI().getPath();
        Path sourceFilePath = new Path(fullPath);
        sourceFilePath = sourceFilePath.makeRelativeTo((IPath)new Path(currentProjectPath));
        IFile sourceFile = currentProject.getFile((IPath)sourceFilePath);
        return sourceFile;
    }

    public static IFile getSourceFilePathFromLog(IFile logFile) {
        Scanner scanner = null;
        InputStream logFileStream = null;
        String sourceFilePathInfo = "";
        if (!logFile.exists()) {
            GemUtilities.refreshProject(logFile.getProject());
        }
        try {
            logFileStream = logFile.getContents(true);
        }
        catch (CoreException e) {
            GemUtilities.logExceptionDetail((Exception)((Object)e));
        }
        scanner = new Scanner(logFileStream);
        if (!scanner.hasNextLine()) {
            if (taskStatus != TaskStatus.ABORTED) {
                GemUtilities.showErrorDialog(Messages.GemUtilities_4);
            }
            return null;
        }
        scanner.nextLine();
        if (!scanner.hasNextLine()) {
            GemUtilities.showErrorDialog(Messages.GemUtilities_5);
            return null;
        }
        sourceFilePathInfo = scanner.nextLine();
        sourceFilePathInfo = sourceFilePathInfo.substring(sourceFilePathInfo.indexOf("/"), sourceFilePathInfo.lastIndexOf(" "));
        IFile sourceFile = GemUtilities.getSourceFile(sourceFilePathInfo, (IResource)logFile);
        try {
            try {
                if (logFileStream != null) {
                    logFileStream.close();
                }
            }
            catch (IOException e) {
                GemUtilities.logExceptionDetail(e);
                scanner.close();
            }
        }
        finally {
            scanner.close();
        }
        return sourceFile;
    }

    private static boolean hasCorrectIspVersion() {
        String ispVersion = GemUtilities.getIspVersion();
        if (ispVersion == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(ispVersion, ".", false);
        st.nextToken();
        int majorVersionNum = Integer.parseInt(st.nextToken());
        int minorVersionNum = Integer.parseInt(st.nextToken());
        if (majorVersionNum == 2) {
            return minorVersionNum >= 5;
        }
        return true;
    }

    public static void initGemViews(IFile inputFile, boolean compile, boolean verify) {
        gemInputFile = inputFile;
        doCompile = compile;
        doVerify = verify;
        if (taskStatus == TaskStatus.ACTIVE) {
            GemUtilities.showInformationDialog(Messages.GemUtilities_6);
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IViewPart gemViewPart = window.getActivePage().findView("org.eclipse.ptp.gem.views.GemAnalyzer");
        analyzer = (GemAnalyzer)gemViewPart;
        analyzer.clear();
        analyzer.init(inputFile);
        IViewPart browserPart = window.getActivePage().findView("org.eclipse.ptp.gem.views.GemBrowser");
        browser = (GemBrowser)browserPart;
        browser.clear();
        browser.init();
        IViewPart consolePart = window.getActivePage().findView("org.eclipse.ptp.gem.views.GemConsole");
        console = (GemConsole)consolePart;
        console.init();
        Thread initGemViewsThread = new Thread(){

            public void run() {
                taskStatus = TaskStatus.ACTIVE;
                if (GemUtilities.getIspVersion() == null) {
                    GemUtilities.cancelAnalysis();
                    return;
                }
                if (!GemUtilities.hasCorrectIspVersion() && taskStatus == TaskStatus.ACTIVE) {
                    GemUtilities.cancelAnalysis();
                    GemUtilities.showErrorDialog(Messages.GemUtilities_7);
                    return;
                }
                if (GemUtilities.generateLogFile(gemInputFile, doCompile, doVerify) == -1) {
                    GemUtilities.cancelAnalysis();
                    GemUtilities.showErrorDialog(Messages.GemUtilities_3);
                    return;
                }
                if (taskStatus == TaskStatus.ACTIVE) {
                    IFile logFile = null;
                    IFile sourceFile = null;
                    logFile = gemInputFile.getFileExtension().equals("log") ? gemInputFile : gemLogFile;
                    if (logFile == null) {
                        GemUtilities.cancelAnalysis();
                        GemUtilities.showErrorDialog(Messages.GemUtilities_14);
                        return;
                    }
                    Transitions transitions = null;
                    transitions = GemUtilities.initTransitions(logFile);
                    sourceFile = GemUtilities.getSourceFilePathFromLog(logFile);
                    if (transitions == null || sourceFile == null) {
                        GemUtilities.cancelAnalysis();
                        return;
                    }
                    if (analyzer != null) {
                        analyzer.update(sourceFile, transitions);
                    }
                    if (browser != null) {
                        browser.update(transitions);
                    }
                    if (console != null) {
                        console.cancel();
                    }
                    taskStatus = TaskStatus.IDLE;
                    IPreferenceStore pstore = GemPlugin.getDefault().getPreferenceStore();
                    String activeView = pstore.getString("activeViewPreference");
                    if (activeView.equals("analyzer")) {
                        analyzer.activate();
                    } else if (activeView.equals("browser")) {
                        browser.activate();
                    } else {
                        console.activate();
                    }
                }
            }
        };
        initGemViewsThread.start();
    }

    private static Transitions initTransitions(IFile logFile) {
        try {
            return new Transitions(logFile);
        }
        catch (ParseException e) {
            GemUtilities.logExceptionDetail(e);
            return null;
        }
    }

    public static boolean isAborted() {
        return taskStatus == TaskStatus.ABORTED;
    }

    private static boolean isPortAvailable(int portNum) {
        try {
            ServerSocket srv = new ServerSocket(portNum);
            srv.close();
            srv = null;
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isRemoteProject() {
        return gemInputFile.getLocation() == null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void killProcesses() {
        boolean isRemoteProject;
        IPreferenceStore pstore = GemPlugin.getDefault().getPreferenceStore();
        String processName = pstore.getString("processName");
        String command = "pkill " + processName;
        String projectName = gemInputFile.getProject().getName();
        IProject currentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        boolean bl = isRemoteProject = currentProject.getLocation() == null;
        if (isRemoteProject) {
            String[] args = command.split(" ", -1);
            IRemoteProcessBuilder rpb = GemUtilities.getRemoteProcessBuilder(currentProject, args);
            try {
                remoteProcess = rpb.start();
            }
            catch (IOException e) {
                GemUtilities.logExceptionDetail(e);
            }
            try {
                try {
                    remoteProcess = rpb.start();
                    return;
                }
                catch (IOException e) {
                    GemUtilities.logExceptionDetail(e);
                    if (remoteProcess != null) {
                        try {
                            remoteProcess.waitFor();
                        }
                        catch (InterruptedException e2) {
                            GemUtilities.logExceptionDetail(e2);
                        }
                        remoteProcess.destroy();
                    }
                    if (remoteProcess == null) return;
                    remoteProcess.destroy();
                }
                return;
            }
            finally {
                if (remoteProcess != null) {
                    try {
                        remoteProcess.waitFor();
                    }
                    catch (InterruptedException e) {
                        GemUtilities.logExceptionDetail(e);
                    }
                    remoteProcess.destroy();
                }
                if (remoteProcess != null) {
                    remoteProcess.destroy();
                }
            }
        }
        Process killProc = null;
        try {
            try {
                killProc = Runtime.getRuntime().exec(command);
                return;
            }
            catch (IOException e) {
                GemUtilities.logExceptionDetail(e);
                if (killProc != null) {
                    try {
                        killProc.waitFor();
                    }
                    catch (InterruptedException e3) {
                        GemUtilities.logExceptionDetail(e3);
                    }
                    killProc.destroy();
                }
                if (process == null) return;
                process.destroy();
            }
            return;
        }
        finally {
            if (killProc != null) {
                try {
                    killProc.waitFor();
                }
                catch (InterruptedException e) {
                    GemUtilities.logExceptionDetail(e);
                }
                killProc.destroy();
            }
            if (process != null) {
                process.destroy();
            }
        }
    }

    public static void logError(String message, Throwable exception) {
        Status status = new Status(4, "org.eclipse.ptp.gem", 4, message, exception);
        GemPlugin.getDefault().getLog().log((IStatus)status);
    }

    public static void logExceptionDetail(Exception e) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Messages.GemUtilities_1);
        stringBuffer.append("\"");
        stringBuffer.append("org.eclipse.ptp.gem");
        stringBuffer.append("\".");
        GemUtilities.logError(stringBuffer.toString(), e);
    }

    public static void refreshProject(IProject project) {
        try {
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            GemUtilities.logExceptionDetail((Exception)((Object)e));
        }
    }

    private static void requestCommandLineArgs() {
        String message = Messages.GemUtilities_28;
        IPreferenceStore pstore = GemPlugin.getDefault().getPreferenceStore();
        String prevArgs = pstore.getString("cmdArgs");
        String newArgs = JOptionPane.showInputDialog(null, message, prevArgs);
        if (newArgs != null) {
            pstore.setValue("cmdArgs", newArgs);
        }
    }

    public static int runCommand(String command, boolean verbose) {
        block13: {
            String projectName = gemInputFile.getProject().getName();
            IProject currentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            boolean isRemoteProject = currentProject.getLocation() == null;
            IPreferenceStore pstore = GemPlugin.getDefault().getPreferenceStore();
            StringBuffer stringBuffer = new StringBuffer();
            String stdOut = "";
            String stdOutResult = "";
            String stdErr = "";
            String stdErrResult = "";
            if (isRemoteProject) {
                String[] args = command.split(" ", -1);
                IRemoteProcessBuilder rpb = GemUtilities.getRemoteProcessBuilder(currentProject, args);
                remoteProcess = rpb.start();
            } else {
                process = Runtime.getRuntime().exec(command);
            }
            BufferedReader stdOutReader = new BufferedReader(new InputStreamReader(isRemoteProject ? remoteProcess.getInputStream() : process.getInputStream()));
            BufferedReader stdErrReader = new BufferedReader(new InputStreamReader(isRemoteProject ? remoteProcess.getErrorStream() : process.getErrorStream()));
            consoleStdOutMessage = "";
            consoleStdErrMessage = "";
            boolean clearConsole = pstore.getBoolean("clearConsolePreference");
            if (clearConsole) {
                console.clear();
            }
            try {
                while ((isRemoteProject ? remoteProcess != null : process != null) && (stdOut = stdOutReader.readLine()) != null && taskStatus == TaskStatus.ACTIVE) {
                    stringBuffer.append(stdOut);
                    stringBuffer.append("\n");
                    consoleStdOutMessage = String.valueOf(consoleStdOutMessage) + stdOut + "\n";
                    if (stdOutReader.ready()) continue;
                    GemUtilities.updateConsole(verbose, true);
                    consoleStdOutMessage = "";
                }
                stdOutResult = stringBuffer.toString();
                GemUtilities.updateConsole(verbose, true);
                stringBuffer.setLength(0);
                while ((isRemoteProject ? remoteProcess != null : process != null) && (stdErr = stdErrReader.readLine()) != null && taskStatus == TaskStatus.ACTIVE) {
                    stringBuffer.append(stdErr);
                    stringBuffer.append("\n");
                    consoleStdErrMessage = String.valueOf(consoleStdErrMessage) + stdErr + "\n";
                    if (stdErrReader.ready()) continue;
                    GemUtilities.updateConsole(verbose, true);
                    consoleStdErrMessage = "";
                }
                stdErrResult = stringBuffer.toString();
                GemUtilities.updateConsole(verbose, true);
            }
            catch (Exception e) {
                GemUtilities.logExceptionDetail(e);
                return -1;
            }
            consoleStdOutMessage = stdOutResult;
            consoleStdErrMessage = stdErrResult;
            outputSameMessage = "";
            outputSameDetails = "";
            if (verbose && pstore.getBoolean("compareOutput")) {
                GemUtilities.compareOutput(consoleStdOutMessage);
            }
            if (!(isRemoteProject ? remoteProcess == null : process == null)) break block13;
            return -1;
        }
        try {
            return consoleStdErrMessage.contains("ld returned 1 exit status") ? -1 : 1;
        }
        catch (IOException iOException) {
            StringTokenizer st = new StringTokenizer(command);
            String commandName = st.nextToken();
            commandName = new Path(commandName).lastSegment().toString();
            GemUtilities.showErrorDialog(String.valueOf(Messages.GemUtilities_8) + "\"" + commandName + "\"" + "\n" + Messages.GemUtilities_13);
        }
        catch (Exception e) {
            GemUtilities.logExceptionDetail(e);
        }
        return -1;
    }

    public static void runCommandAsThread(String command) {
        CommandThread thread = new CommandThread(command);
        thread.run();
    }

    public static void saveMostRecentURI(URI mostRecentURI) {
        String mostRecentURIStr = mostRecentURI.toString();
        IPreferenceStore pstore = GemPlugin.getDefault().getPreferenceStore();
        pstore.setValue("mostRecentFile", mostRecentURIStr);
    }

    public static void saveToLocalFile(File file, String content) {
        block12: {
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(file.getCanonicalPath()));
                    content.replaceAll("\n", System.getProperty("line.separator"));
                    writer.write(content);
                }
                catch (IOException e) {
                    GemUtilities.logExceptionDetail(e);
                    if (writer == null) break block12;
                    try {
                        writer.close();
                    }
                    catch (IOException e2) {
                        GemUtilities.logExceptionDetail(e2);
                    }
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        GemUtilities.logExceptionDetail(e);
                    }
                }
            }
        }
    }

    public static void setCommandLineArgs() {
        IPreferenceStore pstore = GemPlugin.getDefault().getPreferenceStore();
        if (pstore.getBoolean("requestArgs")) {
            GemUtilities.requestCommandLineArgs();
        } else {
            pstore.setValue("cmdArgs", "");
        }
    }

    public static void setNumProcesses() {
        IViewPart browserViewPart;
        Shell shell = Display.getCurrent().getActiveShell();
        IPreferenceStore pstore = GemPlugin.getDefault().getPreferenceStore();
        Integer numProcs = pstore.getInt("numprocsPreference");
        String title = Messages.GemUtilities_9;
        String message = Messages.GemUtilities_10;
        InputDialog dlg = new InputDialog(shell, title, message, numProcs.toString(), (IInputValidator)new NumProcsValidator());
        Window.setDefaultImage((Image)GemPlugin.getImageDescriptor("icons/processes.gif").createImage());
        dlg.open();
        if (dlg.getReturnCode() == 1) {
            return;
        }
        numProcs = Integer.parseInt(dlg.getValue());
        pstore.setValue("numprocsPreference", dlg.getValue());
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IViewPart gemViewPart = window.getActivePage().findView("org.eclipse.ptp.gem.views.GemAnalyzer");
        if (gemViewPart != null) {
            GemAnalyzer analyzer = (GemAnalyzer)gemViewPart;
            analyzer.updateDropDown();
        }
        if ((browserViewPart = (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()).getActivePage().findView("org.eclipse.ptp.gem.views.GemBrowser")) != null) {
            GemBrowser browser = (GemBrowser)browserViewPart;
            browser.updateDropDown();
        }
    }

    public static void setTaskStatus(TaskStatus state) {
        taskStatus = state;
    }

    public static void showErrorDialog(String message) {
        String title = Messages.GemUtilities_11;
        JOptionPane.showMessageDialog(null, message, title, 0);
    }

    public static void showExceptionDialog(String message, Exception e) {
        GemUtilities.showErrorDialog(message);
        e.printStackTrace();
    }

    public static void showInformationDialog(String message) {
        String title = Messages.GemUtilities_12;
        JOptionPane.showMessageDialog(null, message, title, 1);
    }

    public static void terminateOperation() {
        if (taskStatus != TaskStatus.IDLE) {
            taskStatus = TaskStatus.ABORTED;
            analyzer.clear();
            browser.clear();
            console.cancel();
            console.writeStdErr(String.valueOf(Messages.GemConsole_11) + "\n");
            GemUtilities.killProcesses();
        }
    }

    private static void updateConsole(boolean verbose, boolean showConsole) {
        if (verbose && showConsole) {
            try {
                Display.getDefault().syncExec((Runnable)updateGemConsoleThread);
            }
            catch (Exception e) {
                GemUtilities.logExceptionDetail(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TaskStatus {
        IDLE,
        ACTIVE,
        ABORTED;

    }
}

