/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import org.eclipse.ptp.remotetools.core.messages.Messages;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.internal.common.AbstractRemoteExecution;
import org.eclipse.ptp.remotetools.internal.common.Debug;
import org.eclipse.ptp.remotetools.internal.ssh.ExecutionManager;

public abstract class KillableExecution
extends AbstractRemoteExecution {
    private ChannelExec channel;
    private int PIID;
    private int PID;
    public static final int UNKNOWN = 0;
    public static final int SUCCESS_OK = 1;
    public static final int SUCCESS_ERROR = 2;
    public static final int ERROR_NOT_EXECUTABLE = 126;
    public static final int ERROR_NOT_FOUND = 127;
    public static final int INVALID_EXIT_CODE = 128;
    public static final int SIGHUP = 129;
    public static final int SIGINT = 130;
    public static final int SIGQUIT = 131;
    public static final int SIGILL = 132;
    public static final int SIGTRAP = 133;
    public static final int SIGIOT = 134;
    public static final int SIGBUS = 135;
    public static final int SIGFPE = 136;
    public static final int SIGKILL = 137;
    public static final int SIGUSR1 = 138;
    public static final int SIGSEGV = 139;
    public static final int SIGUSR2 = 140;
    public static final int SIGPIPE = 141;
    public static final int SIGALRM = 142;
    public static final int SIGTERM = 143;
    public static final int SIGSTKFLT = 144;
    public static final int SIGCHLD = 145;
    public static final int SIGCONT = 146;
    public static final int SIGSTOP = 147;
    public static final int SIGTSTP = 148;
    public static final int SIGTTIN = 149;
    public static final int SIGTTOU = 150;
    public static final int SIGURG = 151;
    public static final int SIGXCPU = 152;
    public static final int SIGXFSZ = 153;
    public static final int SIGVTALRM = 154;
    public static final int SIGPROF = 155;
    public static final int SIGWINCH = 156;
    public static final int SIGIO = 157;
    public static final int SIGPWR = 158;

    public KillableExecution(ExecutionManager executionManager) throws RemoteConnectionException {
        super(executionManager);
    }

    public void startExecution() throws RemoteConnectionException {
        try {
            this.getExecutionManager().registerOperation(this);
            this.getExecutionManager().getConnection().registerObservedExecution(this);
            this.channel.connect();
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(e.getLocalizedMessage());
        }
    }

    protected void notifyCancel() {
        this.getExecutionManager().unregisterOperation(this);
        this.getExecutionManager().getConnection().unregisterObservedExecution(this);
        this.getExecutionManager().getConnection().killExecution(this);
        this.getExecutionManager().getConnection().releaseChannel((Channel)this.channel);
        super.notifyCancel();
    }

    protected void notifyFinish() {
        this.getExecutionManager().unregisterOperation(this);
        this.getExecutionManager().getConnection().unregisterObservedExecution(this);
        this.getExecutionManager().getConnection().releaseChannel((Channel)this.channel);
        super.notifyFinish();
    }

    public void close() {
        if (this.isRunning()) {
            this.cancel();
        }
        super.close();
    }

    protected ChannelExec createChannel(boolean hasPTY) throws RemoteConnectionException {
        this.channel = this.getExecutionManager().getConnection().createExecChannel(hasPTY);
        this.channel.setPty(hasPTY);
        return this.channel;
    }

    protected void setCommandLine(String commandLine) {
        this.PIID = this.getExecutionManager().getConnection().createNextPIID();
        String newCommandLine = "/bin/sh -c '" + this.getExecutionManager().getConnection().getKillablePrefix(this) + "; " + commandLine + "'";
        Debug.println2(String.valueOf(Messages.KillableExecution_Debug_1) + newCommandLine);
        this.channel.setCommand(newCommandLine);
    }

    public int getReturnCode() {
        if (this.wasCanceled()) {
            return -1;
        }
        if (!this.wasFinished()) {
            throw new IllegalStateException();
        }
        return this.channel.getExitStatus();
    }

    public int getPID() {
        return this.PID;
    }

    public void setPID(int pid) {
        this.PID = pid;
    }

    public int getInternalID() {
        return this.PIID;
    }

    public boolean isRunning() {
        return !this.channel.isClosed();
    }

    public int getFinishStatus() {
        int code = this.getReturnCode();
        if (code == 0) {
            return 1;
        }
        if (code <= 125) {
            return 2;
        }
        if (code == 126) {
            return 126;
        }
        if (code == 127) {
            return 127;
        }
        if (code == 128) {
            return 0;
        }
        if (code == 255) {
            return 128;
        }
        if (code == 129) {
            return 129;
        }
        if (code == 130) {
            return 130;
        }
        if (code == 131) {
            return 131;
        }
        if (code == 132) {
            return 132;
        }
        if (code == 133) {
            return 133;
        }
        if (code == 134) {
            return 134;
        }
        if (code == 135) {
            return 135;
        }
        if (code == 136) {
            return 136;
        }
        if (code == 137) {
            return 137;
        }
        if (code == 138) {
            return 138;
        }
        if (code == 139) {
            return 139;
        }
        if (code == 140) {
            return 140;
        }
        if (code == 141) {
            return 141;
        }
        if (code == 142) {
            return 142;
        }
        if (code == 143) {
            return 143;
        }
        if (code == 144) {
            return 144;
        }
        if (code == 145) {
            return 145;
        }
        if (code == 146) {
            return 146;
        }
        if (code == 147) {
            return 147;
        }
        if (code == 148) {
            return 148;
        }
        if (code == 149) {
            return 149;
        }
        if (code == 150) {
            return 150;
        }
        if (code == 151) {
            return 151;
        }
        if (code == 152) {
            return 152;
        }
        if (code == 153) {
            return 153;
        }
        if (code == 154) {
            return 154;
        }
        if (code == 155) {
            return 155;
        }
        if (code == 156) {
            return 156;
        }
        if (code == 157) {
            return 157;
        }
        if (code == 158) {
            return 158;
        }
        return 0;
    }

    public String getFinishStatusText(int status) {
        switch (status) {
            case 1: {
                return Messages.KillableExecution_FinishStatus_Ok;
            }
            case 2: {
                return Messages.KillableExecution_FinishStatus_Error;
            }
            case 126: {
                return Messages.KillableExecution_FinishStatus_NotExecutable;
            }
            case 127: {
                return Messages.KillableExecution_FinishStatus_CommandNotFound;
            }
            case 128: {
                return Messages.KillableExecution_FinishStatus_InvalidExitCode;
            }
            case 129: {
                return Messages.KillableExecution_FinishStatus_Hangup;
            }
            case 130: {
                return Messages.KillableExecution_FinishStatus_TerminalInterrupt;
            }
            case 131: {
                return Messages.KillableExecution_FinishStatus_TerminalQuit;
            }
            case 132: {
                return Messages.KillableExecution_FinishStatus_IllegalInstruction;
            }
            case 133: {
                return Messages.KillableExecution_FinishStatus_TraceTrap;
            }
            case 134: {
                return Messages.KillableExecution_FinishStatus_IOTTrap;
            }
            case 135: {
                return Messages.KillableExecution_FinishStatus_BUSError;
            }
            case 136: {
                return Messages.KillableExecution_FinishStatus_FloatingPointException;
            }
            case 137: {
                return Messages.KillableExecution_FinishStatus_Kill;
            }
            case 138: {
                return Messages.KillableExecution_FinishStatus_UserDefinedSignal1;
            }
            case 139: {
                return Messages.KillableExecution_FinishStatus_InvalidMemorySegmentAccess;
            }
            case 140: {
                return Messages.KillableExecution_FinishStatus_UserDefinedSignal2;
            }
            case 141: {
                return Messages.KillableExecution_FinishStatus_BrokenPipe;
            }
            case 142: {
                return Messages.KillableExecution_FinishStatus_AlarmClock;
            }
            case 143: {
                return Messages.KillableExecution_FinishStatus_Termination;
            }
            case 144: {
                return Messages.KillableExecution_FinishStatus_StackFault;
            }
            case 145: {
                return Messages.KillableExecution_FinishStatus_ChildProcessStoppedOrExited;
            }
            case 146: {
                return Messages.KillableExecution_FinishStatus_ContinueExecuting;
            }
            case 147: {
                return Messages.KillableExecution_FinishStatus_StopExecuting;
            }
            case 148: {
                return Messages.KillableExecution_FinishStatus_TerminalStopSignal;
            }
            case 149: {
                return Messages.KillableExecution_FinishStatus_BackgroundProcessReadTTY;
            }
            case 150: {
                return Messages.KillableExecution_FinishStatus_BackgroundWriteTTY;
            }
            case 151: {
                return Messages.KillableExecution_FinishStatus_UrgentConditionSocket;
            }
            case 152: {
                return Messages.KillableExecution_FinishStatus_CPULimitExceeded;
            }
            case 153: {
                return Messages.KillableExecution_FinishStatus_FileSizeLimitExceeded;
            }
            case 154: {
                return Messages.KillableExecution_FinishStatus_VirtualAlarmClock;
            }
            case 155: {
                return Messages.KillableExecution_FinishStatus_ProfilingAlarmClock;
            }
            case 156: {
                return Messages.KillableExecution_FinishStatus_WindowSizeChange;
            }
            case 157: {
                return Messages.KillableExecution_FinishStatus_IOPossible;
            }
            case 158: {
                return Messages.KillableExecution_FinishStatus_PowerFailureRestart;
            }
        }
        return Messages.KillableExecution_FinishStatus_Unknown;
    }

    public boolean isException(int status) {
        return status >= 129 && status <= 158;
    }

    public boolean isOK(int status) {
        return status <= 125;
    }

    public boolean isExecutableError(int status) {
        return status >= 126 && status <= 128;
    }

    public boolean wasException() {
        return this.isException(this.getReturnCode());
    }

    public boolean wasOK() {
        return this.isOK(this.getReturnCode());
    }

    public boolean wasCommandError() {
        return this.isExecutableError(this.getReturnCode());
    }
}

