/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.elements.attributes.ElementAttributes;
import org.eclipse.ptp.debug.core.IPDebugConfiguration;
import org.eclipse.ptp.debug.core.IPDebugger;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.debug.ui.IPTPDebugUIConstants;
import org.eclipse.ptp.launch.AbstractParallelLaunchConfigurationDelegate;
import org.eclipse.ptp.launch.PTPLaunchPlugin;
import org.eclipse.ptp.launch.internal.RuntimeProcess;
import org.eclipse.ptp.launch.messages.Messages;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerControl;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;

public class ParallelLaunchConfigurationDelegate
extends AbstractParallelLaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        block14: {
            try {
                IPDebugger debugger;
                SubMonitor progress;
                block13: {
                    if (!(launch instanceof IPLaunch)) {
                        throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.ParallelLaunchConfigurationDelegate_Invalid_launch_object));
                    }
                    progress = SubMonitor.convert((IProgressMonitor)monitor, (int)110);
                    progress.setTaskName(NLS.bind((String)Messages.ParallelLaunchConfigurationDelegate_3, (Object)configuration.getName()));
                    progress.setWorkRemaining(90);
                    if (progress.isCanceled()) {
                        return;
                    }
                    progress.worked(10);
                    progress.subTask(Messages.ParallelLaunchConfigurationDelegate_4);
                    this.verifyLaunchAttributes(configuration, mode, (IProgressMonitor)progress.newChild(10));
                    this.copyExecutable(configuration, (IProgressMonitor)progress.newChild(10));
                    this.doPreLaunchSynchronization(configuration, (IProgressMonitor)progress.newChild(10));
                    this.switchPerspective(DebugUITools.getLaunchPerspective((ILaunchConfigurationType)configuration.getType(), (String)mode));
                    debugger = null;
                    try {
                        if (!mode.equals("debug")) break block13;
                        this.showPTPDebugView(IPTPDebugUIConstants.ID_VIEW_PARALLELDEBUG);
                        progress.subTask(Messages.ParallelLaunchConfigurationDelegate_6);
                        IPDebugConfiguration debugConfig = this.getDebugConfig(configuration);
                        debugger = debugConfig.getDebugger();
                        debugger.initialize(configuration, (IProgressMonitor)progress.newChild(10));
                        if (!progress.isCanceled()) break block13;
                        return;
                    }
                    catch (CoreException e) {
                        if (debugger != null) {
                            debugger.cleanup((IPLaunch)launch);
                        }
                        if (e.getStatus().getCode() != 8) {
                            throw e;
                        }
                        break block14;
                    }
                }
                progress.worked(10);
                progress.subTask(Messages.ParallelLaunchConfigurationDelegate_7);
                this.submitJob(configuration, mode, (IPLaunch)launch, debugger, (IProgressMonitor)progress.newChild(40));
                progress.worked(10);
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
    }

    private void terminateJob(IResourceManagerControl rm, String jobId) {
        try {
            rm.control(jobId, "TERMINATE", null);
        }
        catch (CoreException e1) {
            PTPLaunchPlugin.log(e1);
        }
    }

    protected void doCleanupLaunch(IPLaunch launch) {
        if (launch.getLaunchMode().equals("debug")) {
            try {
                IPDebugConfiguration debugConfig = this.getDebugConfig(launch.getLaunchConfiguration());
                IPDebugger debugger = debugConfig.getDebugger();
                debugger.cleanup(launch);
            }
            catch (CoreException e) {
                PTPLaunchPlugin.log(e);
            }
        }
    }

    protected void doCompleteJobLaunch(IPLaunch launch, IPDebugger debugger) {
        final String jobId = launch.getJobId();
        final IResourceManager rm = launch.getResourceManager();
        ILaunchConfiguration configuration = launch.getLaunchConfiguration();
        launch.setAttribute(ElementAttributes.getIdAttributeDefinition().getId(), jobId);
        new RuntimeProcess(launch, rm, jobId, null);
        if (launch.getLaunchMode().equals("debug")) {
            try {
                this.setDefaultSourceLocator((ILaunch)launch, configuration);
                IProject project = this.verifyProject(configuration);
                final DebuggerSession session = new DebuggerSession(jobId, launch, project, debugger);
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            new ProgressMonitorDialog(PTPLaunchPlugin.getActiveWorkbenchShell()).run(true, true, (IRunnableWithProgress)session);
                        }
                        catch (InterruptedException interruptedException) {
                            ParallelLaunchConfigurationDelegate.this.terminateJob((IResourceManagerControl)rm, jobId);
                        }
                        catch (InvocationTargetException e) {
                            PTPLaunchPlugin.errorDialog(Messages.ParallelLaunchConfigurationDelegate_0, e.getTargetException());
                            PTPLaunchPlugin.log(e.getCause());
                            ParallelLaunchConfigurationDelegate.this.terminateJob((IResourceManagerControl)rm, jobId);
                        }
                    }
                });
            }
            catch (CoreException e) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        PTPLaunchPlugin.errorDialog(Messages.ParallelLaunchConfigurationDelegate_1, e.getStatus());
                        PTPLaunchPlugin.log(e);
                        ParallelLaunchConfigurationDelegate.this.terminateJob((IResourceManagerControl)rm, jobId);
                    }
                });
            }
        }
    }

    protected void showPTPDebugView(final String viewID) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (display != null && !display.isDisposed()) {
            display.syncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage page;
                    IWorkbenchWindow window = PTPLaunchPlugin.getActiveWorkbenchWindow();
                    if (window != null && (page = window.getActivePage()) != null) {
                        try {
                            page.showView(viewID, null, 3);
                        }
                        catch (PartInitException partInitException) {}
                    }
                }
            });
        }
    }

    protected void switchPerspective(final String perspectiveID) {
        if (perspectiveID != null) {
            Display display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            if (display != null && !display.isDisposed()) {
                display.syncExec(new Runnable(){

                    public void run() {
                        IWorkbenchPage page;
                        IWorkbenchWindow window = PTPLaunchPlugin.getActiveWorkbenchWindow();
                        if (window != null && (page = window.getActivePage()) != null) {
                            if (page.getPerspective().getId().equals(perspectiveID)) {
                                return;
                            }
                            try {
                                window.getWorkbench().showPerspective(perspectiveID, window);
                            }
                            catch (WorkbenchException workbenchException) {}
                        }
                    }
                });
            }
        }
    }

    private class DebuggerSession
    implements IRunnableWithProgress {
        private final String fJobId;
        private final IPLaunch fLaunch;
        private final IProject fProject;
        private final IPDebugger fDebugger;

        public DebuggerSession(String jobId, IPLaunch launch, IProject project, IPDebugger debugger) {
            this.fJobId = jobId;
            this.fLaunch = launch;
            this.fProject = project;
            this.fDebugger = debugger;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(Messages.ParallelLaunchConfigurationDelegate_5, 10);
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
            try {
                try {
                    IPSession session = PTPDebugCorePlugin.getDebugModel().createDebugSession(this.fDebugger, this.fLaunch, this.fProject, (IProgressMonitor)subMon.newChild(2));
                    String app = ParallelLaunchConfigurationDelegate.this.getProgramName(this.fLaunch.getLaunchConfiguration());
                    String path = ParallelLaunchConfigurationDelegate.this.getProgramPath(this.fLaunch.getLaunchConfiguration());
                    String cwd = ParallelLaunchConfigurationDelegate.this.getWorkingDirectory(this.fLaunch.getLaunchConfiguration());
                    String[] args = ParallelLaunchConfigurationDelegate.this.getProgramArguments(this.fLaunch.getLaunchConfiguration());
                    session.connectToDebugger((IProgressMonitor)subMon.newChild(8), app, path, cwd, args);
                }
                catch (CoreException e) {
                    PTPDebugCorePlugin.getDebugModel().shutdownSession(this.fJobId);
                    throw new InvocationTargetException(e, e.getLocalizedMessage());
                }
            }
            finally {
                monitor.done();
            }
        }
    }
}

