/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.internal.core;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.internal.core.LocalConnection;

public class LocalFileManager
implements IRemoteFileManager {
    private final LocalConnection fConnection;

    public LocalFileManager(LocalConnection conn) {
        this.fConnection = conn;
    }

    public String getDirectorySeparator() {
        return System.getProperty("file.separator", "/");
    }

    public IFileStore getResource(String pathStr) {
        Path path = new Path(pathStr);
        if (!path.isAbsolute()) {
            path = new Path(this.fConnection.getWorkingDirectory()).append((IPath)path);
        }
        return EFS.getLocalFileSystem().getStore((IPath)path);
    }

    public String toPath(URI uri) {
        return URIUtil.toPath((URI)uri).toString();
    }

    public URI toURI(IPath path) {
        return URIUtil.toURI((IPath)path);
    }

    public URI toURI(String path) {
        return URIUtil.toURI((String)path);
    }
}

