/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.monitor.core;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ptp.core.elements.IPResourceManager;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.remote.core.server.RemoteServerManager;
import org.eclipse.ptp.rm.core.rmsystem.AbstractRemoteResourceManagerConfiguration;
import org.eclipse.ptp.rm.jaxb.control.JAXBResourceManagerConfiguration;
import org.eclipse.ptp.rm.jaxb.core.data.MonitorDriverType;
import org.eclipse.ptp.rm.jaxb.core.data.MonitorType;
import org.eclipse.ptp.rm.jaxb.core.data.ResourceManagerData;
import org.eclipse.ptp.rm.jaxb.core.data.SimpleCommandType;
import org.eclipse.ptp.rm.lml.core.JobStatusData;
import org.eclipse.ptp.rm.lml.core.LMLManager;
import org.eclipse.ptp.rm.lml.da.server.core.LMLDAServer;
import org.eclipse.ptp.rm.lml.internal.core.elements.CommandType;
import org.eclipse.ptp.rm.lml.internal.core.elements.DriverType;
import org.eclipse.ptp.rm.lml.internal.core.elements.RequestType;
import org.eclipse.ptp.rm.lml.monitor.LMLMonitorCorePlugin;
import org.eclipse.ptp.rm.lml.monitor.core.messages.Messages;
import org.eclipse.ptp.rmsystem.AbstractResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.AbstractResourceManagerMonitor;
import org.eclipse.ptp.rmsystem.IJobStatus;
import org.eclipse.ptp.ui.IRMSelectionListener;
import org.eclipse.ptp.ui.PTPUIPlugin;
import org.eclipse.ptp.ui.managers.RMManager;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class LMLResourceManagerMonitor
extends AbstractResourceManagerMonitor {
    private static final String USER_JOBS = "user-jobs";
    private static final int JOB_SCHEDULE_FREQUENCY = 60000;
    private static final RMListener fListener = new RMListener();
    private MonitorJob fMonitorJob = null;
    private final RMManager fRMManager = PTPUIPlugin.getDefault().getRMManager();
    private final LMLManager fLMLManager = LMLManager.getInstance();
    private static final String LAYOUT = "layout";
    private static final String LAYOUT_STRING = "layoutString";
    private static final String JOB_ID_ATTR = "job_id";
    private static final String RM_ID_ATTR = "rm_id";
    private static final String STDOUT_REMOTE_FILE_ATTR = "stdout_remote_path";
    private static final String STDERR_REMOTE_FILE_ATTR = "stderr_remote_path";
    private static final String INTERACTIVE_ATTR = "interactive";
    private static final String STATE_ATTR = "state";
    private static final String STATE_DETAIL_ATTR = "state_detail";
    private static final String OID_ATTR = "oid";
    private static final String QUEUE_NAME_ATTR = "queue_name";
    private static final String OWNER_ATTR = "owner";

    public LMLResourceManagerMonitor(AbstractResourceManagerConfiguration config) {
        super(config);
    }

    private RequestType getMonitorConfigurationRequestType() {
        ResourceManagerData data;
        JAXBResourceManagerConfiguration config = (JAXBResourceManagerConfiguration)this.getResourceManager().getConfiguration();
        try {
            data = config.getResourceManagerData();
        }
        catch (Throwable throwable) {
            return null;
        }
        MonitorType monitorType = data.getMonitorData();
        RequestType request = null;
        if (monitorType != null) {
            request = new RequestType();
            for (MonitorDriverType monitorDriver : monitorType.getDriver()) {
                DriverType driver = new DriverType();
                driver.setName(monitorType.getSchedulerType());
                for (SimpleCommandType cmd : monitorDriver.getCmd()) {
                    CommandType command = new CommandType();
                    command.setName(cmd.getName());
                    command.setExec(cmd.getExec());
                    driver.getCommand().add(command);
                }
                request.getDriver().add(driver);
            }
            if (monitorType.getDriver().size() == 0) {
                DriverType driver = new DriverType();
                driver.setName(monitorType.getSchedulerType());
                request.getDriver().add(driver);
            }
        }
        return request;
    }

    private IRemoteConnection getRemoteConnection(IProgressMonitor monitor) {
        String name;
        String id;
        AbstractRemoteResourceManagerConfiguration conf = (AbstractRemoteResourceManagerConfiguration)this.getMonitorConfiguration();
        if (conf.getUseDefault()) {
            id = this.getResourceManager().getControlConfiguration().getRemoteServicesId();
            name = this.getResourceManager().getControlConfiguration().getConnectionName();
        } else {
            id = this.getMonitorConfiguration().getRemoteServicesId();
            name = this.getMonitorConfiguration().getConnectionName();
        }
        IRemoteServices services = PTPRemoteCorePlugin.getDefault().getRemoteServices(id, monitor);
        if (services != null) {
            IRemoteConnectionManager connMgr = services.getConnectionManager();
            return connMgr.getConnection(name);
        }
        return null;
    }

    private JobStatusData[] reload(IMemento memento) {
        ArrayList<JobStatusData> jobs = new ArrayList<JobStatusData>();
        if (memento != null) {
            IMemento[] children;
            IMemento[] iMementoArray = children = memento.getChildren(JOB_ID_ATTR);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento child = iMementoArray[n2];
                jobs.add(new JobStatusData(child.getID(), child.getString(RM_ID_ATTR), child.getString(STATE_ATTR), child.getString(STATE_DETAIL_ATTR), child.getString(STDOUT_REMOTE_FILE_ATTR), child.getString(STDERR_REMOTE_FILE_ATTR), child.getBoolean(INTERACTIVE_ATTR).booleanValue(), child.getString(QUEUE_NAME_ATTR), child.getString(OWNER_ATTR), child.getString(OID_ATTR)));
                ++n2;
            }
        }
        return jobs.toArray(new JobStatusData[jobs.size()]);
    }

    private void save(JobStatusData job, XMLMemento memento) {
        IMemento jobMemento = memento.createChild(JOB_ID_ATTR, job.getJobId());
        jobMemento.putString(RM_ID_ATTR, job.getRmId());
        jobMemento.putString(STATE_ATTR, job.getState());
        jobMemento.putString(STATE_DETAIL_ATTR, job.getStateDetail());
        jobMemento.putString(STDOUT_REMOTE_FILE_ATTR, job.getOutputPath());
        jobMemento.putString(STDERR_REMOTE_FILE_ATTR, job.getErrorPath());
        jobMemento.putBoolean(INTERACTIVE_ATTR, job.isInteractive());
        jobMemento.putString(QUEUE_NAME_ATTR, job.getQueueName());
        jobMemento.putString(OWNER_ATTR, job.getOwner());
        jobMemento.putString(OID_ATTR, job.getOid());
    }

    protected void doAddJob(String jobId, IJobStatus status) {
        JobStatusData data = new JobStatusData(status.getRmUniqueName(), status.getJobId(), status.getQueueName(), status.getOwner(), status.getOutputPath(), status.getErrorPath(), status.isInteractive());
        data.setState(status.getState());
        data.setStateDetail(status.getStateDetail());
        this.fLMLManager.addUserJob(this.getResourceManager().getUniqueName(), jobId, data);
    }

    protected void doDispose() {
    }

    protected void doRemoveJob(String jobId) {
        this.fLMLManager.removeUserJob(this.getResourceManager().getUniqueName(), jobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doShutdown() throws CoreException {
        XMLMemento memento = XMLMemento.createWriteRoot((String)USER_JOBS);
        if (memento != null) {
            String layout = this.fLMLManager.getCurrentLayout(this.getResourceManager().getUniqueName());
            JobStatusData[] jobs = this.fLMLManager.getUserJobs(this.getResourceManager().getUniqueName());
            if (layout != null) {
                IMemento layoutMemento = memento.createChild(LAYOUT);
                layoutMemento.putString(LAYOUT_STRING, layout);
            }
            if (jobs != null && jobs.length > 0) {
                JobStatusData[] jobStatusDataArray = jobs;
                int n = jobs.length;
                int n2 = 0;
                while (n2 < n) {
                    JobStatusData status = jobStatusDataArray[n2];
                    if (!status.isRemoved()) {
                        this.save(status, memento);
                    }
                    ++n2;
                }
            }
        }
        this.fLMLManager.closeLgui(this.getResourceManager().getUniqueName());
        StringWriter writer = new StringWriter();
        if (memento != null) {
            try {
                memento.save((Writer)writer);
            }
            catch (IOException t) {
                throw CoreExceptionUtils.newException((String)t.getMessage(), (Throwable)t);
            }
        }
        ((AbstractResourceManagerConfiguration)this.getMonitorConfiguration()).putString(USER_JOBS, writer.toString());
        LMLResourceManagerMonitor lMLResourceManagerMonitor = this;
        synchronized (lMLResourceManagerMonitor) {
            if (this.fMonitorJob != null) {
                this.fMonitorJob.cancel();
                this.fMonitorJob = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStartup(IProgressMonitor monitor) throws CoreException {
        String userJobs = ((AbstractResourceManagerConfiguration)this.getMonitorConfiguration()).getString(USER_JOBS, null);
        XMLMemento memento = null;
        if (userJobs != null) {
            memento = XMLMemento.createReadRoot((Reader)new StringReader(userJobs));
        }
        StringBuilder layout = new StringBuilder();
        JobStatusData[] jobs = null;
        if (memento != null) {
            IMemento child = memento.getChild(LAYOUT);
            if (child != null) {
                String childString = child.getString(LAYOUT_STRING);
                layout.append(childString);
            }
            jobs = this.reload((IMemento)memento);
        }
        this.fLMLManager.openLgui(this.getResourceManager().getUniqueName(), this.getMonitorConfigurationRequestType(), layout, jobs);
        IRemoteConnection conn = this.getRemoteConnection(monitor);
        if (conn != null) {
            if (!conn.isOpen()) {
                try {
                    conn.open(monitor);
                }
                catch (RemoteConnectionException e) {
                    throw new CoreException((IStatus)new Status(4, LMLMonitorCorePlugin.getUniqueIdentifier(), e.getMessage()));
                }
            }
            if (!conn.isOpen()) {
                throw new CoreException((IStatus)new Status(4, LMLMonitorCorePlugin.getUniqueIdentifier(), Messages.LMLResourceManagerMonitor_unableToOpenConnection));
            }
            LMLResourceManagerMonitor lMLResourceManagerMonitor = this;
            synchronized (lMLResourceManagerMonitor) {
                if (this.fMonitorJob == null) {
                    this.fMonitorJob = new MonitorJob(Messages.LMLResourceManagerMonitor_LMLMonitorJob, conn);
                }
                this.fMonitorJob.schedule();
            }
        }
        this.fRMManager.addRMSelectionListener((IRMSelectionListener)fListener);
    }

    protected void doUpdateJob(String jobId, IJobStatus status) {
        this.fLMLManager.updateUserJob(this.getResourceManager().getUniqueName(), jobId, status.getState(), status.getStateDetail());
    }

    private class MonitorJob
    extends Job {
        private final LMLDAServer fServer;

        public MonitorJob(String name, IRemoteConnection conn) {
            super(name);
            this.setSystem(true);
            this.fServer = (LMLDAServer)RemoteServerManager.getServer((String)LMLDAServer.SERVER_ID, (IRemoteConnection)conn);
            this.fServer.setWorkDir(new Path(conn.getWorkingDirectory()).append(".eclipsesettings").toString());
        }

        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                try {
                    this.fServer.startServer((IProgressMonitor)subMon.newChild(20));
                    if (!subMon.isCanceled()) {
                        this.fServer.waitForServerStart((IProgressMonitor)subMon.newChild(20));
                        if (!subMon.isCanceled()) {
                            LMLManager.getInstance().update(LMLResourceManagerMonitor.this.getResourceManager().getUniqueName(), this.fServer.getInputStream(), this.fServer.getOutputStream());
                        }
                    }
                }
                catch (Exception e) {
                    LMLResourceManagerMonitor.this.fRMManager.removeRMSelectionListener((IRMSelectionListener)fListener);
                    LMLResourceManagerMonitor.this.fireResourceManagerError(e.getLocalizedMessage());
                    Status status = new Status(4, "org.eclipse.ptp.rm.lml.monitor.core", e.getLocalizedMessage());
                    if (monitor != null) {
                        monitor.done();
                    }
                    return status;
                }
                this.fServer.waitForServerFinish((IProgressMonitor)subMon.newChild(40));
                if (!subMon.isCanceled()) {
                    this.schedule(60000L);
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
    }

    private static class RMListener
    implements IRMSelectionListener {
        private RMListener() {
        }

        public void selectionChanged(ISelection selection) {
            TreePath path;
            Object segment;
            String name = null;
            if (!selection.isEmpty() && (segment = (path = ((ITreeSelection)selection).getPaths()[0]).getFirstSegment()) instanceof IPResourceManager) {
                name = ((IPResourceManager)segment).getResourceManager().getUniqueName();
            }
            RMSelectionJob job = new RMSelectionJob(Messages.LMLResourceManagerMonitor_RMSelectionJob, name);
            job.schedule();
        }

        public void setDefault(Object rm) {
        }
    }

    private static class RMSelectionJob
    extends Job {
        private final String fRMName;

        public RMSelectionJob(String jobName, String rmName) {
            super(jobName);
            this.setSystem(true);
            this.fRMName = rmName;
        }

        protected IStatus run(IProgressMonitor monitor) {
            LMLManager.getInstance().selectLgui(this.fRMName);
            return Status.OK_STATUS;
        }
    }
}

