/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.util;

import java.io.File;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.Preferences;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.attributes.ProcessAttributes;
import org.eclipse.ptp.core.util.OutputTextFile;
import org.eclipse.ptp.utils.core.BitSetIterable;

public class ProcessOutput {
    private boolean lastOutputEndedInLineFeed = true;
    private final BitSet previousOutputProcesses = new BitSet();
    private String outputDirPath = null;
    private final OutputTextFile outputFile;
    private int storeLines = 0;

    public ProcessOutput(IPJob job) {
        this.setOutputStore();
        String name = String.valueOf(job.getResourceManager().getName()) + "_" + job.getName();
        this.outputFile = new OutputTextFile(name, ProcessAttributes.getStdoutAttributeDefinition().getId(), this.outputDirPath, this.storeLines);
    }

    public void addOutput(String output, BitSet processJobRanks) {
        if (processJobRanks.isEmpty()) {
            return;
        }
        if (output.length() == 0) {
            return;
        }
        StringBuilder prefix = new StringBuilder("[");
        for (Integer rank : new BitSetIterable(processJobRanks)) {
            prefix.append(rank + ",");
        }
        prefix.deleteCharAt(prefix.length() - 1);
        prefix.append("] ");
        List<String> lines = Arrays.asList(output.split("\n"));
        StringBuilder prefixedOutput = new StringBuilder();
        Iterator<String> lineIter = lines.iterator();
        if (!this.lastOutputEndedInLineFeed) {
            if (this.previousOutputProcesses.equals(processJobRanks)) {
                String firstLine = lineIter.next();
                prefixedOutput.append(String.valueOf(firstLine) + "\n");
            } else {
                prefixedOutput.append("\n");
            }
        }
        while (lineIter.hasNext()) {
            String line = lineIter.next();
            prefixedOutput.append(String.valueOf(prefix.toString()) + line + "\n");
        }
        if (!output.endsWith("\n")) {
            prefixedOutput.deleteCharAt(prefixedOutput.length() - 1);
        }
        this.outputFile.write(prefixedOutput.toString());
        this.previousOutputProcesses.clear();
        this.previousOutputProcesses.or(processJobRanks);
        this.lastOutputEndedInLineFeed = output.endsWith("\n");
    }

    public void delete() {
        this.outputFile.delete();
    }

    public String getSavedOutput(int jobRank) {
        String savedOutput = this.outputFile.getContents();
        String[] jobLines = savedOutput.split("\n");
        Pattern prefixPattern = Pattern.compile("^\\[([0-9]+,)*" + jobRank + "(,[0-9]+)*\\] (.*)");
        StringBuilder sb = new StringBuilder();
        String[] stringArray = jobLines;
        int n = jobLines.length;
        int n2 = 0;
        while (n2 < n) {
            String jobLine = stringArray[n2];
            Matcher matcher = prefixPattern.matcher(jobLine);
            boolean matched = matcher.matches();
            if (matched) {
                sb.append(String.valueOf(matcher.group(3)) + "\n");
            }
            ++n2;
        }
        return sb.toString();
    }

    private void setOutputStore() {
        File outputDirectory;
        this.outputDirPath = Preferences.getString(PTPCorePlugin.getUniqueIdentifier(), "PREFS_OUTPUT_DIR");
        this.storeLines = Preferences.getInt(PTPCorePlugin.getUniqueIdentifier(), "PREFS_STORE_LINES");
        if (this.outputDirPath == null || this.outputDirPath.length() == 0) {
            this.outputDirPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().append("output").toOSString();
        }
        if (this.storeLines == 0) {
            this.storeLines = 100;
        }
        if (!(outputDirectory = new File(this.outputDirPath)).exists()) {
            outputDirectory.mkdir();
        }
    }
}

