/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.util.Arrays;
import org.eclipse.cdt.internal.ui.refactoring.ListDialog;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringPreferences;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.internal.ui.viewsupport.ListContentProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.GlobalBuildAction;

public class RefactoringSaveHelper {
    private boolean fFilesSaved;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveEditors(Shell shell) {
        IEditorPart[] dirtyEditors = CUIPlugin.getDirtyEditors();
        if (dirtyEditors.length == 0) {
            return true;
        }
        if (!this.saveAllDirtyEditors(shell)) {
            return false;
        }
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription description = workspace.getDescription();
            boolean autoBuild = description.isAutoBuilding();
            description.setAutoBuilding(false);
            workspace.setDescription(description);
            try {
                CUIPlugin.getActiveWorkbenchWindow().getWorkbench().saveAllEditors(false);
                this.fFilesSaved = true;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                description.setAutoBuilding(autoBuild);
                workspace.setDescription(description);
                throw throwable;
            }
            {
                Object var6_9 = null;
            }
            description.setAutoBuilding(autoBuild);
            workspace.setDescription(description);
            return true;
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, shell, RefactoringMessages.getString("RefactoringStarter.saving"), RefactoringMessages.getString("RefactoringStarter.unexpected_exception"));
            return false;
        }
    }

    public void triggerBuild() {
        if (this.fFilesSaved && ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding()) {
            new GlobalBuildAction(CUIPlugin.getActiveWorkbenchWindow(), 10).run();
        }
    }

    private boolean saveAllDirtyEditors(Shell shell) {
        if (RefactoringPreferences.getSaveAllEditors()) {
            return true;
        }
        ListDialog dialog = new ListDialog(shell){

            protected Control createDialogArea(Composite parent) {
                Composite result = (Composite)super.createDialogArea(parent);
                Button check = new Button(result, 32);
                check.setText(RefactoringMessages.getString("RefactoringStarter.always_save"));
                check.setSelection(RefactoringPreferences.getSaveAllEditors());
                check.addSelectionListener((SelectionListener)new SelectionAdapter(this, check){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ Button val$check;
                    {
                        this.this$1 = var1_1;
                        this.val$check = button;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        RefactoringPreferences.setSaveAllEditors(this.val$check.getSelection());
                    }
                });
                1.applyDialogFont((Control)result);
                return result;
            }
        };
        dialog.setTitle(RefactoringMessages.getString("RefactoringStarter.save_all_resources"));
        dialog.setAddCancelButton(true);
        dialog.setLabelProvider(this.createDialogLabelProvider());
        dialog.setMessage(RefactoringMessages.getString("RefactoringStarter.must_save"));
        dialog.setContentProvider(new ListContentProvider());
        dialog.setInput(Arrays.asList(CUIPlugin.getDirtyEditors()));
        return dialog.open() == 0;
    }

    private ILabelProvider createDialogLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                return ((IEditorPart)element).getTitleImage();
            }

            public String getText(Object element) {
                return ((IEditorPart)element).getTitle();
            }
        };
    }
}

