/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core;

import java.util.EventObject;
import org.eclipse.cdt.core.ICDescriptor;

public class CDescriptorEvent
extends EventObject {
    private static final long serialVersionUID = 3257009869059143225L;
    public static final int CDTPROJECT_CHANGED = 1;
    public static final int CDTPROJECT_ADDED = 2;
    public static final int CDTPROJECT_REMOVED = 3;
    public static final int OWNER_CHANGED = 16;
    public static final int EXTENSION_CHANGED = 32;
    private static final int FLAGS_MASK = 15;
    int fType;

    public CDescriptorEvent(ICDescriptor descriptor, int type, int flags) {
        super(descriptor);
        this.fType = type | flags;
    }

    public ICDescriptor getDescriptor() {
        return (ICDescriptor)this.getSource();
    }

    public int getType() {
        return this.fType & 0xF;
    }

    public int getFlags() {
        return this.fType & 0xFFFFFFF0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        switch (this.getType()) {
            case 2: {
                buf.append("CDTPROJECT_ADDED");
                break;
            }
            case 3: {
                buf.append("CDTPROJECT_REMOVED");
                break;
            }
            case 1: {
                buf.append("CDTPROJECT_CHANGED");
            }
        }
        if ((this.getFlags() & 0x10) != 0) {
            buf.append("[OWNER CHANGED]");
        }
        if ((this.getFlags() & 0x20) != 0) {
            buf.append("[EXTENSION CHANGED]");
        }
        if (this.getFlags() == 0) {
            buf.append("[UNSPECIFIED]");
        }
        return buf.toString();
    }
}

