/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.addl_langs;

import java.util.Iterator;
import org.eclipse.cdt.core.addl_langs.AdditionalLanguagesIterator;
import org.eclipse.cdt.core.addl_langs.IAdditionalLanguage;
import org.eclipse.cdt.core.addl_langs.IAdditionalLanguageCallback;

public final class AdditionalLanguagesExtension {
    public static String EXTENSION_POINT_ID = "AdditionalLanguages";
    private static AdditionalLanguagesExtension instance = null;

    private AdditionalLanguagesExtension() {
    }

    public static AdditionalLanguagesExtension getInstance() {
        if (instance == null) {
            instance = new AdditionalLanguagesExtension();
        }
        return instance;
    }

    public Iterator iterator() {
        return new AdditionalLanguagesIterator();
    }

    public void processAdditionalLanguages(IAdditionalLanguageCallback callback) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            callback.performAction((IAdditionalLanguage)it.next());
        }
    }

    public boolean someAdditionalLanguageMatchesSourceContentType(String contentTypeID) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            IAdditionalLanguage thisLanguage = (IAdditionalLanguage)it.next();
            if (!thisLanguage.getRegisteredContentTypeIds().contains(contentTypeID)) continue;
            return true;
        }
        return false;
    }

    public IAdditionalLanguage getLanguageForSourceContentType(String contentTypeID) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            IAdditionalLanguage thisLanguage = (IAdditionalLanguage)it.next();
            if (!thisLanguage.getRegisteredContentTypeIds().contains(contentTypeID)) continue;
            return thisLanguage;
        }
        return null;
    }
}

