/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.browser.cache;

import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.IWorkingCopyProvider;
import org.eclipse.cdt.internal.core.browser.cache.BasicJob;
import org.eclipse.cdt.internal.core.browser.cache.ITypeCache;
import org.eclipse.cdt.internal.core.browser.cache.TypeCacheMessages;
import org.eclipse.cdt.internal.core.browser.cache.TypeParser;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class SubTypeLocatorJob
extends BasicJob {
    public static final Object FAMILY = new Object();
    private ITypeInfo fLocateType;
    private ITypeCache fTypeCache;
    private IWorkingCopyProvider fWorkingCopyProvider;

    public SubTypeLocatorJob(ITypeInfo info, ITypeCache typeCache, IWorkingCopyProvider workingCopyProvider) {
        super(TypeCacheMessages.getString("SubTypeLocatorJob.jobName"), FAMILY);
        this.fLocateType = info;
        this.fTypeCache = typeCache;
        this.fWorkingCopyProvider = workingCopyProvider;
    }

    public ITypeInfo getType() {
        return this.fLocateType;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus runWithDelegatedProgress(IProgressMonitor monitor) throws InterruptedException {
        boolean success = false;
        long startTime = System.currentTimeMillis();
        SubTypeLocatorJob.trace("SubTypeLocatorJob: started");
        try {
            monitor.beginTask(TypeCacheMessages.getString("SubTypeLocatorJob.taskName"), 100);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            TypeParser parser = new TypeParser(this.fTypeCache, this.fWorkingCopyProvider);
            success = parser.findSubTypes(this.fLocateType, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            long executionTime = System.currentTimeMillis() - startTime;
            if (success) {
                SubTypeLocatorJob.trace("SubTypeLocatorJob: completed (" + executionTime + " ms)");
            } else {
                SubTypeLocatorJob.trace("SubTypeLocatorJob: aborted (" + executionTime + " ms)");
            }
            monitor.done();
            throw throwable;
        }
        {
            Object var6_7 = null;
        }
        long executionTime = System.currentTimeMillis() - startTime;
        if (success) {
            SubTypeLocatorJob.trace("SubTypeLocatorJob: completed (" + executionTime + " ms)");
        } else {
            SubTypeLocatorJob.trace("SubTypeLocatorJob: aborted (" + executionTime + " ms)");
        }
        monitor.done();
        return Status.OK_STATUS;
    }
}

