/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.domsourceindexer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICLogConstants;
import org.eclipse.cdt.core.dom.CDOM;
import org.eclipse.cdt.core.dom.IASTServiceProvider;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.index.IIndexDelta;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.parser.IExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.ParseError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.internal.core.index.NamedEntry;
import org.eclipse.cdt.internal.core.index.cindexstorage.IndexerOutput;
import org.eclipse.cdt.internal.core.index.domsourceindexer.AbstractIndexerRunner;
import org.eclipse.cdt.internal.core.index.domsourceindexer.CGenerateIndexVisitor;
import org.eclipse.cdt.internal.core.index.domsourceindexer.CPPGenerateIndexVisitor;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMSourceIndexer;
import org.eclipse.cdt.internal.core.index.domsourceindexer.IndexEncoderUtil;
import org.eclipse.cdt.internal.core.index.impl.IndexDelta;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class DOMSourceIndexerRunner
extends AbstractIndexerRunner {
    private DOMSourceIndexer indexer;
    private static boolean skipScannerInfoTest = false;
    static int totalParseTime = 0;
    static int totalVisitTime = 0;
    static int errorCount = 0;
    static Map errors = new HashMap();

    public DOMSourceIndexerRunner(IFile resource, DOMSourceIndexer indexer) {
        this.resourceFile = resource;
        this.indexer = indexer;
    }

    public DOMSourceIndexer getIndexer() {
        return this.indexer;
    }

    public void setFileTypes(String[] fileTypes) {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void indexFile(IFile file) throws IOException {
        IASTTranslationUnit tu;
        block22: {
            int problems = this.indexer.indexProblemsEnabled(this.resourceFile.getProject());
            this.setProblemMarkersEnabled(problems |= 8);
            this.requestRemoveMarkers(this.resourceFile, null);
            if (!skipScannerInfoTest && this.isScannerInfoEmpty(this.resourceFile)) {
                this.addInfoMarker(this.resourceFile, CCorePlugin.getResourceString("DOMIndexerMarker.EmptyScannerInfo"));
                if (!this.areProblemMarkersEnabled()) return;
                this.reportProblems();
                return;
            }
            this.output.addIndexedFile(file.getFullPath().toString());
            tu = null;
            long startTime = 0L;
            long parseTime = 0L;
            long endTime = 0L;
            String error = null;
            try {
                try {
                    if (AbstractIndexerRunner.TIMING) {
                        startTime = System.currentTimeMillis();
                    }
                    tu = CDOM.getInstance().getASTService().getTranslationUnit(this.resourceFile, CDOM.getInstance().getCodeReaderFactory(0));
                    if (AbstractIndexerRunner.TIMING) {
                        parseTime = System.currentTimeMillis();
                    }
                    this.clearProblemMarkers(tu.getIncludeDirectives());
                    Object visitor = null;
                    visitor = tu.getParserLanguage() == ParserLanguage.CPP ? new CPPGenerateIndexVisitor(this) : new CGenerateIndexVisitor(this);
                    tu.accept((ASTVisitor)visitor);
                    this.processMacroDefinitions(tu.getMacroDefinitions());
                    this.processPreprocessorProblems(tu.getPreprocessorProblems());
                    this.processIncludeDirectives(tu.getDependencyTree());
                }
                catch (VirtualMachineError vmErr) {
                    error = vmErr.toString();
                    if (vmErr instanceof OutOfMemoryError) {
                        Util.log(null, "Out Of Memory error: " + vmErr.getMessage() + " on File: " + this.resourceFile.getName(), ICLogConstants.CDT);
                    }
                }
                catch (ParseError e) {
                    error = e.toString();
                    Util.log(null, "Parser Timeout on File: " + this.resourceFile.getName(), ICLogConstants.CDT);
                }
                catch (IASTServiceProvider.UnsupportedDialectException e) {
                    error = e.toString();
                    Util.log(null, "Unsupported C/C++ dialect on File: " + this.resourceFile.getName(), ICLogConstants.CDT);
                }
                catch (Exception ex) {
                    error = ex.toString();
                    if (ex instanceof IOException) {
                        throw (IOException)ex;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                if (AbstractIndexerRunner.TIMING) {
                    endTime = System.currentTimeMillis();
                    if (error != null) {
                        ++errorCount;
                        System.out.print(String.valueOf(error) + ':' + this.resourceFile.getName() + ':');
                        if (!errors.containsKey(error)) {
                            errors.put(error, new Integer(0));
                        }
                        errors.put(error, new Integer((Integer)errors.get(error) + 1));
                    }
                    System.out.print("DOM Indexer - " + this.resourceFile.getName() + ": " + (parseTime - startTime));
                    System.out.print("+" + (endTime - parseTime));
                    totalParseTime = (int)((long)totalParseTime + (parseTime - startTime));
                    totalVisitTime = (int)((long)totalVisitTime + (endTime - parseTime));
                    long currentTime = endTime - startTime;
                    System.out.print("=" + currentTime);
                    long tempTotaltime = this.indexer.getTotalIndexTime() + currentTime;
                    this.indexer.setTotalIndexTime(tempTotaltime);
                    System.out.println(" \t\tOverall " + tempTotaltime + "=" + totalParseTime + "+" + totalVisitTime + " " + errorCount + " errors ");
                    System.out.println("Attempted Entries " + IndexerOutput.entryCount + " Trimed " + DOMSourceIndexer.trimed + " Added " + DOMSourceIndexer.added);
                    System.out.flush();
                }
                if (AbstractIndexerRunner.VERBOSE) {
                    AbstractIndexerRunner.verbose("DOM AST TRAVERSAL FINISHED " + this.resourceFile.getName().toString());
                }
                if (this.areProblemMarkersEnabled()) {
                    this.reportProblems();
                }
                if (tu == null) throw throwable;
                List<IASTPreprocessorIncludeStatement> filesTrav = Arrays.asList(tu.getIncludeDirectives());
                IndexDelta indexDelta = new IndexDelta(this.resourceFile.getProject(), filesTrav, IIndexDelta.INDEX_FINISHED_DELTA);
                this.indexer.notifyListeners(indexDelta);
                throw throwable;
            }
            {
                Object var12_15 = null;
                if (!AbstractIndexerRunner.TIMING) break block22;
            }
            endTime = System.currentTimeMillis();
            if (error != null) {
                ++errorCount;
                System.out.print(String.valueOf(error) + ':' + this.resourceFile.getName() + ':');
                if (!errors.containsKey(error)) {
                    errors.put(error, new Integer(0));
                }
                errors.put(error, new Integer((Integer)errors.get(error) + 1));
            }
            System.out.print("DOM Indexer - " + this.resourceFile.getName() + ": " + (parseTime - startTime));
            System.out.print("+" + (endTime - parseTime));
            totalParseTime = (int)((long)totalParseTime + (parseTime - startTime));
            totalVisitTime = (int)((long)totalVisitTime + (endTime - parseTime));
            long currentTime = endTime - startTime;
            System.out.print("=" + currentTime);
            long tempTotaltime = this.indexer.getTotalIndexTime() + currentTime;
            this.indexer.setTotalIndexTime(tempTotaltime);
            System.out.println(" \t\tOverall " + tempTotaltime + "=" + totalParseTime + "+" + totalVisitTime + " " + errorCount + " errors ");
            System.out.println("Attempted Entries " + IndexerOutput.entryCount + " Trimed " + DOMSourceIndexer.trimed + " Added " + DOMSourceIndexer.added);
            System.out.flush();
        }
        if (AbstractIndexerRunner.VERBOSE) {
            AbstractIndexerRunner.verbose("DOM AST TRAVERSAL FINISHED " + this.resourceFile.getName().toString());
        }
        if (this.areProblemMarkersEnabled()) {
            this.reportProblems();
        }
        if (tu == null) return;
        List<IASTPreprocessorIncludeStatement> filesTrav = Arrays.asList(tu.getIncludeDirectives());
        IndexDelta indexDelta = new IndexDelta(this.resourceFile.getProject(), filesTrav, IIndexDelta.INDEX_FINISHED_DELTA);
        this.indexer.notifyListeners(indexDelta);
    }

    private boolean isScannerInfoEmpty(IFile file) {
        boolean rc = true;
        if (!CoreModel.isScannerInformationEmpty((IResource)file)) {
            IScannerInfo scanInfo;
            rc = false;
            IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(file.getProject());
            if (provider != null && (scanInfo = provider.getScannerInformation((IResource)file)) != null && scanInfo instanceof IExtendedScannerInfo) {
                int i;
                IExtendedScannerInfo extScanInfo = (IExtendedScannerInfo)scanInfo;
                if (extScanInfo.getIncludeFiles().length > 0) {
                    i = 0;
                    while (i < extScanInfo.getIncludeFiles().length) {
                        String includeFile = extScanInfo.getIncludeFiles()[i];
                        this.indexer.haveEncounteredHeader(this.resourceFile.getProject().getFullPath(), (IPath)new Path(includeFile), true);
                        ++i;
                    }
                }
                if (extScanInfo.getMacroFiles().length > 0) {
                    i = 0;
                    while (i < extScanInfo.getIncludeFiles().length) {
                        String macrosFile = extScanInfo.getMacroFiles()[i];
                        this.indexer.haveEncounteredHeader(this.resourceFile.getProject().getFullPath(), (IPath)new Path(macrosFile), true);
                        ++i;
                    }
                }
            }
        }
        return rc;
    }

    private void clearProblemMarkers(IASTPreprocessorIncludeStatement[] includeDirectives) {
        if (this.areProblemMarkersEnabled()) {
            int i = 0;
            while (i < includeDirectives.length) {
                Path includePath = new Path(includeDirectives[i].getPath());
                IFile includeFile = CCorePlugin.getWorkspace().getRoot().getFileForLocation((IPath)includePath);
                if (includeFile != null) {
                    this.requestRemoveMarkers(includeFile, this.resourceFile);
                }
                ++i;
            }
        }
    }

    private void processIncludeDirectives(IASTTranslationUnit.IDependencyTree tree) {
        int fileNumber = this.getOutput().getIndexedFile(this.getResourceFile().getFullPath().toString()).getFileID();
        this.processNestedInclusions(fileNumber, tree.getInclusions(), null);
    }

    private void processNestedInclusions(int fileNumber, IASTTranslationUnit.IDependencyTree.IASTInclusionNode[] inclusions, IASTTranslationUnit.IDependencyTree.IASTInclusionNode parent) {
        int i = 0;
        while (i < inclusions.length) {
            IASTTranslationUnit.IDependencyTree.IASTInclusionNode inclusion = inclusions[i];
            if (!IndexEncoderUtil.nodeInVisitedExternalHeader((IASTNode)inclusion.getIncludeDirective(), this.getIndexer())) {
                String include = inclusion.getIncludeDirective().getPath();
                this.getOutput().addIncludeRef(fileNumber, include);
                this.getOutput().addRelatives(fileNumber, include, parent != null ? parent.getIncludeDirective().getPath() : null);
                NamedEntry namedEntry = new NamedEntry(8, 2, new char[][]{include.toCharArray()}, 0, fileNumber);
                namedEntry.setNameOffset(1, 1, 2);
                namedEntry.serialize(this.getOutput());
                this.indexer.haveEncounteredHeader(this.resourceFile.getProject().getFullPath(), (IPath)new Path(include), true);
                this.processNestedInclusions(fileNumber, inclusion.getNestedInclusions(), inclusion);
            }
            ++i;
        }
    }

    private void processMacroDefinitions(IASTPreprocessorMacroDefinition[] macroDefinitions) {
        int i = 0;
        while (i < macroDefinitions.length) {
            IASTName macro = macroDefinitions[i].getName();
            if (!IndexEncoderUtil.nodeInVisitedExternalHeader((IASTNode)macro, this.getIndexer())) {
                IASTFileLocation loc = IndexEncoderUtil.getFileLocation((IASTNode)macro);
                int fileNumber = IndexEncoderUtil.calculateIndexFlags(this, loc);
                NamedEntry namedEntry = new NamedEntry(5, 1, new char[][]{macro.toCharArray()}, 0, fileNumber);
                namedEntry.setNameOffset(loc.getNodeOffset(), loc.getNodeLength(), 2);
                namedEntry.serialize(this.getOutput());
            }
            ++i;
        }
    }

    private void processPreprocessorProblems(IASTProblem[] preprocessorProblems) {
        int i = 0;
        while (i < preprocessorProblems.length) {
            IASTProblem problem = preprocessorProblems[i];
            if (!IndexEncoderUtil.nodeInVisitedExternalHeader((IASTNode)problem, this.getIndexer()) && this.areProblemMarkersEnabled() && this.shouldRecordProblem(problem)) {
                IASTFileLocation loc = IndexEncoderUtil.getFileLocation((IASTNode)problem);
                this.processProblem(problem.getMessage(), loc);
            }
            ++i;
        }
    }

    public void processProblem(String message, IASTFileLocation loc) {
        IFile tempFile = this.resourceFile;
        if (loc != null) {
            String fileName = loc.getFileName();
            tempFile = CCorePlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fileName));
            if (tempFile != null) {
                this.generateMarkerProblem(tempFile, this.resourceFile, message, loc);
            }
        }
    }

    private void generateMarkerProblem(IFile tempFile, IFile originator, String message, IASTFileLocation loc) {
        AddMarkerProblem tempProblem = new AddMarkerProblem((IResource)tempFile, (IResource)originator, message, loc);
        if (this.getProblemsMap().containsKey(tempFile)) {
            List list = (List)this.getProblemsMap().get(tempFile);
            list.add(tempProblem);
        } else {
            ArrayList<AbstractIndexerRunner.Problem> list = new ArrayList<AbstractIndexerRunner.Problem>();
            list.add((AbstractIndexerRunner)this.new AbstractIndexerRunner.RemoveMarkerProblem(tempFile, this.resourceFile));
            list.add(tempProblem);
            this.getProblemsMap().put(tempFile, list);
        }
    }

    public boolean shouldRecordProblem(IASTProblem problem) {
        boolean syntax;
        boolean preprocessor = (this.getProblemMarkersEnabled() & 1) != 0;
        boolean semantics = (this.getProblemMarkersEnabled() & 2) != 0;
        boolean bl = syntax = (this.getProblemMarkersEnabled() & 4) != 0;
        if (problem.checkCategory(0x2000002)) {
            return true;
        }
        if (problem.checkCategory(0x2000000) || problem.checkCategory(0x1000000)) {
            return preprocessor && problem.getID() != 0x200000B;
        }
        if (problem.checkCategory(0x8000000)) {
            return semantics;
        }
        if (problem.checkCategory(0x4000000)) {
            return syntax;
        }
        return false;
    }

    public boolean shouldRecordProblem(IProblemBinding problem) {
        return (this.getProblemMarkersEnabled() & 2) != 0;
    }

    public static void printErrors() {
        if (AbstractIndexerRunner.TIMING) {
            totalParseTime = 0;
            totalVisitTime = 0;
            System.out.println("Errors during indexing");
            Iterator i = errors.keySet().iterator();
            while (i.hasNext()) {
                String error = (String)i.next();
                System.out.println(String.valueOf(error) + " : " + ((Integer)errors.get(error)).toString());
            }
        }
    }

    public static void setSkipScannerInfoTest(boolean skipScannerInfoTest) {
        DOMSourceIndexerRunner.skipScannerInfoTest = skipScannerInfoTest;
    }

    class AddMarkerProblem
    extends AbstractIndexerRunner.Problem {
        private String message;
        private IASTFileLocation location;

        public AddMarkerProblem(IResource resource, IResource originator, String message, IASTFileLocation location) {
            super(resource, originator);
            this.message = message;
            this.location = location;
        }

        public void run() {
            if (this.location != null) {
                try {
                    IMarker[] markers = this.resource.findMarkers("org.eclipse.cdt.core.indexermarker", true, 0);
                    boolean newProblem = true;
                    if (markers.length > 0) {
                        IMarker tempMarker = null;
                        int nameStart = -1;
                        int nameLen = -1;
                        String tempMsgString = null;
                        int i = 0;
                        while (i < markers.length) {
                            tempMarker = markers[i];
                            tempMsgString = (String)tempMarker.getAttribute("message");
                            Integer tempInt = (Integer)tempMarker.getAttribute("charStart");
                            if (tempInt != null) {
                                nameStart = tempInt;
                                nameLen = (Integer)tempMarker.getAttribute("charEnd") - nameStart;
                                if (nameStart != -1 && nameStart == this.location.getNodeOffset() && nameLen == this.location.getNodeLength() && tempMsgString.equalsIgnoreCase(String.valueOf(INDEXER_MARKER_PREFIX) + this.message)) {
                                    newProblem = false;
                                    break;
                                }
                            }
                            ++i;
                        }
                    }
                    if (newProblem) {
                        IMarker marker = this.resource.createMarker("org.eclipse.cdt.core.indexermarker");
                        int start = this.location.getNodeOffset();
                        int end = start + this.location.getNodeLength();
                        marker.setAttribute("location", this.location.getStartingLineNumber());
                        marker.setAttribute("message", (Object)(String.valueOf(INDEXER_MARKER_PREFIX) + this.message));
                        marker.setAttribute("severity", 1);
                        marker.setAttribute("lineNumber", this.location.getStartingLineNumber());
                        marker.setAttribute("charStart", start);
                        marker.setAttribute("charEnd", end);
                        marker.setAttribute("org.eclipse.cdt.core.indexermarker.originator", (Object)this.originator.getFullPath().toString());
                    }
                }
                catch (CoreException coreException) {}
            }
        }
    }
}

