/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.model.BinaryFunction;
import org.eclipse.cdt.internal.core.model.BinaryInfo;
import org.eclipse.cdt.internal.core.model.BinaryModule;
import org.eclipse.cdt.internal.core.model.BinaryVariable;
import org.eclipse.cdt.internal.core.model.BufferManager;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CProjectInfo;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class Binary
extends Openable
implements IBinary {
    private int fBinType;
    private String hasDebug;
    private String cpu;
    private String[] needed;
    private long longData;
    private long longText;
    private long longBSS;
    private String endian;
    private String soname;
    private long fLastModification;
    IBinaryParser.IBinaryObject binaryObject;
    static /* synthetic */ Class class$0;

    public Binary(ICElement parent, IFile file, IBinaryParser.IBinaryObject bin) {
        super(parent, (IResource)file, 14);
        this.binaryObject = bin;
    }

    public Binary(ICElement parent, IPath path, IBinaryParser.IBinaryObject bin) {
        super(parent, path, 14);
        this.binaryObject = bin;
    }

    public boolean isSharedLib() {
        return this.getType() == 4;
    }

    public boolean isExecutable() {
        return this.getType() == 2;
    }

    public boolean isObject() {
        return this.getType() == 1;
    }

    public boolean isCore() {
        return this.getType() == 16;
    }

    public boolean hasDebug() {
        IBinaryParser.IBinaryObject obj;
        if ((this.isObject() || this.isExecutable() || this.isSharedLib()) && (this.hasDebug == null || this.hasChanged()) && (obj = this.getBinaryObject()) != null) {
            this.hasDebug = new Boolean(obj.hasDebug()).toString();
        }
        return Boolean.valueOf(this.hasDebug);
    }

    public String getCPU() {
        if ((this.isObject() || this.isExecutable() || this.isSharedLib() || this.isCore()) && (this.cpu == null || this.hasChanged())) {
            IBinaryParser.IBinaryObject obj = this.getBinaryObject();
            this.cpu = obj.getCPU();
        }
        return this.cpu == null ? "" : this.cpu;
    }

    public String[] getNeededSharedLibs() {
        IBinaryParser.IBinaryObject obj;
        if ((this.isExecutable() || this.isSharedLib()) && (this.needed == null || this.hasChanged()) && (obj = this.getBinaryObject()) instanceof IBinaryParser.IBinaryExecutable) {
            this.needed = ((IBinaryParser.IBinaryExecutable)obj).getNeededSharedLibs();
        }
        return this.needed == null ? new String[]{} : this.needed;
    }

    public long getText() {
        IBinaryParser.IBinaryObject obj;
        if ((this.isObject() || this.isExecutable() || this.isSharedLib()) && (this.longText == -1L || this.hasChanged()) && (obj = this.getBinaryObject()) != null) {
            this.longText = obj.getText();
        }
        return this.longText;
    }

    public long getData() {
        IBinaryParser.IBinaryObject obj;
        if ((this.isObject() || this.isExecutable() || this.isSharedLib()) && (this.longData == -1L || this.hasChanged()) && (obj = this.getBinaryObject()) != null) {
            this.longData = obj.getData();
        }
        return this.longData;
    }

    public long getBSS() {
        IBinaryParser.IBinaryObject obj;
        if ((this.isObject() || this.isExecutable() || this.isSharedLib()) && (this.longBSS == -1L || this.hasChanged()) && (obj = this.getBinaryObject()) != null) {
            this.longBSS = obj.getBSS();
        }
        return this.longBSS;
    }

    public String getSoname() {
        IBinaryParser.IBinaryObject obj;
        if (this.isSharedLib() && (this.soname == null || this.hasChanged()) && (obj = this.getBinaryObject()) instanceof IBinaryParser.IBinaryShared) {
            this.soname = ((IBinaryParser.IBinaryShared)obj).getSoName();
        }
        return this.soname == null ? "" : this.soname;
    }

    public boolean isLittleEndian() {
        IBinaryParser.IBinaryObject obj;
        if ((this.isObject() || this.isExecutable() || this.isSharedLib() || this.isCore()) && (this.endian == null || this.hasChanged()) && (obj = this.getBinaryObject()) != null) {
            this.endian = new Boolean(obj.isLittleEndian()).toString();
        }
        return Boolean.valueOf(this.endian);
    }

    protected IBinaryParser.IBinaryObject getBinaryObject() {
        return this.binaryObject;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.IBinaryParser$IBinaryObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this.getBinaryObject();
        }
        return super.getAdapter(adapter);
    }

    protected int getType() {
        IBinaryParser.IBinaryObject obj = this.getBinaryObject();
        if (obj != null && (this.fBinType == 0 || this.hasChanged())) {
            this.fBinType = obj.getType();
        }
        return this.fBinType;
    }

    protected boolean hasChanged() {
        long modification = this.getModificationStamp();
        boolean changed = modification != this.fLastModification;
        this.fLastModification = modification;
        if (changed) {
            this.hasDebug = null;
            this.needed = null;
            this.cpu = null;
            this.endian = null;
            this.longBSS = -1L;
            this.longData = -1L;
            this.longText = -1L;
            this.soname = null;
        }
        return changed;
    }

    protected long getModificationStamp() {
        IResource res = this.getResource();
        if (res != null) {
            return res.getModificationStamp();
        }
        return 0L;
    }

    public boolean isReadOnly() {
        return true;
    }

    public CElementInfo createElementInfo() {
        return new BinaryInfo(this);
    }

    protected boolean buildStructure(OpenableInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws CModelException {
        return this.computeChildren(info, underlyingResource);
    }

    boolean computeChildren(OpenableInfo info, IResource res) throws CModelException {
        boolean ok = false;
        if (this.isObject() || this.isExecutable() || this.isSharedLib()) {
            HashMap hash = new HashMap();
            IBinaryParser.IBinaryObject obj = this.getBinaryObject();
            if (obj != null) {
                IBinaryParser.ISymbol[] symbols = obj.getSymbols();
                int i = 0;
                while (i < symbols.length) {
                    switch (symbols[i].getType()) {
                        case 1: {
                            this.addFunction(info, symbols[i], hash);
                            break;
                        }
                        case 2: {
                            this.addVariable(info, symbols[i], hash);
                        }
                    }
                    ++i;
                }
                ok = true;
            }
        }
        return ok;
    }

    private void addFunction(OpenableInfo info, IBinaryParser.ISymbol symbol, Map hash) throws CModelException {
        IPath filename = symbol.getFilename();
        BinaryFunction function = null;
        if (filename != null && !filename.isEmpty()) {
            BinaryModule module = null;
            if (hash.containsKey(filename)) {
                module = (BinaryModule)hash.get(filename);
            } else {
                module = new BinaryModule(this, filename);
                hash.put(filename, module);
                info.addChild(module);
            }
            function = new BinaryFunction((ICElement)module, symbol.getName(), symbol.getAddress());
            function.setLines(symbol.getStartLine(), symbol.getEndLine());
            module.addChild(function);
        } else {
            function = new BinaryFunction((ICElement)this, symbol.getName(), symbol.getAddress());
            function.setLines(symbol.getStartLine(), symbol.getEndLine());
            info.addChild(function);
        }
    }

    private void addVariable(OpenableInfo info, IBinaryParser.ISymbol symbol, Map hash) throws CModelException {
        IPath filename = symbol.getFilename();
        BinaryVariable variable = null;
        if (filename != null && !filename.isEmpty()) {
            BinaryModule module = null;
            if (hash.containsKey(filename)) {
                module = (BinaryModule)hash.get(filename);
            } else {
                module = new BinaryModule(this, filename);
                hash.put(filename, module);
                info.addChild(module);
            }
            variable = new BinaryVariable((ICElement)module, symbol.getName(), symbol.getAddress());
            variable.setLines(symbol.getStartLine(), symbol.getEndLine());
            module.addChild(variable);
        } else {
            variable = new BinaryVariable((ICElement)this, symbol.getName(), symbol.getAddress());
            variable.setLines(symbol.getStartLine(), symbol.getEndLine());
            info.addChild(variable);
        }
    }

    protected IBuffer openBuffer(IProgressMonitor pm) throws CModelException {
        BufferManager bufManager = this.getBufferManager();
        IBuffer buffer = this.getBufferFactory().createBuffer(this);
        if (buffer == null) {
            return null;
        }
        if (buffer.getCharacters() == null) {
            IBinaryParser.IBinaryObject bin = this.getBinaryObject();
            if (bin != null) {
                StringBuffer sb = new StringBuffer();
                try {
                    int len;
                    BufferedReader stream = new BufferedReader(new InputStreamReader(bin.getContents()));
                    char[] buf = new char[512];
                    while ((len = stream.read(buf, 0, buf.length)) != -1) {
                        sb.append(buf, 0, len);
                    }
                }
                catch (IOException iOException) {}
                buffer.setContents(sb.toString());
            } else {
                IResource file = this.getResource();
                if (file != null && file.getType() == 1) {
                    buffer.setContents(Util.getResourceContentsAsCharArray((IFile)file));
                }
            }
        }
        bufManager.addBuffer(buffer);
        return buffer;
    }

    protected boolean hasBuffer() {
        return true;
    }

    public boolean exists() {
        IResource res = this.getResource();
        if (res != null) {
            return res.exists();
        }
        return super.exists();
    }

    public void closing(Object info) throws CModelException {
        ICProject cproject = this.getCProject();
        CProjectInfo pinfo = (CProjectInfo)CModelManager.getDefault().peekAtInfo(cproject);
        if (pinfo != null && pinfo.vBin != null) {
            pinfo.vBin.removeChild(this);
        }
        super.closing(info);
    }
}

