/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.core.model.ElementCache;
import org.eclipse.cdt.internal.core.util.OverflowingLRUCache;

public class CModelCache {
    public static final int PROJ_CACHE_SIZE = 50;
    public static final int FOLDER_CACHE_SIZE = 500;
    public static final int FILE_CACHE_SIZE = 2000;
    public static final int CHILDREN_CACHE_SIZE = 40000;
    protected Map projectAndRootCache = new HashMap(50);
    protected Map folderCache = new HashMap(500);
    protected OverflowingLRUCache fileCache = new ElementCache(2000);
    protected Map childrenCache = new HashMap(40000);

    public double openableFillingRatio() {
        return this.fileCache.fillingRatio();
    }

    public Object getInfo(ICElement element) {
        switch (element.getElementType()) {
            case 10: 
            case 11: {
                return this.projectAndRootCache.get(element);
            }
            case 12: {
                return this.folderCache.get(element);
            }
            case 14: 
            case 18: 
            case 60: {
                return this.fileCache.get(element);
            }
        }
        return this.childrenCache.get(element);
    }

    public Object peekAtInfo(ICElement element) {
        switch (element.getElementType()) {
            case 10: 
            case 11: {
                return this.projectAndRootCache.get(element);
            }
            case 12: {
                return this.folderCache.get(element);
            }
            case 14: 
            case 18: 
            case 60: {
                return this.fileCache.peek(element);
            }
        }
        return this.childrenCache.get(element);
    }

    public void putInfo(ICElement element, Object info) {
        switch (element.getElementType()) {
            case 10: 
            case 11: {
                this.projectAndRootCache.put(element, info);
                break;
            }
            case 12: {
                this.folderCache.put(element, info);
                break;
            }
            case 14: 
            case 18: 
            case 60: {
                this.fileCache.put(element, info);
                break;
            }
            default: {
                this.childrenCache.put(element, info);
            }
        }
    }

    public void removeInfo(ICElement element) {
        switch (element.getElementType()) {
            case 10: 
            case 11: {
                this.projectAndRootCache.remove(element);
                break;
            }
            case 12: {
                this.folderCache.remove(element);
                break;
            }
            case 14: 
            case 18: 
            case 60: {
                this.fileCache.remove(element);
                break;
            }
            default: {
                this.childrenCache.remove(element);
            }
        }
    }
}

