/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IIncludeReference;
import org.eclipse.cdt.core.model.ILibraryReference;
import org.eclipse.cdt.core.model.IOutputEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.internal.core.model.ArchiveContainer;
import org.eclipse.cdt.internal.core.model.BinaryContainer;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CProject;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class CProjectInfo
extends OpenableInfo {
    public BinaryContainer vBin = null;
    public ArchiveContainer vLib = null;
    public ILibraryReference[] libReferences;
    public IIncludeReference[] incReferences;
    public ISourceRoot[] sourceRoots;
    public IOutputEntry[] outputEntries;
    Object[] nonCResources = null;

    public CProjectInfo(CElement element) {
        super(element);
    }

    public synchronized IBinaryContainer getBinaryContainer() {
        if (this.vBin == null) {
            this.vBin = new BinaryContainer((CProject)this.getElement());
        }
        return this.vBin;
    }

    public synchronized IArchiveContainer getArchiveContainer() {
        if (this.vLib == null) {
            this.vLib = new ArchiveContainer((CProject)this.getElement());
        }
        return this.vLib;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object[] getNonCResources(IResource res) {
        ArrayList<IResource> notChildren;
        block14: {
            if (this.nonCResources != null) {
                return this.nonCResources;
            }
            boolean srcIsProject = false;
            IPathEntry[] entries = null;
            ICProject cproject = this.getElement().getCProject();
            IPath projectPath = cproject.getProject().getFullPath();
            char[][] exclusionPatterns = null;
            try {
                entries = cproject.getResolvedPathEntries();
                int i = 0;
                while (i < entries.length) {
                    ISourceEntry entry;
                    if (entries[i].getEntryKind() == 8 && projectPath.equals((Object)(entry = (ISourceEntry)entries[i]).getPath())) {
                        srcIsProject = true;
                        exclusionPatterns = entry.fullExclusionPatternChars();
                        break;
                    }
                    ++i;
                }
            }
            catch (CModelException cModelException) {}
            notChildren = new ArrayList<IResource>();
            try {
                IResource[] resources = null;
                if (res instanceof IContainer) {
                    IContainer container = (IContainer)res;
                    resources = container.members(false);
                }
                if (resources == null) break block14;
                int i = 0;
                while (i < resources.length) {
                    block15: {
                        IResource member = resources[i];
                        switch (member.getType()) {
                            case 1: {
                                IBinaryParser.IBinaryFile o;
                                String filename = member.getName();
                                if (!srcIsProject || (!CoreModel.isValidTranslationUnitName(cproject.getProject(), filename) || CoreModelUtil.isExcluded(member, exclusionPatterns)) && (CoreModelUtil.isExcluded(member, exclusionPatterns) || (o = CModelManager.getDefault().createBinaryFile((IFile)member)) == null)) break;
                                break block15;
                            }
                            case 2: {
                                if (srcIsProject && !CoreModelUtil.isExcluded(member, exclusionPatterns)) break block15;
                            }
                        }
                        notChildren.add(member);
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {}
        }
        this.setNonCResources(notChildren.toArray());
        return this.nonCResources;
    }

    public void setNonCResources(Object[] resources) {
        this.nonCResources = resources;
    }

    public void resetCaches() {
        int i;
        if (this.libReferences != null) {
            i = 0;
            while (i < this.libReferences.length) {
                try {
                    ((CElement)((Object)this.libReferences[i])).close();
                }
                catch (CModelException cModelException) {}
                ++i;
            }
        }
        if (this.incReferences != null) {
            i = 0;
            while (i < this.incReferences.length) {
                try {
                    ((CElement)((Object)this.incReferences[i])).close();
                }
                catch (CModelException cModelException) {}
                ++i;
            }
        }
        this.sourceRoots = null;
        this.outputEntries = null;
        this.setNonCResources(null);
    }
}

