/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.matching;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.ast.ASTSignatureUtil;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.EndOfFileException;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.IMatchLocatable;
import org.eclipse.cdt.core.search.LineLocatable;
import org.eclipse.cdt.core.search.OffsetLocatable;
import org.eclipse.cdt.core.search.OrPattern;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.dom.parser.c.ANSICParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.dom.parser.c.GNUCSourceParser;
import org.eclipse.cdt.internal.core.dom.parser.c.ICParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ANSICPPParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.GNUCPPSourceParser;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.cindexstorage.io.BlocksIndexInput;
import org.eclipse.cdt.internal.core.index.cindexstorage.io.IndexInput;
import org.eclipse.cdt.internal.core.parser.ParserException;
import org.eclipse.cdt.internal.core.parser.scanner2.DOMScanner;
import org.eclipse.cdt.internal.core.parser.scanner2.FileCodeReaderFactory;
import org.eclipse.cdt.internal.core.parser.scanner2.GCCScannerExtensionConfiguration;
import org.eclipse.cdt.internal.core.parser.scanner2.GPPScannerExtensionConfiguration;
import org.eclipse.cdt.internal.core.parser.scanner2.IScannerExtensionConfiguration;
import org.eclipse.cdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.cdt.internal.core.search.matching.ClassDeclarationPattern;
import org.eclipse.cdt.internal.core.search.matching.DerivedTypesPattern;
import org.eclipse.cdt.internal.core.search.matching.FieldDeclarationPattern;
import org.eclipse.cdt.internal.core.search.matching.FriendPattern;
import org.eclipse.cdt.internal.core.search.matching.IncludePattern;
import org.eclipse.cdt.internal.core.search.matching.MacroDeclarationPattern;
import org.eclipse.cdt.internal.core.search.matching.MethodDeclarationPattern;
import org.eclipse.cdt.internal.core.search.matching.NamespaceDeclarationPattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public abstract class CSearchPattern
implements ICSearchConstants,
ICSearchPattern {
    public static final int IMPOSSIBLE_MATCH = 0;
    public static final int POSSIBLE_MATCH = 1;
    public static final int ACCURATE_MATCH = 2;
    public static final int INACCURATE_MATCH = 3;
    public static ICSearchConstants.SearchFor[] fSearchForValues = new ICSearchConstants.SearchFor[]{CLASS_STRUCT, FUNCTION, VAR, UNION, METHOD, FIELD, ENUM, ENUMTOR, NAMESPACE, TYPEDEF, MACRO};
    private static final IParserLogService nullLog = new NullLogService();
    protected int _matchMode;
    protected boolean _caseSensitive;
    protected ICSearchConstants.LimitTo _limitTo;

    public CSearchPattern(int matchMode, boolean caseSensitive, ICSearchConstants.LimitTo limitTo) {
        this._matchMode = matchMode;
        this._caseSensitive = caseSensitive;
        this._limitTo = limitTo;
    }

    public CSearchPattern() {
    }

    public ICSearchConstants.LimitTo getLimitTo() {
        return this._limitTo;
    }

    public boolean canAccept(ICSearchConstants.LimitTo limit) {
        return limit == this.getLimitTo();
    }

    public static CSearchPattern createPattern(String patternString, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, int matchMode, boolean caseSensitive) {
        if (patternString == null || patternString.length() == 0) {
            return null;
        }
        CSearchPattern pattern = null;
        if (searchFor == TYPE || searchFor == CLASS || searchFor == STRUCT || searchFor == ENUM || searchFor == UNION || searchFor == CLASS_STRUCT || searchFor == TYPEDEF) {
            pattern = CSearchPattern.createClassPattern(patternString, searchFor, limitTo, matchMode, caseSensitive);
        } else if (searchFor == DERIVED) {
            pattern = CSearchPattern.createDerivedPattern(patternString, searchFor, limitTo, matchMode, caseSensitive);
        } else if (searchFor == FRIEND) {
            pattern = CSearchPattern.createFriendPattern(patternString, searchFor, limitTo, matchMode, caseSensitive);
        } else if (searchFor == METHOD || searchFor == FUNCTION) {
            pattern = CSearchPattern.createMethodPattern(patternString, searchFor, limitTo, matchMode, caseSensitive);
        } else if (searchFor == FIELD || searchFor == VAR || searchFor == ENUMTOR) {
            pattern = CSearchPattern.createFieldPattern(patternString, searchFor, limitTo, matchMode, caseSensitive);
        } else if (searchFor == NAMESPACE) {
            pattern = CSearchPattern.createNamespacePattern(patternString, limitTo, matchMode, caseSensitive);
        } else if (searchFor == MACRO) {
            pattern = CSearchPattern.createMacroPattern(patternString, limitTo, matchMode, caseSensitive);
        } else if (searchFor == INCLUDE) {
            pattern = CSearchPattern.createIncludePattern(patternString, limitTo, matchMode, caseSensitive);
        } else if (searchFor == UNKNOWN_SEARCH_FOR) {
            OrPattern orPattern = new OrPattern();
            int i = 0;
            while (i < fSearchForValues.length) {
                orPattern.addPattern(SearchEngine.createSearchPattern(patternString, fSearchForValues[i], limitTo, caseSensitive));
                ++i;
            }
            pattern = orPattern;
        }
        return pattern;
    }

    private static CSearchPattern createIncludePattern(String patternString, ICSearchConstants.LimitTo limitTo, int matchMode, boolean caseSensitive) {
        if (limitTo != REFERENCES) {
            return null;
        }
        return new IncludePattern(patternString.toCharArray(), matchMode, limitTo, caseSensitive);
    }

    private static CSearchPattern createMacroPattern(String patternString, ICSearchConstants.LimitTo limitTo, int matchMode, boolean caseSensitive) {
        if (limitTo != DECLARATIONS && limitTo != ALL_OCCURRENCES && limitTo != DECLARATIONS_DEFINITIONS) {
            return null;
        }
        return new MacroDeclarationPattern(patternString.toCharArray(), matchMode, DECLARATIONS, caseSensitive);
    }

    private static CSearchPattern createNamespacePattern(String patternString, ICSearchConstants.LimitTo limitTo, int matchMode, boolean caseSensitive) {
        if (limitTo == ALL_OCCURRENCES) {
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(CSearchPattern.createNamespacePattern(patternString, DEFINITIONS, matchMode, caseSensitive));
            orPattern.addPattern(CSearchPattern.createNamespacePattern(patternString, REFERENCES, matchMode, caseSensitive));
            return orPattern;
        }
        if (limitTo == DECLARATIONS_DEFINITIONS) {
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(CSearchPattern.createNamespacePattern(patternString, DECLARATIONS, matchMode, caseSensitive));
            orPattern.addPattern(CSearchPattern.createNamespacePattern(patternString, DEFINITIONS, matchMode, caseSensitive));
            return orPattern;
        }
        char[][] names = CSearchPattern.scanForNames(patternString);
        char[] name = names[names.length - 1];
        char[][] qualifications = new char[names.length - 1][];
        System.arraycopy(names, 0, qualifications, 0, qualifications.length);
        return new NamespaceDeclarationPattern(name, qualifications, matchMode, limitTo, caseSensitive);
    }

    private static CSearchPattern createFieldPattern(String patternString, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, int matchMode, boolean caseSensitive) {
        if (limitTo == ALL_OCCURRENCES) {
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(CSearchPattern.createFieldPattern(patternString, searchFor, DECLARATIONS, matchMode, caseSensitive));
            orPattern.addPattern(CSearchPattern.createFieldPattern(patternString, searchFor, REFERENCES, matchMode, caseSensitive));
            orPattern.addPattern(CSearchPattern.createFieldPattern(patternString, searchFor, DEFINITIONS, matchMode, caseSensitive));
            return orPattern;
        }
        if (limitTo == DECLARATIONS_DEFINITIONS) {
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(CSearchPattern.createFieldPattern(patternString, searchFor, DECLARATIONS, matchMode, caseSensitive));
            orPattern.addPattern(CSearchPattern.createFieldPattern(patternString, searchFor, DEFINITIONS, matchMode, caseSensitive));
            return orPattern;
        }
        char[][] names = CSearchPattern.scanForNames(patternString);
        char[] name = names[names.length - 1];
        char[][] qualifications = new char[names.length - 1][];
        System.arraycopy(names, 0, qualifications, 0, qualifications.length);
        return new FieldDeclarationPattern(name, qualifications, matchMode, searchFor, limitTo, caseSensitive);
    }

    private static CSearchPattern createMethodPattern(String patternString, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, int matchMode, boolean caseSensitive) {
        if (limitTo == ALL_OCCURRENCES) {
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(CSearchPattern.createMethodPattern(patternString, searchFor, DECLARATIONS, matchMode, caseSensitive));
            orPattern.addPattern(CSearchPattern.createMethodPattern(patternString, searchFor, REFERENCES, matchMode, caseSensitive));
            orPattern.addPattern(CSearchPattern.createMethodPattern(patternString, searchFor, DEFINITIONS, matchMode, caseSensitive));
            return orPattern;
        }
        if (limitTo == DECLARATIONS_DEFINITIONS) {
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(CSearchPattern.createMethodPattern(patternString, searchFor, DECLARATIONS, matchMode, caseSensitive));
            orPattern.addPattern(CSearchPattern.createMethodPattern(patternString, searchFor, DEFINITIONS, matchMode, caseSensitive));
            return orPattern;
        }
        int index = patternString.indexOf(40);
        String paramString = index == -1 ? "" : patternString.substring(index);
        String nameString = index == -1 ? patternString : patternString.substring(0, index);
        char[][] names = CSearchPattern.scanForNames(nameString);
        char[][] parameters = CSearchPattern.scanForParameters(paramString);
        char[] name = names[names.length - 1];
        char[][] qualifications = new char[names.length - 1][];
        System.arraycopy(names, 0, qualifications, 0, qualifications.length);
        char[] returnType = new char[]{};
        return new MethodDeclarationPattern(name, qualifications, parameters, returnType, matchMode, searchFor, limitTo, caseSensitive);
    }

    private static CSearchPattern createClassPattern(String patternString, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, int matchMode, boolean caseSensitive) {
        if (limitTo == ALL_OCCURRENCES) {
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(CSearchPattern.createClassPattern(patternString, searchFor, DECLARATIONS, matchMode, caseSensitive));
            orPattern.addPattern(CSearchPattern.createClassPattern(patternString, searchFor, DEFINITIONS, matchMode, caseSensitive));
            orPattern.addPattern(CSearchPattern.createClassPattern(patternString, searchFor, REFERENCES, matchMode, caseSensitive));
            return orPattern;
        }
        if (limitTo == DECLARATIONS_DEFINITIONS) {
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(CSearchPattern.createClassPattern(patternString, searchFor, DECLARATIONS, matchMode, caseSensitive));
            orPattern.addPattern(CSearchPattern.createClassPattern(patternString, searchFor, DEFINITIONS, matchMode, caseSensitive));
            return orPattern;
        }
        if (searchFor == CLASS_STRUCT) {
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(CSearchPattern.createClassPattern(patternString, CLASS, limitTo, matchMode, caseSensitive));
            orPattern.addPattern(CSearchPattern.createClassPattern(patternString, STRUCT, limitTo, matchMode, caseSensitive));
            return orPattern;
        }
        String[] tokens = patternString.split("\\s+");
        if (tokens.length > 0) {
            boolean removeFirst = true;
            if (tokens[0].equals("class")) {
                searchFor = CLASS;
            } else if (tokens[0].equals("struct")) {
                searchFor = STRUCT;
            } else if (tokens[0].equals("union")) {
                searchFor = UNION;
            } else if (tokens[0].equals("enum")) {
                searchFor = ENUM;
            } else if (tokens[0].equals("typedef")) {
                searchFor = TYPEDEF;
            } else {
                removeFirst = false;
            }
            if (removeFirst) {
                patternString = patternString.substring(tokens[0].length()).trim();
            }
        }
        char[][] names = CSearchPattern.scanForNames(patternString);
        char[] name = names[names.length - 1];
        char[][] qualifications = new char[names.length - 1][];
        System.arraycopy(names, 0, qualifications, 0, qualifications.length);
        return new ClassDeclarationPattern(name, qualifications, searchFor, limitTo, matchMode, caseSensitive);
    }

    private static CSearchPattern createDerivedPattern(String patternString, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, int matchMode, boolean caseSensitive) {
        searchFor = DERIVED;
        char[][] names = CSearchPattern.scanForNames(patternString);
        char[] name = names[names.length - 1];
        char[][] qualifications = new char[names.length - 1][];
        System.arraycopy(names, 0, qualifications, 0, qualifications.length);
        return new DerivedTypesPattern(name, qualifications, searchFor, limitTo, matchMode, caseSensitive);
    }

    private static CSearchPattern createFriendPattern(String patternString, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, int matchMode, boolean caseSensitive) {
        searchFor = FRIEND;
        char[][] names = CSearchPattern.scanForNames(patternString);
        char[] name = names[names.length - 1];
        char[][] qualifications = new char[names.length - 1][];
        System.arraycopy(names, 0, qualifications, 0, qualifications.length);
        return new FriendPattern(name, qualifications, searchFor, limitTo, matchMode, caseSensitive);
    }

    private static char[][] scanForNames(String nameString) {
        Requestor callback;
        IScanner scanner;
        ArrayList<char[]> nameList = new ArrayList<char[]>();
        if (nameString != null && nameString.length() > 0 && (scanner = CSearchPattern.createScanner(nameString, (ISourceElementRequestor)(callback = new Requestor(ParserMode.COMPLETE_PARSE)))) != null) {
            String name = new String("");
            char[] pattern = nameString.toCharArray();
            int idx = 0;
            try {
                IToken token = scanner.nextToken();
                IToken prev = null;
                boolean encounteredWild = false;
                boolean lastTokenWasOperator = false;
                block6: while (true) {
                    switch (token.getType()) {
                        case 3: {
                            nameList.add(name.toCharArray());
                            name = new String("");
                            lastTokenWasOperator = false;
                            idx += token.getLength();
                            while (idx < pattern.length && CharOperation.isWhitespace(pattern[idx])) {
                                ++idx;
                            }
                            break;
                        }
                        case 95: {
                            name = String.valueOf(name) + token.getImage();
                            name = String.valueOf(name) + ' ';
                            lastTokenWasOperator = true;
                            idx += token.getLength();
                            while (idx < pattern.length && CharOperation.isWhitespace(pattern[idx])) {
                                ++idx;
                            }
                            break;
                        }
                        default: {
                            if (token.getType() == 23 || token.getType() == 7) {
                                if (idx > 0 && idx < pattern.length && CharOperation.isWhitespace(pattern[idx - 1]) && !lastTokenWasOperator) {
                                    name = String.valueOf(name) + ' ';
                                }
                                encounteredWild = true;
                            } else if (!encounteredWild && !lastTokenWasOperator && name.length() > 0 && prev.getType() != 1 && prev.getType() != 42 && prev.getType() != 34 && prev.getType() != 20 && prev.getType() != 10 && token.getType() != 11 && token.getType() != 46) {
                                name = String.valueOf(name) + ' ';
                            } else {
                                encounteredWild = false;
                            }
                            name = String.valueOf(name) + token.getImage();
                            if (encounteredWild && idx < pattern.length - 1 && CharOperation.isWhitespace(pattern[idx + 1])) {
                                name = String.valueOf(name) + ' ';
                            }
                            idx += token.getLength();
                            while (idx < pattern.length && CharOperation.isWhitespace(pattern[idx])) {
                                ++idx;
                            }
                            lastTokenWasOperator = false;
                        }
                    }
                    prev = token;
                    token = null;
                    while (true) {
                        if (token != null) continue block6;
                        token = scanner.nextToken();
                        if (callback.badCharacterOffset == -1 || token.getOffset() <= callback.badCharacterOffset) continue;
                        if (!encounteredWild && !lastTokenWasOperator && prev.getType() != 20) {
                            name = String.valueOf(name) + " ";
                        }
                        name = String.valueOf(name) + "\\";
                        ++idx;
                        encounteredWild = true;
                        lastTokenWasOperator = false;
                        prev = null;
                        callback.badCharacterOffset = -1;
                    }
                    break;
                }
            }
            catch (EndOfFileException endOfFileException) {
                nameList.add(name.toCharArray());
            }
        }
        return (char[][])nameList.toArray((T[])new char[nameList.size()][]);
    }

    public static char[][] scanForParameters(String paramString) {
        char[][] rv = new char[][]{};
        if (paramString == null || paramString.equals("")) {
            return rv;
        }
        String functionString = "void f " + paramString + ";";
        try {
            IASTTranslationUnit tu = CSearchPattern.parse(functionString);
            if (tu != null) {
                IASTDeclaration[] decls = tu.getDeclarations();
                int i = 0;
                if (i < decls.length) {
                    IASTDeclaration decl = decls[i];
                    if (decl instanceof IASTSimpleDeclaration) {
                        IASTSimpleDeclaration simpleDecl = (IASTSimpleDeclaration)decl;
                        IASTDeclarator[] declarators = simpleDecl.getDeclarators();
                        int j = 0;
                        if (j < declarators.length) {
                            String[] parameters = ASTSignatureUtil.getParameterSignatureArray((IASTDeclarator)declarators[j]);
                            rv = new char[parameters.length][];
                            int k = 0;
                            while (k < parameters.length) {
                                rv[k] = parameters[k].toCharArray();
                                ++k;
                            }
                        }
                    }
                }
            }
        }
        catch (ParserException parserException) {}
        return rv;
    }

    protected boolean matchesName(char[] pattern, char[] name) {
        if (pattern == null) {
            return true;
        }
        if (name != null) {
            switch (this._matchMode) {
                case 0: {
                    return CharOperation.equals(pattern, name, this._caseSensitive);
                }
                case 1: {
                    return CharOperation.prefixEquals(pattern, name, this._caseSensitive);
                }
                case 2: {
                    if (!this._caseSensitive) {
                        pattern = CharOperation.toLowerCase(pattern);
                    }
                    return CharOperation.match(pattern, name, this._caseSensitive);
                }
            }
        }
        return false;
    }

    protected boolean matchQualifications(char[][] qualifications, char[][] candidate) {
        return this.matchQualifications(qualifications, candidate, false);
    }

    protected boolean matchQualifications(char[][] qualifications, char[][] candidate, boolean skipLastName) {
        int root;
        int candidateLength;
        int qualLength;
        int n = qualLength = qualifications != null ? qualifications.length : 0;
        int n2 = candidate != null ? candidate.length - (skipLastName ? 1 : 0) : (candidateLength = 0);
        if (qualLength == 0) {
            return true;
        }
        int n3 = root = qualifications[0].length == 0 ? 1 : 0;
        if (root == 1 && candidateLength != qualLength - 1 || root == 0 && candidateLength < qualLength) {
            return false;
        }
        int i = 1;
        while (i <= qualLength - root) {
            if (!this.matchesName(qualifications[qualLength - i], candidate[candidateLength - i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void findIndexMatches(IIndex index, IIndexSearchRequestor requestor, int detailLevel, IProgressMonitor progressMonitor, ICSearchScope scope) throws IOException {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        BlocksIndexInput input = new BlocksIndexInput(index.getIndexFile());
        try {
            ((IndexInput)input).open();
            this.findIndexMatches(input, requestor, detailLevel, progressMonitor, scope);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            ((IndexInput)input).close();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        ((IndexInput)input).close();
    }

    public void findIndexMatches(IndexInput input, IIndexSearchRequestor requestor, int detailLevel, IProgressMonitor progressMonitor, ICSearchScope scope) throws IOException {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        char[] prefix = this.indexEntryPrefix();
        if (prefix == null) {
            return;
        }
        IEntryResult[] entries = input.queryEntriesPrefixedBy(prefix);
        if (entries == null) {
            return;
        }
        int i = 0;
        int max = entries.length;
        while (i < max) {
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IEntryResult entry = entries[i];
            this.resetIndexInfo();
            this.decodeIndexEntry(entry);
            if (this.matchIndexEntry()) {
                this.feedIndexRequestor(requestor, detailLevel, entry.getFileReferences(), entry.getOffsets(), entry.getOffsetLengths(), input, scope);
            }
            ++i;
        }
    }

    public static IMatchLocatable getMatchLocatable(int offset, int offsetLength) {
        int encodedVal;
        int offsetType = encodedVal = offset;
        int m = 1;
        while (offsetType >= 10) {
            offsetType /= 10;
            m *= 10;
        }
        int startOffset = encodedVal - offsetType * m;
        int endOffset = startOffset + offsetLength;
        IMatchLocatable locatable = null;
        if (offsetType == 1) {
            locatable = new LineLocatable(startOffset, 0);
        } else if (offsetType == 2) {
            locatable = new OffsetLocatable(startOffset, endOffset);
        }
        return locatable;
    }

    public abstract void feedIndexRequestor(IIndexSearchRequestor var1, int var2, int[] var3, int[][] var4, int[][] var5, IndexInput var6, ICSearchScope var7) throws IOException;

    protected abstract void resetIndexInfo();

    protected abstract void decodeIndexEntry(IEntryResult var1);

    public abstract char[] indexEntryPrefix();

    protected abstract boolean matchIndexEntry();

    protected static IASTTranslationUnit parse(String code) throws ParserException {
        return CSearchPattern.parse(code, ParserLanguage.CPP);
    }

    protected static IASTTranslationUnit parse(String code, ParserLanguage lang) throws ParserException {
        ANSICPPParserExtensionConfiguration config;
        NullLogService NULL_LOG = new NullLogService();
        CodeReader codeReader = new CodeReader(code.toCharArray());
        ScannerInfo scannerInfo = new ScannerInfo();
        Object configuration = null;
        configuration = lang == ParserLanguage.C ? new GCCScannerExtensionConfiguration() : new GPPScannerExtensionConfiguration();
        DOMScanner scanner = new DOMScanner(codeReader, (IScannerInfo)scannerInfo, ParserMode.COMPLETE_PARSE, lang, (IParserLogService)NULL_LOG, (IScannerExtensionConfiguration)configuration, (ICodeReaderFactory)FileCodeReaderFactory.getInstance());
        GNUCPPSourceParser parser2 = null;
        if (lang == ParserLanguage.CPP) {
            config = new ANSICPPParserExtensionConfiguration();
            parser2 = new GNUCPPSourceParser((IScanner)scanner, ParserMode.COMPLETE_PARSE, (IParserLogService)NULL_LOG, (ICPPParserExtensionConfiguration)config);
        } else {
            config = new ANSICParserExtensionConfiguration();
            parser2 = new GNUCSourceParser((IScanner)scanner, ParserMode.COMPLETE_PARSE, (IParserLogService)NULL_LOG, (ICParserExtensionConfiguration)config);
        }
        IASTTranslationUnit tu = parser2.parse();
        if (parser2.encounteredError()) {
            throw new ParserException("FAILURE");
        }
        return tu;
    }

    protected static IScanner createScanner(String code, ISourceElementRequestor callback) {
        return CSearchPattern.createScanner(code, callback, ParserLanguage.CPP);
    }

    protected static IScanner createScanner(String code, ISourceElementRequestor callback, ParserLanguage lang) {
        IScanner scanner = null;
        try {
            scanner = ParserFactory.createScanner((CodeReader)new CodeReader(code.toCharArray()), (IScannerInfo)new ScannerInfo(), (ParserMode)ParserMode.QUICK_PARSE, (ParserLanguage)lang, (ISourceElementRequestor)callback, (IParserLogService)nullLog, null);
        }
        catch (ParserFactoryError parserFactoryError) {}
        return scanner;
    }

    protected static class Requestor
    extends NullSourceElementRequestor {
        public int badCharacterOffset = -1;

        public Requestor(ParserMode mode) {
            super(mode);
        }

        public boolean acceptProblem(IProblem problem) {
            if (problem.getID() == 0x1000001) {
                this.badCharacterOffset = problem.getSourceStart();
                return false;
            }
            return super.acceptProblem(problem);
        }
    }
}

