/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.cdt.core.browser.PathUtil;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ast.ASTUtil;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTQualifiedNameElement;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.cindexstorage.Index;
import org.eclipse.cdt.internal.core.index.cindexstorage.IndexedFileEntry;
import org.eclipse.cdt.internal.core.index.cindexstorage.Util;
import org.eclipse.cdt.internal.core.index.cindexstorage.io.IndexInput;
import org.eclipse.cdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.cdt.internal.core.search.matching.CSearchPattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class MethodDeclarationPattern
extends CSearchPattern {
    private ICSearchConstants.SearchFor searchFor;
    private char[][] parameterNames;
    private char[] simpleName;
    private char[][] qualifications;
    private char[] returnTypes;
    private char[] decodedSimpleName;
    private char[][] decodedQualifications;
    private char[][] decodedParameters;
    private char[] decodedReturnTypes;

    public MethodDeclarationPattern(char[] name, char[][] qual, char[][] params, char[] returnTypes, int matchMode, ICSearchConstants.SearchFor search, ICSearchConstants.LimitTo limitTo, boolean caseSensitive) {
        super(matchMode, caseSensitive, limitTo);
        this.qualifications = qual;
        this.simpleName = name;
        this.parameterNames = params;
        this.returnTypes = returnTypes;
        this.searchFor = search;
    }

    public char[] getSimpleName() {
        return this.simpleName;
    }

    public int matchLevel(ISourceElementCallbackDelegate node, ICSearchConstants.LimitTo limit) {
        char[][] qualName;
        if (node instanceof IASTMethod) {
            if (this.searchFor != METHOD || !this.canAccept(limit)) {
                return 0;
            }
        } else if (node instanceof IASTFunction) {
            if (this.searchFor != FUNCTION || !this.canAccept(limit)) {
                return 0;
            }
        } else {
            return 0;
        }
        IASTFunction function = (IASTFunction)node;
        char[] nodeName = function.getNameCharArray();
        if (this.simpleName != null && !this.matchesName(this.simpleName, nodeName)) {
            return 0;
        }
        if (node instanceof IASTQualifiedNameElement && !this.matchQualifications(this.qualifications, qualName = ((IASTQualifiedNameElement)node).getFullyQualifiedNameCharArrays(), true)) {
            return 0;
        }
        if (this.parameterNames != null && this.parameterNames.length > 0 && this.parameterNames[0].length > 0) {
            String[] paramTypes = ASTUtil.getFunctionParameterTypes((IASTFunction)function);
            if (paramTypes.length == 0 && CharOperation.equals(this.parameterNames[0], "void".toCharArray())) {
                return 2;
            }
            if (this.parameterNames.length != paramTypes.length) {
                return 0;
            }
            int i = 0;
            while (i < this.parameterNames.length) {
                if (this.parameterNames[i] == null) {
                    return 0;
                }
                char[] param = paramTypes[i].toCharArray();
                if (!CharOperation.equals(this.parameterNames[i], param, this._caseSensitive)) {
                    return 0;
                }
                ++i;
            }
        }
        return 2;
    }

    public char[] indexEntryPrefix() {
        if (this.searchFor == FUNCTION) {
            return Index.bestFunctionPrefix(this._limitTo, this.simpleName, this._matchMode, this._caseSensitive);
        }
        if (this.searchFor == METHOD) {
            return Index.bestMethodPrefix(this._limitTo, this.simpleName, this.qualifications, this._matchMode, this._caseSensitive);
        }
        return null;
    }

    protected void resetIndexInfo() {
        this.decodedSimpleName = null;
        this.decodedQualifications = null;
    }

    protected void decodeIndexEntry(IEntryResult entryResult) {
        this.decodedSimpleName = entryResult.extractSimpleName().toCharArray();
        String[] missmatch = entryResult.getEnclosingNames();
        if (missmatch != null) {
            int start = 0;
            int end = 0;
            boolean parmsExist = false;
            int i = 0;
            while (i < missmatch.length) {
                if (missmatch[i].equals("(")) {
                    start = i;
                    parmsExist = true;
                }
                if (missmatch[i].equals(")")) {
                    end = i;
                    break;
                }
                ++i;
            }
            boolean returnTypeExists = false;
            int returnStart = 0;
            int returnEnd = 0;
            if (end != 0 && end + 1 < missmatch.length) {
                int j = end;
                while (j < missmatch.length) {
                    if (missmatch[j].equals("R(")) {
                        returnStart = j;
                        returnTypeExists = true;
                    }
                    if (missmatch[j].equals(")R")) {
                        returnEnd = j;
                        break;
                    }
                    ++j;
                }
            }
            if (parmsExist) {
                this.decodedParameters = new char[end - (start + 1)][];
                int counter = 0;
                int i2 = start + 1;
                while (i2 < end) {
                    this.decodedParameters[counter++] = missmatch[i2].toCharArray();
                    ++i2;
                }
                if (returnEnd != 0) {
                    this.decodedQualifications = new char[missmatch.length - (returnEnd + 1)][];
                    counter = 0;
                    i2 = returnEnd + 1;
                    while (i2 < missmatch.length) {
                        this.decodedQualifications[counter++] = missmatch[i2].toCharArray();
                        ++i2;
                    }
                } else {
                    this.decodedQualifications = new char[missmatch.length - (end + 1)][];
                    counter = 0;
                    i2 = end + 1;
                    while (i2 < missmatch.length) {
                        this.decodedQualifications[counter++] = missmatch[i2].toCharArray();
                        ++i2;
                    }
                }
            } else {
                this.decodedParameters = new char[0][];
                this.decodedQualifications = new char[missmatch.length][];
                int i3 = 0;
                while (i3 < missmatch.length) {
                    this.decodedQualifications[i3] = missmatch[i3].toCharArray();
                    ++i3;
                }
            }
            if (returnTypeExists) {
                this.decodedReturnTypes = missmatch[returnStart + 1].toCharArray();
            }
        }
    }

    protected boolean matchIndexEntry() {
        if (this.simpleName != null && !this.matchesName(this.simpleName, this.decodedSimpleName)) {
            return false;
        }
        if (!this.matchQualifications(this.qualifications, this.decodedQualifications)) {
            return false;
        }
        if (!this.matchParameters(this.parameterNames, this.decodedParameters)) {
            return false;
        }
        return this.matchReturnType(this.returnTypes, this.decodedReturnTypes);
    }

    private boolean matchReturnType(char[] tempReturnTypes, char[] tempDecodedReturnTypes) {
        if (tempReturnTypes == null || tempReturnTypes.length == 0 || tempDecodedReturnTypes == null) {
            return true;
        }
        return CharOperation.equals(tempReturnTypes, tempDecodedReturnTypes, true);
    }

    private boolean matchParameters(char[][] parameterNames2, char[][] decodedParameters2) {
        if (parameterNames2.length == 0) {
            return true;
        }
        if (decodedParameters2.length != parameterNames2.length) {
            return false;
        }
        int i = 0;
        while (i < parameterNames2.length) {
            boolean matchFound = false;
            int j = 0;
            while (j < decodedParameters2.length) {
                if (Util.compare(parameterNames2[i], this.decodedParameters[j]) == 0) {
                    matchFound = true;
                    break;
                }
                ++j;
            }
            if (!matchFound) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void feedIndexRequestor(IIndexSearchRequestor requestor, int detailLevel, int[] fileRefs, int[][] offsets, int[][] offsetLengths, IndexInput input, ICSearchScope scope) throws IOException {
        int i = 0;
        int max = fileRefs.length;
        while (i < max) {
            IndexedFileEntry file = input.getIndexedFile(fileRefs[i]);
            String path = null;
            if (file != null && scope.encloses(path = file.getPath())) {
                int j = 0;
                while (j < offsets[i].length) {
                    IFile tempFile;
                    BasicSearchMatch match = new BasicSearchMatch();
                    match.setName(new String(this.decodedSimpleName));
                    match.setLocatable(MethodDeclarationPattern.getMatchLocatable(offsets[i][j], offsetLengths[i][j]));
                    match.setParentName("");
                    if (this.searchFor == METHOD) {
                        match.setType(70);
                    } else if (this.searchFor == FUNCTION) {
                        match.setType(74);
                    }
                    if (this.decodedParameters.length > 0) {
                        String[] parms = new String[this.decodedParameters.length];
                        int k = 0;
                        while (k < this.decodedParameters.length) {
                            parms[k] = new String(this.decodedParameters[k]);
                            ++k;
                        }
                        match.setParameters(parms);
                    }
                    if (this.decodedReturnTypes != null) {
                        match.setReturnType(new String(this.decodedReturnTypes));
                    }
                    if ((tempFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path))) != null && tempFile.exists()) {
                        match.setResource((IResource)tempFile);
                    } else {
                        IPath tempPath = PathUtil.getWorkspaceRelativePath(file.getPath());
                        match.setPath(tempPath);
                        match.setReferringElement(tempPath);
                    }
                    requestor.acceptSearchMatch(match);
                    ++j;
                }
            }
            ++i;
        }
    }
}

