/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fdt.core;

import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.fdt.core.model.FortranCoreModel;

public class FortranConventions {
    private static final String ILLEGAL_FILE_CHARS = "/\\:<>?*|\"";

    private static boolean isLegalFilename(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        int len = name.length();
        int i = 0;
        while (i < len) {
            char c = name.charAt(i);
            if (ILLEGAL_FILE_CHARS.indexOf(c) != -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static IStatus validateFileName(String name) {
        if (name == null || name.length() == 0) {
            return new Status(4, "org.eclipse.fdt.core", -1, Util.bind((String)"convention.filename.nullName"), null);
        }
        if (!FortranConventions.isLegalFilename(name)) {
            return new Status(2, "org.eclipse.fdt.core", -1, Util.bind((String)"convention.filename.possiblyInvalid"), null);
        }
        String trimmed = name.trim();
        if (!name.equals(trimmed) || name.indexOf(" ") != -1) {
            return new Status(2, "org.eclipse.fdt.core", -1, Util.bind((String)"convention.filename.nameWithBlanks"), null);
        }
        return CModelStatus.VERIFIED_OK;
    }

    public static IStatus validateSourceFileName(IProject project, String name) {
        IStatus val = FortranConventions.validateFileName(name);
        if (val.getSeverity() == 4) {
            return val;
        }
        if (!FortranCoreModel.isValidSourceUnitName(project, name)) {
            return new Status(2, "org.eclipse.fdt.core", -1, Util.bind((String)"convention.sourceFilename.filetype"), null);
        }
        return val;
    }
}

