/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fdt.core;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class FortranProjectNature
implements IProjectNature {
    public static final String FORTRAN_NATURE_ID = "org.eclipse.cdt.core.fnature";
    private IProject fProject;

    public FortranProjectNature() {
    }

    public FortranProjectNature(IProject project) {
        this.setProject(project);
    }

    public static void addFortranNature(IProject project, IProgressMonitor mon) throws CoreException {
        FortranProjectNature.addNature(project, FORTRAN_NATURE_ID, mon);
    }

    public static void removeFortranNature(IProject project, IProgressMonitor mon) throws CoreException {
        FortranProjectNature.removeNature(project, FORTRAN_NATURE_ID, mon);
    }

    public static void addNature(IProject project, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        int i = 0;
        while (i < prevNatures.length) {
            if (natureId.equals(prevNatures[i])) {
                return;
            }
            ++i;
        }
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        project.setDescription(description, monitor);
    }

    public static void removeNature(IProject project, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        ArrayList<String> newNatures = new ArrayList<String>(Arrays.asList(prevNatures));
        newNatures.remove(natureId);
        description.setNatureIds(newNatures.toArray(new String[newNatures.size()]));
        project.setDescription(description, monitor);
    }

    public void configure() throws CoreException {
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }
}

