/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fdt.internal.core.model;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IProblemRequestor;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.IQuickParseCallback;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.ASTUtil;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTBaseSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.ast.IASTLinkageSpecification;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableElement;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifierOwner;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTUsingDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTUsingDirective;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.Enumeration;
import org.eclipse.cdt.internal.core.model.Enumerator;
import org.eclipse.cdt.internal.core.model.Field;
import org.eclipse.cdt.internal.core.model.Function;
import org.eclipse.cdt.internal.core.model.FunctionDeclaration;
import org.eclipse.cdt.internal.core.model.FunctionTemplate;
import org.eclipse.cdt.internal.core.model.FunctionTemplateDeclaration;
import org.eclipse.cdt.internal.core.model.IDebugLogConstants;
import org.eclipse.cdt.internal.core.model.Include;
import org.eclipse.cdt.internal.core.model.Macro;
import org.eclipse.cdt.internal.core.model.Method;
import org.eclipse.cdt.internal.core.model.MethodDeclaration;
import org.eclipse.cdt.internal.core.model.MethodTemplate;
import org.eclipse.cdt.internal.core.model.MethodTemplateDeclaration;
import org.eclipse.cdt.internal.core.model.Namespace;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.SourceManipulation;
import org.eclipse.cdt.internal.core.model.Structure;
import org.eclipse.cdt.internal.core.model.StructureDeclaration;
import org.eclipse.cdt.internal.core.model.StructureTemplate;
import org.eclipse.cdt.internal.core.model.StructureTemplateDeclaration;
import org.eclipse.cdt.internal.core.model.TypeDef;
import org.eclipse.cdt.internal.core.model.Using;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.model.Variable;
import org.eclipse.cdt.internal.core.model.VariableDeclaration;
import org.eclipse.cdt.internal.core.model.VariableTemplate;
import org.eclipse.cdt.internal.core.parser.ParserException;
import org.eclipse.cdt.internal.core.parser.StructuralParseCallback;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.fdt.core.parser.FortranParserLanguage;
import org.eclipse.fdt.internal.core.model.FortranTranslationUnit;

public class FortranModelBuilder {
    private FortranTranslationUnit translationUnit;
    private Map newElements;
    private IQuickParseCallback quickParseCallback;
    private static char[] EMPTY_CHAR_ARRAY = new char[0];
    private boolean hasNoErrors = false;

    public FortranModelBuilder(FortranTranslationUnit tu, Map newElements) {
        this.translationUnit = tu;
        this.newElements = newElements;
    }

    private IASTCompilationUnit parse(boolean quickParseMode, boolean throwExceptionOnError) throws ParserException {
        ParserMode mode;
        IProject currentProject = null;
        char[] code = EMPTY_CHAR_ARRAY;
        if (this.translationUnit != null && this.translationUnit.getCProject() != null) {
            currentProject = this.translationUnit.getCProject().getProject();
        }
        if (currentProject != null) {
            CoreModel.hasCCNature(currentProject);
        }
        try {
            code = this.translationUnit.getBuffer().getCharacters();
        }
        catch (CModelException cModelException) {}
        IProblemRequestor problemRequestor = this.translationUnit.getProblemRequestor();
        ParserMode parserMode = mode = quickParseMode ? ParserMode.QUICK_PARSE : ParserMode.STRUCTURAL_PARSE;
        this.quickParseCallback = problemRequestor == null ? (quickParseMode ? ParserFactory.createQuickParseCallback() : ParserFactory.createStructuralParseCallback()) : new ProblemCallback(problemRequestor);
        FortranParserLanguage language = FortranParserLanguage.Fortran;
        IParser parser = null;
        try {
            ScannerInfo scanInfo = new ScannerInfo();
            IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(currentProject);
            if (provider != null) {
                IScannerInfo buildScanInfo = null;
                IResource res = this.translationUnit.getResource();
                if (res != null) {
                    buildScanInfo = provider.getScannerInformation(res);
                }
                if (buildScanInfo == null) {
                    buildScanInfo = provider.getScannerInformation((IResource)currentProject);
                }
                if (buildScanInfo != null) {
                    scanInfo = new ScannerInfo(buildScanInfo.getDefinedSymbols(), buildScanInfo.getIncludePaths());
                }
            }
            CodeReader reader = this.translationUnit.getUnderlyingResource() != null ? new CodeReader(this.translationUnit.getUnderlyingResource().getLocation().toOSString(), code) : new CodeReader(code);
            parser = ParserFactory.createParser((IScanner)ParserFactory.createScanner((CodeReader)reader, (IScannerInfo)scanInfo, (ParserMode)mode, (ParserLanguage)language, (ISourceElementRequestor)this.quickParseCallback, (IParserLogService)(quickParseMode ? new NullLogService() : ParserUtil.getScannerLogService()), null), (ISourceElementRequestor)this.quickParseCallback, (ParserMode)mode, (ParserLanguage)language, (IParserLogService)ParserUtil.getParserLogService());
        }
        catch (ParserFactoryError parserFactoryError) {
            throw new ParserException(CCorePlugin.getResourceString((String)"CModelBuilder.Parser_Construction_Failure"));
        }
        if (problemRequestor != null) {
            problemRequestor.beginReporting();
        }
        this.hasNoErrors = parser.parse();
        if (problemRequestor != null) {
            problemRequestor.endReporting();
        }
        if (!this.hasNoErrors && throwExceptionOnError) {
            throw new ParserException(CCorePlugin.getResourceString((String)"CModelBuilder.Parse_Failure"));
        }
        return this.quickParseCallback.getCompilationUnit();
    }

    public Map parse(boolean quickParseMode) throws Exception {
        long startTime = System.currentTimeMillis();
        try {
            this.parse(quickParseMode, true);
        }
        catch (ParserException parserException) {
            Util.debugLog((String)"Parse Exception in FortranModelBuilder", (IDebugLogConstants.DebugLogConstant)IDebugLogConstants.MODEL);
        }
        Util.debugLog((String)("CModel parsing: " + (System.currentTimeMillis() - startTime) + "ms"), (IDebugLogConstants.DebugLogConstant)IDebugLogConstants.MODEL);
        startTime = System.currentTimeMillis();
        try {
            this.generateModelElements();
            this.translationUnit.getElementInfo().setIsStructureKnown(this.hasNoErrors && this.quickParseCallback.hasNoProblems());
        }
        catch (NullPointerException nullPointerException) {
            Util.debugLog((String)"NullPointer exception in CModelBuilder", (IDebugLogConstants.DebugLogConstant)IDebugLogConstants.MODEL);
        }
        Util.debugLog((String)("CModel building: " + (System.currentTimeMillis() - startTime) + "ms"), (IDebugLogConstants.DebugLogConstant)IDebugLogConstants.MODEL);
        return this.newElements;
    }

    private void generateModelElements() throws CModelException {
        Iterator i = this.quickParseCallback.iterateOffsetableElements();
        while (i.hasNext()) {
            IASTOffsetableElement offsetable = (IASTOffsetableElement)i.next();
            if (offsetable instanceof IASTInclusion) {
                IASTInclusion inc = (IASTInclusion)offsetable;
                if (inc.isImplicit()) continue;
                this.createInclusion((Parent)this.translationUnit, inc);
                continue;
            }
            if (offsetable instanceof IASTMacro) {
                IASTMacro macro = (IASTMacro)offsetable;
                if (macro.isImplicit()) continue;
                this.createMacro((Parent)this.translationUnit, macro);
                continue;
            }
            if (!(offsetable instanceof IASTDeclaration)) continue;
            try {
                this.generateModelElements((Parent)this.translationUnit, (IASTDeclaration)offsetable);
            }
            catch (ASTNotImplementedException aSTNotImplementedException) {}
        }
    }

    private void generateModelElements(Parent parent, IASTDeclaration declaration) throws CModelException, ASTNotImplementedException {
        if (declaration instanceof IASTNamespaceDefinition) {
            this.generateModelElements(parent, (IASTNamespaceDefinition)declaration);
        }
        if (declaration instanceof IASTAbstractTypeSpecifierDeclaration) {
            this.generateModelElements(parent, (IASTAbstractTypeSpecifierDeclaration)declaration);
        }
        if (declaration instanceof IASTTemplateDeclaration) {
            this.generateModelElements(parent, (IASTTemplateDeclaration)declaration);
        }
        if (declaration instanceof IASTTypedefDeclaration) {
            this.generateModelElements(parent, (IASTTypedefDeclaration)declaration);
        }
        if (declaration instanceof IASTLinkageSpecification) {
            this.generateModelElements(parent, (IASTLinkageSpecification)declaration);
        }
        if (declaration instanceof IASTUsingDirective) {
            this.createUsingDirective(parent, (IASTUsingDirective)declaration);
        }
        if (declaration instanceof IASTUsingDeclaration) {
            this.createUsingDeclaration(parent, (IASTUsingDeclaration)declaration);
        }
        this.createSimpleElement(parent, declaration, false);
    }

    private void generateModelElements(Parent parent, IASTNamespaceDefinition declaration) throws CModelException, ASTNotImplementedException {
        Namespace namespace = this.createNamespace(parent, declaration);
        Iterator nsDecls = declaration.getDeclarations();
        while (nsDecls.hasNext()) {
            IASTDeclaration subNsDeclaration = (IASTDeclaration)nsDecls.next();
            this.generateModelElements((Parent)namespace, subNsDeclaration);
        }
    }

    private void generateModelElements(Parent parent, IASTLinkageSpecification declaration) throws CModelException, ASTNotImplementedException {
        Iterator nsDecls = declaration.getDeclarations();
        while (nsDecls.hasNext()) {
            IASTDeclaration subNsDeclaration = (IASTDeclaration)nsDecls.next();
            this.generateModelElements(parent, subNsDeclaration);
        }
    }

    private void generateModelElements(Parent parent, IASTAbstractTypeSpecifierDeclaration abstractDeclaration) throws CModelException, ASTNotImplementedException {
        this.createAbstractElement(parent, (IASTTypeSpecifierOwner)abstractDeclaration, false, true);
    }

    private void generateModelElements(Parent parent, IASTTemplateDeclaration templateDeclaration) throws CModelException, ASTNotImplementedException {
        String[] parameterTypes;
        CElement element = null;
        IASTDeclaration declaration = templateDeclaration.getOwnedDeclaration();
        if (declaration instanceof IASTAbstractTypeSpecifierDeclaration) {
            IASTAbstractTypeSpecifierDeclaration abstractDeclaration = (IASTAbstractTypeSpecifierDeclaration)declaration;
            element = this.createAbstractElement(parent, (IASTTypeSpecifierOwner)abstractDeclaration, true, true);
            String[] parameterTypes2 = ASTUtil.getTemplateParameters((IASTTemplateDeclaration)templateDeclaration);
            if (element instanceof StructureTemplate) {
                StructureTemplate classTemplate = (StructureTemplate)element;
                classTemplate.setTemplateParameterTypes(parameterTypes2);
            } else if (element instanceof StructureTemplate) {
                StructureTemplateDeclaration classTemplate = (StructureTemplateDeclaration)element;
                classTemplate.setTemplateParameterTypes(parameterTypes2);
            }
        } else if (declaration instanceof IASTClassSpecifier) {
            IASTClassSpecifier classSpecifier = (IASTClassSpecifier)declaration;
            element = this.createClassSpecifierElement(parent, classSpecifier, true);
            String[] parameterTypes3 = ASTUtil.getTemplateParameters((IASTTemplateDeclaration)templateDeclaration);
            if (element instanceof StructureTemplate) {
                StructureTemplate classTemplate = (StructureTemplate)element;
                classTemplate.setTemplateParameterTypes(parameterTypes3);
            } else if (element instanceof StructureTemplate) {
                StructureTemplateDeclaration classTemplate = (StructureTemplateDeclaration)element;
                classTemplate.setTemplateParameterTypes(parameterTypes3);
            }
        } else if (declaration instanceof IASTVariable) {
            element = this.createSimpleElement(parent, declaration, true);
            parameterTypes = ASTUtil.getTemplateParameters((IASTTemplateDeclaration)templateDeclaration);
            VariableTemplate varTemplate = (VariableTemplate)element;
            varTemplate.setTemplateParameterTypes(parameterTypes);
        } else if (declaration instanceof IASTFunction) {
            element = this.createSimpleElement(parent, declaration, true);
            parameterTypes = ASTUtil.getTemplateParameters((IASTTemplateDeclaration)templateDeclaration);
            if (element instanceof FunctionTemplate) {
                FunctionTemplate functionTemplate = (FunctionTemplate)element;
                functionTemplate.setTemplateParameterTypes(parameterTypes);
            } else if (element instanceof FunctionTemplateDeclaration) {
                FunctionTemplateDeclaration functionTemplate = (FunctionTemplateDeclaration)element;
                functionTemplate.setTemplateParameterTypes(parameterTypes);
            } else if (element instanceof MethodTemplate) {
                MethodTemplate methodTemplate = (MethodTemplate)element;
                methodTemplate.setTemplateParameterTypes(parameterTypes);
            } else if (element instanceof MethodTemplateDeclaration) {
                MethodTemplateDeclaration methodTemplate = (MethodTemplateDeclaration)element;
                methodTemplate.setTemplateParameterTypes(parameterTypes);
            }
        }
        if (element instanceof SourceManipulation) {
            SourceManipulation sourceRef = (SourceManipulation)element;
            sourceRef.setPos(templateDeclaration.getStartingOffset(), templateDeclaration.getEndingOffset() - templateDeclaration.getStartingOffset());
            sourceRef.setLines(templateDeclaration.getStartingLine(), templateDeclaration.getEndingLine());
        }
    }

    private void generateModelElements(Parent parent, IASTTypedefDeclaration declaration) throws CModelException, ASTNotImplementedException {
        this.createTypeDef(parent, declaration);
        IASTAbstractDeclaration abstractDeclaration = declaration.getAbstractDeclarator();
        this.createAbstractElement(parent, (IASTTypeSpecifierOwner)abstractDeclaration, false, true);
    }

    private CElement createClassSpecifierElement(Parent parent, IASTClassSpecifier classSpecifier, boolean isTemplate) throws ASTNotImplementedException, CModelException {
        CElement element = null;
        Structure classElement = this.createClass(parent, classSpecifier, isTemplate);
        element = (CElement)classElement;
        Iterator j = classSpecifier.getDeclarations();
        while (j.hasNext()) {
            IASTDeclaration subDeclaration = (IASTDeclaration)j.next();
            this.generateModelElements((Parent)classElement, subDeclaration);
        }
        return element;
    }

    private CElement createAbstractElement(Parent parent, IASTTypeSpecifierOwner abstractDeclaration, boolean isTemplate, boolean isDeclaration) throws ASTNotImplementedException, CModelException {
        CElement element = null;
        if (abstractDeclaration != null) {
            IASTTypeSpecifier typeSpec = abstractDeclaration.getTypeSpecifier();
            if (typeSpec instanceof IASTEnumerationSpecifier) {
                IASTEnumerationSpecifier enumSpecifier = (IASTEnumerationSpecifier)typeSpec;
                Enumeration enumElement = this.createEnumeration(parent, enumSpecifier);
                element = (CElement)enumElement;
            } else if (typeSpec instanceof IASTClassSpecifier) {
                IASTClassSpecifier classSpecifier = (IASTClassSpecifier)typeSpec;
                element = this.createClassSpecifierElement(parent, classSpecifier, isTemplate);
            } else if (isDeclaration && typeSpec instanceof IASTElaboratedTypeSpecifier) {
                IASTElaboratedTypeSpecifier elabSpecifier = (IASTElaboratedTypeSpecifier)typeSpec;
                element = this.createElaboratedTypeSpecifier(parent, elabSpecifier, isTemplate);
            }
        }
        return element;
    }

    private CElement createSimpleElement(Parent parent, IASTDeclaration declaration, boolean isTemplate) throws CModelException, ASTNotImplementedException {
        VariableDeclaration element = null;
        if (declaration instanceof IASTVariable) {
            element = this.createVariableSpecification(parent, (IASTVariable)declaration, isTemplate);
        } else if (declaration instanceof IASTFunction) {
            element = this.createFunctionSpecification(parent, (IASTFunction)declaration, isTemplate);
        }
        return element;
    }

    private StructureDeclaration createElaboratedTypeSpecifier(Parent parent, IASTElaboratedTypeSpecifier typeSpec, boolean isTemplate) throws CModelException {
        ASTClassKind classkind = typeSpec.getClassKind();
        int kind = -1;
        if (classkind == ASTClassKind.CLASS) {
            kind = isTemplate ? 82 : 64;
        } else if (classkind == ASTClassKind.STRUCT) {
            kind = isTemplate ? 84 : 66;
        } else if (classkind == ASTClassKind.UNION) {
            kind = isTemplate ? 86 : 68;
        }
        String className = typeSpec.getName() == null ? "" : typeSpec.getName().toString();
        Object element = isTemplate ? new StructureTemplateDeclaration((ICElement)parent, kind, className) : new StructureDeclaration((ICElement)parent, className, kind);
        parent.addChild((ICElement)element);
        element.setIdPos(typeSpec.getNameOffset(), typeSpec.getNameEndOffset() - typeSpec.getNameOffset());
        element.setPos(typeSpec.getStartingOffset(), typeSpec.getEndingOffset() - typeSpec.getStartingOffset());
        element.setLines(typeSpec.getStartingLine(), typeSpec.getEndingLine());
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    private Include createInclusion(Parent parent, IASTInclusion inclusion) throws CModelException {
        Include element = new Include((ICElement)parent, inclusion.getName(), !inclusion.isLocal());
        element.setFullPathName(inclusion.getFullFileName());
        parent.addChild((ICElement)element);
        element.setIdPos(inclusion.getNameOffset(), inclusion.getNameEndOffset() - inclusion.getNameOffset());
        element.setPos(inclusion.getStartingOffset(), inclusion.getEndingOffset() - inclusion.getStartingOffset());
        element.setLines(inclusion.getStartingLine(), inclusion.getEndingLine());
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    private Macro createMacro(Parent parent, IASTMacro macro) throws CModelException {
        Macro element = new Macro((ICElement)parent, macro.getName());
        parent.addChild((ICElement)element);
        element.setIdPos(macro.getNameOffset(), macro.getNameEndOffset() - macro.getNameOffset());
        element.setPos(macro.getStartingOffset(), macro.getEndingOffset() - macro.getStartingOffset());
        element.setLines(macro.getStartingLine(), macro.getEndingLine());
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    private Namespace createNamespace(Parent parent, IASTNamespaceDefinition nsDef) throws CModelException {
        String type = "namespace";
        String nsName = nsDef.getName() == null ? "" : nsDef.getName().toString();
        Namespace element = new Namespace((ICElement)parent, nsName);
        parent.addChild((ICElement)element);
        element.setIdPos(nsDef.getNameOffset(), nsName.length() == 0 ? type.length() : nsDef.getNameEndOffset() - nsDef.getNameOffset());
        element.setPos(nsDef.getStartingOffset(), nsDef.getEndingOffset() - nsDef.getStartingOffset());
        element.setLines(nsDef.getStartingLine(), nsDef.getEndingLine());
        element.setTypeName(type);
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    private Enumeration createEnumeration(Parent parent, IASTEnumerationSpecifier enumSpecifier) throws CModelException {
        String type = "enum";
        String enumName = enumSpecifier.getName() == null ? "" : enumSpecifier.getName().toString();
        Enumeration element = new Enumeration((ICElement)parent, enumName);
        parent.addChild((ICElement)element);
        Iterator i = enumSpecifier.getEnumerators();
        while (i.hasNext()) {
            IASTEnumerator enumDef = (IASTEnumerator)i.next();
            this.createEnumerator((Parent)element, enumDef);
        }
        element.setIdPos(enumSpecifier.getNameOffset(), enumName.length() == 0 ? type.length() : enumSpecifier.getNameEndOffset() - enumSpecifier.getNameOffset());
        element.setPos(enumSpecifier.getStartingOffset(), enumSpecifier.getEndingOffset() - enumSpecifier.getStartingOffset());
        element.setLines(enumSpecifier.getStartingLine(), enumSpecifier.getEndingLine());
        element.setTypeName(type);
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    private Enumerator createEnumerator(Parent enumarator, IASTEnumerator enumDef) throws CModelException {
        Enumerator element = new Enumerator((ICElement)enumarator, enumDef.getName().toString());
        IASTExpression initialValue = enumDef.getInitialValue();
        if (initialValue != null) {
            element.setConstantExpression(ASTUtil.getExpressionString((IASTExpression)initialValue));
        }
        enumarator.addChild((ICElement)element);
        element.setIdPos(enumDef.getStartingOffset(), enumDef.getNameEndOffset() - enumDef.getNameOffset());
        element.setPos(enumDef.getStartingOffset(), enumDef.getEndingOffset() - enumDef.getStartingOffset());
        element.setLines(enumDef.getStartingLine(), enumDef.getEndingLine());
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    private Structure createClass(Parent parent, IASTClassSpecifier classSpecifier, boolean isTemplate) throws CModelException {
        Structure element;
        String className = "";
        String type = "";
        int kind = 65;
        ASTClassKind classkind = classSpecifier.getClassKind();
        if (classkind == ASTClassKind.CLASS) {
            kind = isTemplate ? 83 : 65;
            type = "class";
        } else if (classkind == ASTClassKind.STRUCT) {
            kind = isTemplate ? 85 : 67;
            type = "struct";
        } else if (classkind == ASTClassKind.UNION) {
            kind = isTemplate ? 87 : 69;
            type = "union";
        }
        String string = className = classSpecifier.getName() == null ? "" : classSpecifier.getName().toString();
        if (!isTemplate) {
            Structure classElement;
            element = classElement = new Structure((ICElement)parent, kind, className);
        } else {
            StructureTemplate classTemplate = new StructureTemplate((ICElement)parent, kind, className);
            element = classTemplate;
        }
        Iterator baseClauses = classSpecifier.getBaseClauses();
        while (baseClauses.hasNext()) {
            IASTBaseSpecifier baseSpec = (IASTBaseSpecifier)baseClauses.next();
            element.addSuperClass(baseSpec.getParentClassName(), baseSpec.getAccess());
        }
        parent.addChild((ICElement)element);
        element.setIdPos(classSpecifier.getNameOffset(), className.length() == 0 ? type.length() : classSpecifier.getNameEndOffset() - classSpecifier.getNameOffset());
        element.setTypeName(type);
        if (!isTemplate) {
            element.setPos(classSpecifier.getStartingOffset(), classSpecifier.getEndingOffset() - classSpecifier.getStartingOffset());
        }
        element.setLines(classSpecifier.getStartingLine(), classSpecifier.getEndingLine());
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    private TypeDef createTypeDef(Parent parent, IASTTypedefDeclaration typeDefDeclaration) throws CModelException {
        String name = typeDefDeclaration.getName();
        TypeDef element = new TypeDef((ICElement)parent, name);
        StringBuffer typeName = new StringBuffer(ASTUtil.getType((IASTAbstractDeclaration)typeDefDeclaration.getAbstractDeclarator()));
        element.setTypeName(typeName.toString());
        parent.addChild((ICElement)element);
        element.setIdPos(typeDefDeclaration.getNameOffset(), typeDefDeclaration.getNameEndOffset() - typeDefDeclaration.getNameOffset());
        element.setPos(typeDefDeclaration.getStartingOffset(), typeDefDeclaration.getEndingOffset() - typeDefDeclaration.getStartingOffset());
        element.setLines(typeDefDeclaration.getStartingLine(), typeDefDeclaration.getEndingLine());
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    private VariableDeclaration createVariableSpecification(Parent parent, IASTVariable varDeclaration, boolean isTemplate) throws CModelException, ASTNotImplementedException {
        String variableName = varDeclaration.getName();
        if (variableName == null || variableName.length() <= 0) {
            return null;
        }
        IASTAbstractDeclaration abstractDeclaration = varDeclaration.getAbstractDeclaration();
        this.createAbstractElement(parent, (IASTTypeSpecifierOwner)abstractDeclaration, isTemplate, false);
        VariableTemplate element = null;
        if (varDeclaration instanceof IASTField) {
            IASTField fieldDeclaration = (IASTField)varDeclaration;
            Field newElement = new Field((ICElement)parent, variableName);
            newElement.setMutable(fieldDeclaration.isMutable());
            newElement.setVisibility(fieldDeclaration.getVisiblity());
            element = newElement;
        } else if (isTemplate) {
            VariableTemplate newElement;
            element = newElement = new VariableTemplate((ICElement)parent, variableName);
        } else if (varDeclaration.isExtern()) {
            VariableDeclaration newElement = new VariableDeclaration((ICElement)parent, variableName);
            element = newElement;
        } else {
            Variable newElement = new Variable((ICElement)parent, variableName);
            element = newElement;
        }
        element.setTypeName(ASTUtil.getType((IASTAbstractDeclaration)varDeclaration.getAbstractDeclaration()));
        element.setConst(varDeclaration.getAbstractDeclaration().isConst());
        element.setVolatile(varDeclaration.getAbstractDeclaration().isVolatile());
        element.setStatic(varDeclaration.isStatic());
        parent.addChild((ICElement)element);
        element.setIdPos(varDeclaration.getNameOffset(), varDeclaration.getNameEndOffset() - varDeclaration.getNameOffset());
        if (!isTemplate) {
            element.setPos(varDeclaration.getStartingOffset(), varDeclaration.getEndingOffset() - varDeclaration.getStartingOffset());
        }
        element.setLines(varDeclaration.getStartingLine(), varDeclaration.getEndingLine());
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    private FunctionDeclaration createFunctionSpecification(Parent parent, IASTFunction functionDeclaration, boolean isTemplate) throws CModelException {
        String name = functionDeclaration.getName();
        if (name == null || name.length() <= 0) {
            return null;
        }
        String[] parameterTypes = ASTUtil.getFunctionParameterTypes((IASTFunction)functionDeclaration);
        Function element = null;
        if (functionDeclaration instanceof IASTMethod) {
            IASTMethod methodDeclaration = (IASTMethod)functionDeclaration;
            Method methodElement = null;
            if (methodDeclaration.hasFunctionBody()) {
                if (!isTemplate) {
                    Method newElement;
                    methodElement = newElement = new Method((ICElement)parent, name);
                } else {
                    MethodTemplate newElement = new MethodTemplate((ICElement)parent, name);
                    methodElement = newElement;
                }
            } else if (!isTemplate) {
                MethodDeclaration newElement = new MethodDeclaration((ICElement)parent, name);
                methodElement = newElement;
            } else {
                MethodTemplateDeclaration newElement = new MethodTemplateDeclaration((ICElement)parent, name);
                methodElement = newElement;
            }
            methodElement.setParameterTypes(parameterTypes);
            methodElement.setReturnType(ASTUtil.getType((IASTAbstractDeclaration)functionDeclaration.getReturnType()));
            methodElement.setStatic(functionDeclaration.isStatic());
            methodElement.setVisibility(methodDeclaration.getVisiblity());
            methodElement.setVolatile(methodDeclaration.isVolatile());
            methodElement.setConst(methodDeclaration.isConst());
            methodElement.setVirtual(methodDeclaration.isVirtual());
            methodElement.setPureVirtual(methodDeclaration.isPureVirtual());
            methodElement.setInline(methodDeclaration.isInline());
            methodElement.setFriend(methodDeclaration.isFriend());
            methodElement.setConstructor(methodDeclaration.isConstructor());
            methodElement.setDestructor(methodDeclaration.isDestructor());
            element = methodElement;
        } else {
            Function functionElement = null;
            if (functionDeclaration.hasFunctionBody()) {
                if (!isTemplate) {
                    Function newElement;
                    functionElement = newElement = new Function((ICElement)parent, name);
                } else {
                    FunctionTemplate newElement = new FunctionTemplate((ICElement)parent, name);
                    functionElement = newElement;
                }
            } else if (!isTemplate) {
                FunctionDeclaration newElement = new FunctionDeclaration((ICElement)parent, name);
                functionElement = newElement;
            } else {
                FunctionTemplateDeclaration newElement = new FunctionTemplateDeclaration((ICElement)parent, name);
                functionElement = newElement;
            }
            functionElement.setParameterTypes(parameterTypes);
            functionElement.setReturnType(ASTUtil.getType((IASTAbstractDeclaration)functionDeclaration.getReturnType()));
            functionElement.setStatic(functionDeclaration.isStatic());
            element = functionElement;
        }
        parent.addChild((ICElement)element);
        element.setIdPos(functionDeclaration.getNameOffset(), functionDeclaration.getNameEndOffset() - functionDeclaration.getNameOffset());
        if (!isTemplate) {
            element.setPos(functionDeclaration.getStartingOffset(), functionDeclaration.getEndingOffset() - functionDeclaration.getStartingOffset());
        }
        element.setLines(functionDeclaration.getStartingLine(), functionDeclaration.getEndingLine());
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    private Using createUsingDirective(Parent parent, IASTUsingDirective usingDirDeclaration) throws CModelException {
        String name = usingDirDeclaration.getNamespaceName();
        Using element = new Using((ICElement)parent, name, true);
        parent.addChild((ICElement)element);
        element.setIdPos(usingDirDeclaration.getNameOffset(), usingDirDeclaration.getNameEndOffset() - usingDirDeclaration.getNameOffset());
        element.setPos(usingDirDeclaration.getStartingOffset(), usingDirDeclaration.getEndingOffset() - usingDirDeclaration.getStartingOffset());
        element.setLines(usingDirDeclaration.getStartingLine(), usingDirDeclaration.getEndingLine());
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    private Using createUsingDeclaration(Parent parent, IASTUsingDeclaration usingDeclaration) throws CModelException {
        String name = usingDeclaration.usingTypeName();
        Using element = new Using((ICElement)parent, name, false);
        parent.addChild((ICElement)element);
        element.setIdPos(usingDeclaration.getNameOffset(), usingDeclaration.getNameEndOffset() - usingDeclaration.getNameOffset());
        element.setPos(usingDeclaration.getStartingOffset(), usingDeclaration.getEndingOffset() - usingDeclaration.getStartingOffset());
        element.setLines(usingDeclaration.getStartingLine(), usingDeclaration.getEndingLine());
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    public Map getNewElements() {
        return this.newElements;
    }

    class ProblemCallback
    extends StructuralParseCallback {
        IProblemRequestor problemRequestor;

        public ProblemCallback(IProblemRequestor requestor) {
            this.problemRequestor = requestor;
        }

        public boolean acceptProblem(IProblem problem) {
            if (this.inclusionLevel == 0) {
                this.problemRequestor.acceptProblem(problem);
            }
            return true;
        }
    }
}

