/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fdt.internal.errorparsers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;

public class XLFErrorParser
implements IErrorParser {
    Pattern p1 = Pattern.compile("^\"([^\"]*)\", line (\\d+)\\.(\\d+): (\\d+)-(\\d+) \\(([USEWLI])\\) (.*)$");
    Pattern p2 = Pattern.compile("^\"([^\"]*)\", (\\d+)-(\\d+) \\(([USEWLI])\\) (.*)$");

    public boolean processLine(String line, ErrorParserManager eoParser) {
        return this.processLine(line, eoParser, 2);
    }

    public boolean processLine(String line, ErrorParserManager eoParser, int inheritedSeverity) {
        String desc;
        String fileName;
        String varName = "";
        String level = "S";
        int num = -1;
        Matcher m = this.p1.matcher(line);
        if (m.matches()) {
            fileName = m.group(1);
            String lineNum = m.group(2);
            m.group(3);
            m.group(4);
            m.group(5);
            level = m.group(6);
            desc = m.group(7);
            try {
                num = Integer.parseInt(lineNum);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            m = this.p2.matcher(line);
            if (m.matches()) {
                fileName = m.group(1);
                m.group(2);
                m.group(3);
                level = m.group(4);
                desc = m.group(5);
            } else {
                return false;
            }
        }
        if (!Path.EMPTY.isValidPath(fileName)) {
            return false;
        }
        IFile file = eoParser.findFileName(fileName);
        if (file != null) {
            if (eoParser.isConflictingName(fileName)) {
                desc = "[Conflicting names: " + fileName + " ] " + desc;
                file = null;
            }
        } else {
            Path path;
            file = eoParser.findFilePath(fileName);
            if (file == null && (path = new Path(fileName)).segmentCount() > 1) {
                String name = path.lastSegment();
                file = eoParser.findFileName(fileName);
                if (file != null && eoParser.isConflictingName(fileName)) {
                    desc = "[Conflicting names: " + name + " ] " + desc;
                    file = null;
                }
            }
        }
        if (file == null) {
            desc = String.valueOf(desc) + " [" + fileName + "]";
        }
        int severity = this.extractSeverity(level, inheritedSeverity);
        eoParser.generateMarker((IResource)file, num, desc, severity, varName);
        return true;
    }

    private int extractSeverity(String desc, int defaultSeverity) {
        int severity = defaultSeverity;
        if (desc == "U" || desc == "S") {
            severity = 3;
        } else if (desc == "E") {
            severity = 2;
        } else if (desc == "W" || desc == "L") {
            severity = 1;
        } else if (desc == "I") {
            severity = 0;
        }
        return severity;
    }
}

