/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fdt.internal.ui.text;

import org.eclipse.cdt.internal.ui.text.BufferedDocumentScanner;
import org.eclipse.fdt.internal.ui.text.IFortranPartitions;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class FastFortranPartitionScanner
implements IPartitionTokenScanner,
IFortranPartitions {
    private static final int FORTRANCODE = 0;
    private static final int SINGLE_LINE_COMMENT = 1;
    private static final int STRING = 2;
    private static final int NONE = 0;
    private static final int BACKSLASH = 1;
    private static final int BANG = 2;
    private static final int CARRIAGE_RETURN = 3;
    private final BufferedDocumentScanner fScanner = new BufferedDocumentScanner(1000);
    private int fTokenOffset;
    private int fTokenLength;
    private int fState;
    private int fLast;
    private int fPrefixLength;
    private int fCOffset;
    private int fCLength;
    private final IToken[] fTokens = new IToken[]{new Token(null), new Token((Object)"fortran_single_line_comment"), new Token((Object)"__skip"), new Token((Object)"fortran_string")};

    public IToken nextToken() {
        this.fTokenOffset += this.fTokenLength;
        this.fTokenLength = this.fPrefixLength;
        block33: while (true) {
            int ch = this.fScanner.read();
            switch (ch) {
                case -1: {
                    if (this.fTokenLength > 0) {
                        this.fLast = 0;
                        return this.preFix(this.fState, 0, 0, 0);
                    }
                    this.fLast = 0;
                    this.fPrefixLength = 0;
                    return Token.EOF;
                }
                case 13: {
                    if (this.fLast != 3) {
                        this.fLast = 3;
                        ++this.fTokenLength;
                        continue block33;
                    }
                    switch (this.fState) {
                        case 1: 
                        case 2: {
                            if (this.fTokenLength > 0) {
                                IToken token = this.fTokens[this.fState];
                                this.fLast = 3;
                                this.fPrefixLength = 1;
                                this.fState = 0;
                                return token;
                            }
                            this.consume();
                            continue block33;
                        }
                    }
                    this.consume();
                    continue block33;
                }
                case 10: {
                    switch (this.fState) {
                        case 1: 
                        case 2: {
                            return this.postFix(this.fState);
                        }
                    }
                    this.consume();
                    continue block33;
                }
            }
            if (this.fLast == 3) {
                switch (this.fState) {
                    case 1: 
                    case 2: {
                        int newState;
                        int last;
                        switch (ch) {
                            case 33: {
                                last = 2;
                                newState = 0;
                                break;
                            }
                            case 34: 
                            case 39: {
                                last = 0;
                                newState = 2;
                                break;
                            }
                            case 13: {
                                last = 3;
                                newState = 0;
                                break;
                            }
                            case 92: {
                                last = 1;
                                newState = 0;
                                break;
                            }
                            default: {
                                last = 0;
                                newState = 0;
                            }
                        }
                        this.fLast = 0;
                        return this.preFix(this.fState, newState, last, 1);
                    }
                }
            }
            block20 : switch (this.fState) {
                case 0: {
                    switch (ch) {
                        case 33: {
                            if (this.fTokenLength > 0) {
                                return this.preFix(0, 1, 0, 1);
                            }
                            this.preFix(0, 1, 0, 1);
                            this.fTokenOffset += this.fTokenLength;
                            this.fTokenLength = this.fPrefixLength;
                            break block20;
                        }
                        case 34: 
                        case 39: {
                            this.fLast = 0;
                            if (this.fTokenLength > 0) {
                                return this.preFix(0, 2, 0, 1);
                            }
                            this.preFix(0, 2, 0, 1);
                            this.fTokenOffset += this.fTokenLength;
                            this.fTokenLength = this.fPrefixLength;
                            break block20;
                        }
                    }
                    this.consume();
                    break;
                }
                case 1: {
                    this.consume();
                    break;
                }
                case 2: {
                    switch (ch) {
                        case 92: {
                            this.fLast = this.fLast == 1 ? 0 : 1;
                            ++this.fTokenLength;
                            break block20;
                        }
                        case 34: 
                        case 39: {
                            if (this.fLast != 1) {
                                return this.postFix(2);
                            }
                            this.consume();
                            break block20;
                        }
                    }
                    this.consume();
                }
            }
        }
    }

    private static final int getLastLength(int last) {
        switch (last) {
            default: {
                return -1;
            }
            case 0: {
                return 0;
            }
            case 1: 
            case 2: 
            case 3: 
        }
        return 1;
    }

    private final void consume() {
        ++this.fTokenLength;
        this.fLast = 0;
    }

    private final IToken postFix(int state) {
        ++this.fTokenLength;
        this.fLast = 0;
        this.fState = 0;
        this.fPrefixLength = 0;
        return this.fTokens[state];
    }

    private final IToken preFix(int state, int newState, int last, int prefixLength) {
        this.fTokenLength -= FastFortranPartitionScanner.getLastLength(this.fLast);
        this.fLast = last;
        this.fPrefixLength = prefixLength;
        IToken token = this.fTokens[state];
        this.fState = newState;
        return token;
    }

    private static int getState(String contentType) {
        if (contentType == null) {
            return 0;
        }
        if (contentType.equals("fortran_single_line_comment")) {
            return 1;
        }
        if (contentType.equals("fortran_string")) {
            return 2;
        }
        return 0;
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        this.fScanner.setRange(document, offset, length);
        this.fTokenOffset = partitionOffset;
        this.fTokenLength = 0;
        this.fPrefixLength = offset - partitionOffset;
        this.fLast = 0;
        this.fState = offset == partitionOffset ? 0 : FastFortranPartitionScanner.getState(contentType);
    }

    public void setRange(IDocument document, int offset, int length) {
        this.fScanner.setRange(document, offset, length);
        this.fTokenOffset = offset;
        this.fTokenLength = 0;
        this.fPrefixLength = 0;
        this.fLast = 0;
        this.fState = 0;
    }

    public int getTokenLength() {
        return this.fTokenLength;
    }

    public int getTokenOffset() {
        return this.fTokenOffset;
    }
}

