/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fdt.internal.ui.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.internal.ui.text.AbstractCScanner;
import org.eclipse.cdt.internal.ui.text.IColorManager;
import org.eclipse.fdt.core.parser.FortranKeywordSetKey;
import org.eclipse.fdt.internal.core.parser.token.FortranKeywordSets;
import org.eclipse.fdt.internal.ui.text.FortranBraceRule;
import org.eclipse.fdt.internal.ui.text.FortranOperatorRule;
import org.eclipse.fdt.internal.ui.text.IgnoreCaseWordRule;
import org.eclipse.fdt.internal.ui.text.NumberRule;
import org.eclipse.fdt.internal.ui.text.util.FortranWordDetector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;

public final class FortranCodeScanner
extends AbstractCScanner {
    private static String[] fgConstants = new String[]{".EQ.", ".NE.", ".LT.", ".GT.", ".GE.", ".LG.", ".NOT.", ".N.", ".AND.", ".A.", ".OR.", ".O.", ".EQV.", ".NEQV.", ".XOR.", ".TRUE.", ".FALSE."};
    private static String[] fgTokenProperties = new String[]{"fortran_keyword", "fortran_type", "fortran_string", "fortran_operators", "fortran_braces", "fortran_numbers", "fortran_default"};

    public FortranCodeScanner(IColorManager manager, IPreferenceStore store) {
        super(manager, store);
        this.initialize();
    }

    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    protected List createRules() {
        ArrayList<Object> rules = new ArrayList<Object>();
        Token token = this.getToken("fortran_string");
        rules.add(new SingleLineRule("'", "'", (IToken)token, '\\'));
        rules.add(new SingleLineRule("\"", "\"", (IToken)token, '\\'));
        token = this.getToken("fortran_default");
        IgnoreCaseWordRule wordRule = new IgnoreCaseWordRule(new FortranWordDetector(), (IToken)token);
        token = this.getToken("fortran_keyword");
        Iterator i = FortranKeywordSets.getKeywords((FortranKeywordSetKey)FortranKeywordSetKey.KEYWORDS).iterator();
        while (i.hasNext()) {
            wordRule.addWord((String)i.next(), (IToken)token);
        }
        int j = 0;
        while (j < fgConstants.length) {
            wordRule.addWord(fgConstants[j], (IToken)token);
            ++j;
        }
        token = this.getToken("fortran_type");
        i = FortranKeywordSets.getKeywords((FortranKeywordSetKey)FortranKeywordSetKey.TYPES).iterator();
        while (i.hasNext()) {
            wordRule.addWord((String)i.next(), (IToken)token);
        }
        rules.add(wordRule);
        token = this.getToken("fortran_numbers");
        NumberRule numberRule = new NumberRule((IToken)token);
        rules.add(numberRule);
        token = this.getToken("fortran_operators");
        FortranOperatorRule opRule = new FortranOperatorRule((IToken)token);
        rules.add((Object)opRule);
        token = this.getToken("fortran_braces");
        FortranBraceRule braceRule = new FortranBraceRule((IToken)token);
        rules.add((Object)braceRule);
        this.setDefaultReturnToken((IToken)this.getToken("fortran_default"));
        return rules;
    }

    public void setRules(IRule[] rules) {
        super.setRules(rules);
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return super.affectsBehavior(event);
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (super.affectsBehavior(event)) {
            super.adaptToPreferenceChange(event);
        }
    }
}

