/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fdt.internal.ui.text;

import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.text.IColorManager;
import org.eclipse.cdt.internal.ui.text.util.CColorManager;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.fdt.internal.ui.text.FastFortranPartitionScanner;
import org.eclipse.fdt.internal.ui.text.FortranCodeScanner;
import org.eclipse.fdt.internal.ui.text.FortranCommentScanner;
import org.eclipse.fdt.internal.ui.text.SingleTokenFortranScanner;
import org.eclipse.fdt.ui.FortranUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class FortranTextTools
extends CTextTools {
    private CColorManager fColorManager;
    private FortranCodeScanner fCodeScanner;
    private FastFortranPartitionScanner fPartitionScanner;
    private FortranCommentScanner fSinglelineCommentScanner;
    private SingleTokenFortranScanner fStringScanner;
    private IPreferenceStore fPreferenceStore;
    private Preferences fCorePreferenceStore;
    private PreferenceListener fPreferenceListener = new PreferenceListener();

    public FortranTextTools(IPreferenceStore store) {
        this(store, null);
    }

    public FortranTextTools(IPreferenceStore store, Preferences coreStore) {
        if (store == null) {
            store = FortranUIPlugin.getDefault().getPreferenceStore();
        }
        this.fPreferenceStore = store;
        this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        this.fCorePreferenceStore = coreStore;
        if (this.fCorePreferenceStore != null) {
            this.fCorePreferenceStore.addPropertyChangeListener((Preferences.IPropertyChangeListener)this.fPreferenceListener);
        }
        this.fColorManager = new CColorManager();
        this.fCodeScanner = new FortranCodeScanner((IColorManager)this.fColorManager, store);
        this.fPartitionScanner = new FastFortranPartitionScanner();
        this.fSinglelineCommentScanner = new FortranCommentScanner((IColorManager)this.fColorManager, store, coreStore, "fortran_single_line_comment");
        this.fStringScanner = new SingleTokenFortranScanner((IColorManager)this.fColorManager, store, "fortran_string");
    }

    public FortranTextTools() {
        this(null);
    }

    public void dispose() {
        this.fCodeScanner = null;
        this.fPartitionScanner = null;
        this.fSinglelineCommentScanner = null;
        this.fStringScanner = null;
        if (this.fColorManager != null) {
            this.fColorManager.dispose();
            this.fColorManager = null;
        }
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
            this.fPreferenceStore = null;
            if (this.fCorePreferenceStore != null) {
                this.fCorePreferenceStore.removePropertyChangeListener((Preferences.IPropertyChangeListener)this.fPreferenceListener);
                this.fCorePreferenceStore = null;
            }
            this.fPreferenceListener = null;
        }
    }

    public CColorManager getColorManager() {
        return this.fColorManager;
    }

    public RuleBasedScanner getFortranCodeScanner() {
        return this.fCodeScanner;
    }

    public IPartitionTokenScanner getPartitionScanner() {
        return this.fPartitionScanner;
    }

    public IDocumentPartitioner createDocumentPartitioner() {
        String[] types = new String[]{"fortran_single_line_comment", "fortran_string"};
        return new FastPartitioner(this.getPartitionScanner(), types);
    }

    public RuleBasedScanner getSinglelineCommentScanner() {
        return this.fSinglelineCommentScanner;
    }

    public RuleBasedScanner getStringScanner() {
        return this.fStringScanner;
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return this.fCodeScanner.affectsBehavior(event) || this.fSinglelineCommentScanner.affectsBehavior(event) || this.fStringScanner.affectsBehavior(event);
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (this.fCodeScanner.affectsBehavior(event)) {
            this.fCodeScanner.adaptToPreferenceChange(event);
        }
        if (this.fSinglelineCommentScanner.affectsBehavior(event)) {
            this.fSinglelineCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fStringScanner.affectsBehavior(event)) {
            this.fStringScanner.adaptToPreferenceChange(event);
        }
    }

    private class PreferenceListener
    implements IPropertyChangeListener,
    Preferences.IPropertyChangeListener {
        PreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            FortranTextTools.this.adaptToPreferenceChange(event);
        }

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            FortranTextTools.this.adaptToPreferenceChange(new PropertyChangeEvent(event.getSource(), event.getProperty(), event.getOldValue(), event.getNewValue()));
        }
    }
}

