/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fdt.internal.core.parser.token;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.fdt.core.parser.FortranKeywordSetKey;

public class FortranKeywordSets {
    private static final Set EMPTY_TABLE = new HashSet(0);
    private static final Set DECLARATION_FORTRAN = new TreeSet();
    private static final Set EXPRESSION_FORTRAN;
    private static final Set STATEMENT_FORTRAN;
    private static final Set ALL_FORTRAN;
    private static Set FortranKeywords_FORTRAN;
    private static final Set TYPES_FORTRAN;

    static {
        DECLARATION_FORTRAN.add("block");
        DECLARATION_FORTRAN.add("common");
        DECLARATION_FORTRAN.add("data");
        DECLARATION_FORTRAN.add("dimension");
        DECLARATION_FORTRAN.add("equivalence");
        DECLARATION_FORTRAN.add("external");
        DECLARATION_FORTRAN.add("format");
        DECLARATION_FORTRAN.add("implicit");
        DECLARATION_FORTRAN.add("interface");
        DECLARATION_FORTRAN.add("intrinsic");
        DECLARATION_FORTRAN.add("map");
        DECLARATION_FORTRAN.add("parameter");
        DECLARATION_FORTRAN.add("program");
        DECLARATION_FORTRAN.add("record");
        DECLARATION_FORTRAN.add("union");
        DECLARATION_FORTRAN.add("structure");
        DECLARATION_FORTRAN.add("subroutine");
        EXPRESSION_FORTRAN = new TreeSet();
        EXPRESSION_FORTRAN.add("byte");
        EXPRESSION_FORTRAN.add("character");
        EXPRESSION_FORTRAN.add("complex");
        EXPRESSION_FORTRAN.add("double");
        EXPRESSION_FORTRAN.add("integer");
        EXPRESSION_FORTRAN.add("logical");
        EXPRESSION_FORTRAN.add("precision");
        EXPRESSION_FORTRAN.add("real");
        STATEMENT_FORTRAN = new TreeSet();
        STATEMENT_FORTRAN.addAll(DECLARATION_FORTRAN);
        STATEMENT_FORTRAN.addAll(EXPRESSION_FORTRAN);
        STATEMENT_FORTRAN.add("call");
        STATEMENT_FORTRAN.add("case");
        STATEMENT_FORTRAN.add("close");
        STATEMENT_FORTRAN.add("continue");
        STATEMENT_FORTRAN.add("cycle");
        STATEMENT_FORTRAN.add("do");
        STATEMENT_FORTRAN.add("else");
        STATEMENT_FORTRAN.add("end");
        STATEMENT_FORTRAN.add("endfile");
        STATEMENT_FORTRAN.add("entry");
        STATEMENT_FORTRAN.add("exit");
        STATEMENT_FORTRAN.add("function");
        STATEMENT_FORTRAN.add("goto");
        STATEMENT_FORTRAN.add("if");
        STATEMENT_FORTRAN.add("function");
        STATEMENT_FORTRAN.add("inquire");
        STATEMENT_FORTRAN.add("open");
        STATEMENT_FORTRAN.add("pause");
        STATEMENT_FORTRAN.add("print");
        STATEMENT_FORTRAN.add("read");
        STATEMENT_FORTRAN.add("return");
        STATEMENT_FORTRAN.add("rewind");
        STATEMENT_FORTRAN.add("save");
        STATEMENT_FORTRAN.add("select");
        STATEMENT_FORTRAN.add("stop");
        STATEMENT_FORTRAN.add("then");
        STATEMENT_FORTRAN.add("write");
        STATEMENT_FORTRAN.add("while");
        ALL_FORTRAN = new TreeSet();
        ALL_FORTRAN.add("allocate");
        ALL_FORTRAN.add("assign");
        ALL_FORTRAN.add("backspace");
        ALL_FORTRAN.add("block");
        ALL_FORTRAN.add("byte");
        ALL_FORTRAN.add("call");
        ALL_FORTRAN.add("case");
        ALL_FORTRAN.add("character");
        ALL_FORTRAN.add("close");
        ALL_FORTRAN.add("common");
        ALL_FORTRAN.add("complex");
        ALL_FORTRAN.add("cycle");
        ALL_FORTRAN.add("data");
        ALL_FORTRAN.add("deallocate");
        ALL_FORTRAN.add("dimension");
        ALL_FORTRAN.add("do");
        ALL_FORTRAN.add("double");
        ALL_FORTRAN.add("else");
        ALL_FORTRAN.add("end");
        ALL_FORTRAN.add("endfile");
        ALL_FORTRAN.add("entry");
        ALL_FORTRAN.add("equivalence");
        ALL_FORTRAN.add("exit");
        ALL_FORTRAN.add("external");
        ALL_FORTRAN.add("format");
        ALL_FORTRAN.add("function");
        ALL_FORTRAN.add("goto");
        ALL_FORTRAN.add("if");
        ALL_FORTRAN.add("implicit");
        ALL_FORTRAN.add("include");
        ALL_FORTRAN.add("inquire");
        ALL_FORTRAN.add("integer");
        ALL_FORTRAN.add("interface");
        ALL_FORTRAN.add("intrinsic");
        ALL_FORTRAN.add("locking");
        ALL_FORTRAN.add("logical");
        ALL_FORTRAN.add("map");
        ALL_FORTRAN.add("namelist");
        ALL_FORTRAN.add("open");
        ALL_FORTRAN.add("parameter");
        ALL_FORTRAN.add("pause");
        ALL_FORTRAN.add("precision");
        ALL_FORTRAN.add("print");
        ALL_FORTRAN.add("program");
        ALL_FORTRAN.add("read");
        ALL_FORTRAN.add("real");
        ALL_FORTRAN.add("record");
        ALL_FORTRAN.add("return");
        ALL_FORTRAN.add("rewind");
        ALL_FORTRAN.add("save");
        ALL_FORTRAN.add("select");
        ALL_FORTRAN.add("stop");
        ALL_FORTRAN.add("structure");
        ALL_FORTRAN.add("subroutine");
        ALL_FORTRAN.add("then");
        ALL_FORTRAN.add("to");
        ALL_FORTRAN.add("union");
        ALL_FORTRAN.add("while");
        ALL_FORTRAN.add("write");
        FortranKeywords_FORTRAN = new TreeSet();
        FortranKeywords_FORTRAN.add("allocate");
        FortranKeywords_FORTRAN.add("assign");
        FortranKeywords_FORTRAN.add("backspace");
        FortranKeywords_FORTRAN.add("block");
        FortranKeywords_FORTRAN.add("byte");
        FortranKeywords_FORTRAN.add("call");
        FortranKeywords_FORTRAN.add("case");
        FortranKeywords_FORTRAN.add("character");
        FortranKeywords_FORTRAN.add("close");
        FortranKeywords_FORTRAN.add("common");
        FortranKeywords_FORTRAN.add("complex");
        FortranKeywords_FORTRAN.add("cycle");
        FortranKeywords_FORTRAN.add("data");
        FortranKeywords_FORTRAN.add("deallocate");
        FortranKeywords_FORTRAN.add("dimension");
        FortranKeywords_FORTRAN.add("do");
        FortranKeywords_FORTRAN.add("double");
        FortranKeywords_FORTRAN.add("else");
        FortranKeywords_FORTRAN.add("end");
        FortranKeywords_FORTRAN.add("endfile");
        FortranKeywords_FORTRAN.add("entry");
        FortranKeywords_FORTRAN.add("equivalence");
        FortranKeywords_FORTRAN.add("exit");
        FortranKeywords_FORTRAN.add("external");
        FortranKeywords_FORTRAN.add("format");
        FortranKeywords_FORTRAN.add("function");
        FortranKeywords_FORTRAN.add("goto");
        FortranKeywords_FORTRAN.add("if");
        FortranKeywords_FORTRAN.add("implicit");
        FortranKeywords_FORTRAN.add("include");
        FortranKeywords_FORTRAN.add("inquire");
        FortranKeywords_FORTRAN.add("integer");
        FortranKeywords_FORTRAN.add("interface");
        FortranKeywords_FORTRAN.add("intrinsic");
        FortranKeywords_FORTRAN.add("locking");
        FortranKeywords_FORTRAN.add("logical");
        FortranKeywords_FORTRAN.add("map");
        FortranKeywords_FORTRAN.add("namelist");
        FortranKeywords_FORTRAN.add("open");
        FortranKeywords_FORTRAN.add("parameter");
        FortranKeywords_FORTRAN.add("pause");
        FortranKeywords_FORTRAN.add("precision");
        FortranKeywords_FORTRAN.add("print");
        FortranKeywords_FORTRAN.add("program");
        FortranKeywords_FORTRAN.add("read");
        FortranKeywords_FORTRAN.add("real");
        FortranKeywords_FORTRAN.add("record");
        FortranKeywords_FORTRAN.add("return");
        FortranKeywords_FORTRAN.add("rewind");
        FortranKeywords_FORTRAN.add("save");
        FortranKeywords_FORTRAN.add("select");
        FortranKeywords_FORTRAN.add("stop");
        FortranKeywords_FORTRAN.add("structure");
        FortranKeywords_FORTRAN.add("subroutine");
        FortranKeywords_FORTRAN.add("then");
        FortranKeywords_FORTRAN.add("to");
        FortranKeywords_FORTRAN.add("union");
        FortranKeywords_FORTRAN.add("while");
        FortranKeywords_FORTRAN.add("write");
        TYPES_FORTRAN = new TreeSet();
        TYPES_FORTRAN.add("byte");
        TYPES_FORTRAN.add("character");
        TYPES_FORTRAN.add("complex");
        TYPES_FORTRAN.add("double");
        TYPES_FORTRAN.add("integer");
        TYPES_FORTRAN.add("logical");
        TYPES_FORTRAN.add("precision");
        TYPES_FORTRAN.add("real");
    }

    public static Set getKeywords(FortranKeywordSetKey kind) {
        if (kind == FortranKeywordSetKey.EMPTY) {
            return EMPTY_TABLE;
        }
        if (kind == FortranKeywordSetKey.DECLARATION) {
            return DECLARATION_FORTRAN;
        }
        if (kind == FortranKeywordSetKey.STATEMENT) {
            return STATEMENT_FORTRAN;
        }
        if (kind == FortranKeywordSetKey.EXPRESSION) {
            return EXPRESSION_FORTRAN;
        }
        if (kind == FortranKeywordSetKey.ALL) {
            return ALL_FORTRAN;
        }
        if (kind == FortranKeywordSetKey.KEYWORDS) {
            return FortranKeywords_FORTRAN;
        }
        if (kind == FortranKeywordSetKey.TYPES) {
            return TYPES_FORTRAN;
        }
        return null;
    }
}

