/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fdt.managedbuilder.internal.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ManagedBuilderUIPlugin
extends AbstractUIPlugin {
    private static ManagedBuilderUIPlugin plugin;
    private static final String PLUGIN_ID = "org.eclipse.fdt.managedbuilder.ui";

    public ManagedBuilderUIPlugin() {
        plugin = this;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = ManagedBuilderUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return ManagedBuilderUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static ManagedBuilderUIPlugin getDefault() {
        return plugin;
    }

    public static String getUniqueIdentifier() {
        return PLUGIN_ID;
    }

    public static void log(IStatus status) {
        ResourcesPlugin.getPlugin().getLog().log(status);
    }

    public static void log(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        Object status = null;
        status = e instanceof CoreException ? ((CoreException)e).getStatus() : new Status(4, ManagedBuilderUIPlugin.getUniqueIdentifier(), 0, e.getMessage(), e);
        ManagedBuilderUIPlugin.log(status);
    }

    public static void errorDialog(Shell shell, String title, String message, Throwable t) {
        IStatus status;
        ManagedBuilderUIPlugin.log(t);
        if (t instanceof CoreException) {
            status = ((CoreException)t).getStatus();
            if (status != null && message.equals(status.getMessage())) {
                message = null;
            }
        } else {
            status = new Status(4, ManagedBuilderUIPlugin.getUniqueIdentifier(), -1, "Internal Error: ", t);
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public Shell getShell() {
        if (ManagedBuilderUIPlugin.getActiveWorkbenchShell() != null) {
            return ManagedBuilderUIPlugin.getActiveWorkbenchShell();
        }
        IWorkbenchWindow[] windows = ManagedBuilderUIPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        return windows[0].getShell();
    }
}

