/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.fdt.internal.ui.editor.FortranEditor;
import org.eclipse.fdt.internal.ui.text.FortranSourceViewerConfiguration;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.widgets.Composite;

public class FortranSourceViewer
extends ProjectionViewer
implements ITextViewerExtension {
    public static final int SHOW_OUTLINE = 101;
    private final FortranEditor editor;
    private IInformationPresenter fOutlinePresenter;
    private List fTextConverters;
    private String fDisplayLanguage;

    public FortranSourceViewer(FortranEditor editor, Composite parent, IVerticalRuler ruler, int styles, IOverviewRuler fOverviewRuler, boolean isOverviewRulerShowing, String language) {
        super(parent, ruler, fOverviewRuler, isOverviewRulerShowing, styles);
        this.editor = editor;
        this.fDisplayLanguage = language;
    }

    public IContentAssistant getContentAssistant() {
        return this.fContentAssistant;
    }

    public void configure(SourceViewerConfiguration configuration) {
        super.configure(configuration);
        if (configuration instanceof FortranSourceViewerConfiguration) {
            this.fOutlinePresenter = ((FortranSourceViewerConfiguration)configuration).getOutlinePresenter(this.editor);
            if (this.fOutlinePresenter != null) {
                this.fOutlinePresenter.install((ITextViewer)this);
            }
        }
    }

    public void unconfigure() {
        if (this.fOutlinePresenter != null) {
            this.fOutlinePresenter.uninstall();
            this.fOutlinePresenter = null;
        }
        super.unconfigure();
    }

    public void doOperation(int operation) {
        if (this.getTextWidget() == null) {
            return;
        }
        switch (operation) {
            case 13: {
                String msg = this.fContentAssistant.showPossibleCompletions();
                this.editor.setStatusLineErrorMessage(msg);
                return;
            }
            case 101: {
                this.fOutlinePresenter.showInformation();
                return;
            }
        }
        super.doOperation(operation);
    }

    public boolean canDoOperation(int operation) {
        if (operation == 101) {
            return this.fOutlinePresenter != null;
        }
        return super.canDoOperation(operation);
    }

    public void insertTextConverter(FortranEditor.ITextConverter textConverter, int index) {
        throw new UnsupportedOperationException();
    }

    public void addTextConverter(FortranEditor.ITextConverter textConverter) {
        if (this.fTextConverters == null) {
            this.fTextConverters = new ArrayList(1);
            this.fTextConverters.add(textConverter);
        } else if (!this.fTextConverters.contains(textConverter)) {
            this.fTextConverters.add(textConverter);
        }
    }

    public void removeTextConverter(FortranEditor.ITextConverter textConverter) {
        if (this.fTextConverters != null) {
            this.fTextConverters.remove(textConverter);
            if (this.fTextConverters.size() == 0) {
                this.fTextConverters = null;
            }
        }
    }

    protected void customizeDocumentCommand(DocumentCommand command) {
        super.customizeDocumentCommand(command);
        if (this.fTextConverters != null) {
            Iterator e = this.fTextConverters.iterator();
            while (e.hasNext()) {
                ((FortranEditor.ITextConverter)e.next()).customizeDocumentCommand(this.getDocument(), command);
            }
        }
    }

    public void setDisplayLanguage(String language) {
        this.fDisplayLanguage = language;
    }

    public String getDisplayLanguage() {
        return this.fDisplayLanguage;
    }

    public void setRangeIndication(int offset, int length, boolean moveCursor) {
        if (this.isProjectionMode()) {
            super.setRangeIndication(offset, length, moveCursor);
        } else {
            super.setRangeIndication(offset, length, false);
        }
    }
}

