/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fdt.internal.core.model;

import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.fdt.internal.core.model.FortranContainer;

public class FortranSourceRoot
extends FortranContainer
implements ISourceRoot {
    ISourceEntry sourceEntry;

    public FortranSourceRoot(ICElement parent, IResource res, ISourceEntry entry) {
        super(parent, res);
        this.sourceEntry = entry;
        IPath path = this.getPath();
        IPath cpath = this.getParent().getPath();
        if (path.segmentCount() > cpath.segmentCount()) {
            IPath p = path.removeFirstSegments(cpath.segmentCount());
            this.setElementName(p.toString());
        }
    }

    public ISourceEntry getSourceEntry() {
        return this.sourceEntry;
    }

    public boolean isOnSourceEntry(ICElement element) {
        IPath path = element.getPath();
        return this.isOnSourceEntry(path);
    }

    public boolean isOnSourceEntry(IResource res) {
        IPath path = res.getFullPath();
        return this.isOnSourceEntry(path);
    }

    public boolean isOnSourceEntry(IPath path) {
        return this.sourceEntry.getPath().isPrefixOf(path) && !CoreModelUtil.isExcluded((IPath)path, (char[][])this.sourceEntry.fullExclusionPatternChars());
    }
}

