/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fdt.managedbuilder.core.makegen;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedOutputNameProvider;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGenerator;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.fdt.core.FortranLanguage;

public class DefaultFortranDependencyCalculator
implements IManagedDependencyGenerator,
IManagedOutputNameProvider {
    public static final String MODULE_EXTENSION = "o";

    private String[] findUsedModuleNames(File file) {
        ArrayList<String> names = new ArrayList<String>();
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            StreamTokenizer st = new StreamTokenizer(r);
            st.commentChar(33);
            st.eolIsSignificant(false);
            st.slashSlashComments(false);
            st.slashStarComments(false);
            st.wordChars(95, 95);
            while (st.nextToken() != -1) {
                if (st.ttype != -3 || !st.sval.equalsIgnoreCase("use")) continue;
                st.nextToken();
                if (st.ttype == -3) {
                    names.add(st.sval);
                    continue;
                }
                st.pushBack();
            }
        }
        catch (Exception exception) {
            return new String[0];
        }
        return names.toArray(new String[names.size()]);
    }

    private String[] findModuleNames(File file) {
        ArrayList<String> names = new ArrayList<String>();
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            StreamTokenizer st = new StreamTokenizer(r);
            st.commentChar(33);
            st.eolIsSignificant(false);
            st.slashSlashComments(false);
            st.slashStarComments(false);
            st.wordChars(95, 95);
            while (st.nextToken() != -1) {
                if (st.ttype != -3 || !st.sval.equalsIgnoreCase("module")) continue;
                st.nextToken();
                if (st.ttype == -3) {
                    names.add(st.sval);
                    continue;
                }
                st.pushBack();
            }
        }
        catch (Exception exception) {
            return new String[0];
        }
        return names.toArray(new String[names.size()]);
    }

    private boolean isFortranFile(IProject project, File file, Collection fortranContentTypes) {
        try {
            IContentType ct = CCorePlugin.getContentType((IProject)project, (String)file.getCanonicalPath());
            if (ct != null) {
                return fortranContentTypes.contains(ct.toString());
            }
        }
        catch (Exception exception) {}
        return false;
    }

    private IResource[] FindModulesInResources(IProject project, Collection contentTypes, IResource resource, IResource[] resourcesToSearch, String topBuildDir, String[] usedNames) {
        ArrayList<Object> modRes = new ArrayList<Object>();
        int ir = 0;
        while (ir < resourcesToSearch.length) {
            if (!resourcesToSearch[ir].equals((Object)resource)) {
                if (resourcesToSearch[ir].getType() == 1) {
                    String[] modules;
                    File projectFile = resourcesToSearch[ir].getLocation().toFile();
                    if (this.isFortranFile(project, projectFile, contentTypes) && (modules = this.findModuleNames(projectFile)) != null) {
                        int iu = 0;
                        while (iu < usedNames.length) {
                            boolean foundDependency = false;
                            int im = 0;
                            while (im < modules.length) {
                                if (usedNames[iu].equalsIgnoreCase(modules[im])) {
                                    IPath modName = Path.fromOSString((String)(String.valueOf(topBuildDir) + '/' + modules[im] + "." + MODULE_EXTENSION));
                                    modRes.add(project.getFile(modName));
                                    foundDependency = true;
                                    break;
                                }
                                ++im;
                            }
                            if (!foundDependency) {
                                ++iu;
                                continue;
                            }
                            break;
                        }
                    }
                } else if (resourcesToSearch[ir].getType() == 2) {
                    try {
                        IResource[] modFound = this.FindModulesInResources(project, contentTypes, resource, ((IFolder)resourcesToSearch[ir]).members(), topBuildDir, usedNames);
                        if (modFound != null) {
                            int i = 0;
                            while (i < modFound.length) {
                                modRes.add(modFound[i]);
                                ++i;
                            }
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            ++ir;
        }
        return modRes.toArray(new IResource[modRes.size()]);
    }

    public IResource[] findDependencies(IResource resource, IProject project) {
        ArrayList<IResource> dependencies = new ArrayList<IResource>();
        Collection fortranContentTypes = new FortranLanguage().getRegisteredContentTypeIds();
        IManagedBuildInfo mngInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration config = mngInfo.getDefaultConfiguration();
        File file = resource.getLocation().toFile();
        try {
            IResource[] resources;
            IResource[] modRes;
            if (!this.isFortranFile(project, file, fortranContentTypes)) {
                return new IResource[0];
            }
            dependencies.add(resource);
            String[] usedNames = this.findUsedModuleNames(file);
            if (usedNames.length != 0 && (modRes = this.FindModulesInResources(project, fortranContentTypes, resource, resources = project.members(), config.getName(), usedNames)) != null) {
                int i = 0;
                while (i < modRes.length) {
                    dependencies.add(modRes[i]);
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            return new IResource[0];
        }
        return dependencies.toArray(new IResource[dependencies.size()]);
    }

    public int getCalculatorType() {
        return 3;
    }

    public String getDependencyCommand(IResource resource, IManagedBuildInfo info) {
        return null;
    }

    public IPath[] getOutputNames(ITool tool, IPath[] primaryInputNames) {
        String[] modules;
        ArrayList<IPath> outs = new ArrayList<IPath>();
        if (primaryInputNames.length > 0 && (modules = this.findModuleNames(primaryInputNames[0].toFile())) != null) {
            int i = 0;
            while (i < modules.length) {
                IPath modName = Path.fromOSString((String)("./" + modules[i] + "." + MODULE_EXTENSION));
                outs.add(modName);
                ++i;
            }
        }
        return outs.toArray(new IPath[outs.size()]);
    }
}

