/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.core.util.Queue;
import org.eclipse.ptp.debug.core.IAbstractDebugger;
import org.eclipse.ptp.debug.core.IDebugCommand;
import org.eclipse.ptp.debug.core.cdi.IPCDISession;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIErrorEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIExitedEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIResumedEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDISuspendedEvent;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIBreakpoint;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocator;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.debug.external.core.DebugCommandQueue;
import org.eclipse.ptp.debug.external.core.EventThread;
import org.eclipse.ptp.debug.external.core.PTPDebugExternalPlugin;
import org.eclipse.ptp.debug.external.core.cdi.Session;
import org.eclipse.ptp.debug.external.core.cdi.event.BreakpointCreatedEvent;
import org.eclipse.ptp.debug.external.core.cdi.event.BreakpointHitEvent;
import org.eclipse.ptp.debug.external.core.cdi.event.DebuggerExitedEvent;
import org.eclipse.ptp.debug.external.core.cdi.event.EndSteppingRangeEvent;
import org.eclipse.ptp.debug.external.core.cdi.event.ErrorEvent;
import org.eclipse.ptp.debug.external.core.cdi.event.InferiorExitedEvent;
import org.eclipse.ptp.debug.external.core.cdi.event.InferiorResumedEvent;
import org.eclipse.ptp.debug.external.core.cdi.event.InferiorSignaledEvent;
import org.eclipse.ptp.debug.external.core.cdi.event.SuspendEvent;
import org.eclipse.ptp.debug.external.core.cdi.model.LineLocation;
import org.eclipse.ptp.debug.external.core.commands.KillCommand;
import org.eclipse.ptp.debug.external.core.commands.StartDebuggerCommand;
import org.eclipse.ptp.debug.external.core.commands.StopDebuggerCommand;

public abstract class AbstractDebugger
extends Observable
implements IAbstractDebugger {
    protected Queue eventQueue = null;
    protected EventThread eventThread = null;
    protected IPCDISession session = null;
    protected IPProcess[] procs;
    protected boolean isExited = false;
    protected IPJob job = null;
    protected DebugCommandQueue commandQueue = null;

    public IPCDISession createDebuggerSession(IPLaunch launch, IBinaryParser.IBinaryObject exe, int timeout, IProgressMonitor monitor) throws CoreException {
        IPJob job = launch.getPJob();
        this.session = new Session(this, job, launch, exe);
        this.initialize(job, timeout);
        return this.session;
    }

    public void postCommand(IDebugCommand command) {
        this.commandQueue.addCommand(command);
    }

    public void completeCommand(BitList tasks, Object result) {
        this.commandQueue.setCommandReturn(tasks, result);
    }

    public final void initialize(IPJob job, int timeout) throws CoreException {
        this.job = job;
        job.setAttribute("terminated", (Object)new BitList(job.size()));
        job.setAttribute("suspended", (Object)new BitList(job.size()));
        this.commandQueue = new DebugCommandQueue(this, timeout);
        this.commandQueue.start();
        this.isExited = false;
        this.eventQueue = new Queue();
        this.eventThread = new EventThread(this);
        this.eventThread.start();
        this.procs = job.getSortedProcesses();
        StartDebuggerCommand command = new StartDebuggerCommand(job);
        this.postCommand(command);
        try {
            command.waitFnish();
        }
        catch (PCDIException e) {
            throw new CoreException((IStatus)new Status(4, PTPDebugExternalPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
        }
    }

    public final void exit() throws CoreException {
        this.stopDebugger();
        this.isExited = true;
        if (!this.eventThread.equals(Thread.currentThread())) {
            try {
                if (this.eventThread.isAlive()) {
                    this.eventThread.interrupt();
                    this.eventThread.join(5000L);
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        this.deleteObservers();
        this.commandQueue.setTerminated();
        if (this.session != null && !this.isJobFinished()) {
            this.setJobFinished(this.session.createBitList(), "exited");
        }
    }

    public final IPCDISession getSession() {
        return this.session;
    }

    public final void addDebuggerObserver(Observer obs) {
        this.addObserver(obs);
    }

    public final void deleteDebuggerObserver(Observer obs) {
        this.deleteObserver(obs);
    }

    public final void deleteAllObservers() {
        this.deleteObservers();
    }

    public final void fireEvents(IPCDIEvent[] events) {
        if (events != null && events.length > 0) {
            int i = 0;
            while (i < events.length) {
                this.fireEvent(events[i]);
                ++i;
            }
        }
    }

    private synchronized void setProcessStatus(int[] tasks, String state) {
        int i = 0;
        while (i < tasks.length) {
            this.getProcess(tasks[i]).setStatus(state);
            ++i;
        }
    }

    public final synchronized void fireEvent(IPCDIEvent event) {
        if (event != null) {
            this.eventQueue.addItem((Object)event);
            System.out.println("    --- Abs debugger: " + event);
            BitList tasks = event.getAllProcesses();
            if (event instanceof IPCDIExitedEvent) {
                this.setJobFinished(tasks, "exited");
            } else if (event instanceof IPCDIResumedEvent) {
                this.setSuspendTasks(false, tasks);
                this.setProcessStatus(tasks.toArray(), "running");
            } else if (event instanceof IPCDIErrorEvent) {
                IPCDIErrorEvent errEvent = (IPCDIErrorEvent)event;
                switch (errEvent.getErrorCode()) {
                    case 2: {
                        this.setJobFinished(tasks, "error");
                        this.postCommand(new StopDebuggerCommand());
                        break;
                    }
                    case 1: {
                        this.setJobFinished(tasks, "error");
                        this.postCommand(new KillCommand(event.getAllProcesses()));
                        break;
                    }
                    case 0: {
                        this.session.unregisterTargets(tasks.toArray(), true);
                    }
                }
            } else if (event instanceof IPCDISuspendedEvent) {
                this.setSuspendTasks(true, tasks);
                this.setProcessStatus(tasks.toArray(), "stopped");
            }
            if (event instanceof IPCDIExitedEvent && this.isJobFinished()) {
                this.postCommand(new StopDebuggerCommand());
            }
        }
    }

    private void setJobFinished(BitList tasks, String status) {
        if (this.session != null) {
            if (tasks == null) {
                tasks = this.session.createBitList();
            }
            this.setSuspendTasks(false, tasks);
            this.setTerminateTasks(true, tasks);
            this.session.unregisterTargets(tasks.toArray(), true);
        }
        this.setProcessStatus(tasks.toArray(), status);
    }

    public final void notifyObservers(Object arg) {
        this.setChanged();
        super.notifyObservers(arg);
    }

    public final Queue getEventQueue() {
        return this.eventQueue;
    }

    public final boolean isExited() {
        return this.isExited;
    }

    public void handleStopDebuggerEvent() {
        this.eventQueue.addItem((Object)new DebuggerExitedEvent(this.getSession(), new BitList(0)));
        if (this.session != null) {
            this.session.shutdown();
        }
    }

    public void handleBreakpointCreatedEvent(BitList tasks) {
        this.fireEvent(new BreakpointCreatedEvent(this.getSession(), tasks));
    }

    public void handleBreakpointHitEvent(BitList tasks, int bpid) {
        IPCDIBreakpoint bpt = ((Session)this.getSession()).getBreakpointManager().findCDIBreakpoint(bpid);
        if (bpt != null) {
            this.fireEvent(new BreakpointHitEvent(this.getSession(), tasks, bpt));
        }
    }

    public void handleSuspendEvent(BitList tasks, IPCDILocator locator) {
        this.fireEvent(new SuspendEvent(this.getSession(), tasks, locator));
    }

    public void handleEndSteppingEvent(BitList tasks, int lineNumber, String filename) {
        LineLocation loc = new LineLocation(filename, lineNumber);
        this.fireEvent(new EndSteppingRangeEvent(this.getSession(), tasks, loc));
    }

    public void handleProcessResumedEvent(BitList tasks) {
        this.fireEvent(new InferiorResumedEvent(this.getSession(), tasks));
    }

    public void handleProcessTerminatedEvent(BitList tasks) {
        this.fireEvent(new InferiorExitedEvent(this.getSession(), tasks));
    }

    public void handleProcessSignaledEvent(BitList tasks, IPCDILocator locator) {
        this.fireEvent(new InferiorSignaledEvent(this.getSession(), tasks, locator));
    }

    public void handleErrorEvent(BitList tasks, String errMsg, int errCode) {
        System.err.println("----- debugger error: " + errMsg + " ------------");
        if (errCode == 2 && this.session != null) {
            tasks = ((Session)this.session).createBitList();
        }
        this.fireEvent(new ErrorEvent(this.getSession(), tasks, errMsg, errCode));
    }

    public IPProcess getProcess(int number) {
        return this.procs[number];
    }

    public IPProcess[] getProcesses(BitList tasks) {
        int[] taskArray = tasks.toArray();
        IPProcess[] processes = new IPProcess[taskArray.length];
        int i = 0;
        while (i < taskArray.length) {
            processes[i] = this.getProcess(taskArray[i]);
            ++i;
        }
        return processes;
    }

    public BitList filterRunningTasks(BitList tasks) {
        this.removeTasks(tasks, (BitList)this.job.getAttribute("terminated"));
        BitList suspendedTasks = (BitList)this.job.getAttribute("suspended");
        if (suspendedTasks.cardinality() > 0) {
            tasks.and(suspendedTasks);
        }
        return tasks;
    }

    public BitList filterSuspendTasks(BitList tasks) {
        this.removeTasks(tasks, (BitList)this.job.getAttribute("terminated"));
        this.removeTasks(tasks, (BitList)this.job.getAttribute("suspended"));
        return tasks;
    }

    public BitList filterTerminateTasks(BitList tasks) {
        this.removeTasks(tasks, (BitList)this.job.getAttribute("terminated"));
        return tasks;
    }

    public boolean isJobFinished() {
        BitList terminatedTasks = (BitList)this.job.getAttribute("terminated");
        return terminatedTasks.cardinality() == this.job.size();
    }

    private BitList addTasks(BitList curTasks, BitList newTasks) {
        if (curTasks.size() < newTasks.size()) {
            newTasks.or(curTasks);
            return newTasks.copy();
        }
        curTasks.or(newTasks);
        return curTasks;
    }

    private void removeTasks(BitList curTasks, BitList newTasks) {
        curTasks.andNot(newTasks);
    }

    private void setTerminateTasks(boolean isAdd, BitList tasks) {
        BitList terminatedTasks = (BitList)this.job.getAttribute("terminated");
        if (isAdd) {
            terminatedTasks = this.addTasks(terminatedTasks, tasks);
        } else {
            this.removeTasks(terminatedTasks, tasks);
        }
    }

    private void setSuspendTasks(boolean isAdd, BitList tasks) {
        BitList suspendedTasks = (BitList)this.job.getAttribute("suspended");
        if (isAdd) {
            suspendedTasks = this.addTasks(suspendedTasks, tasks);
        } else {
            this.removeTasks(suspendedTasks, tasks);
        }
    }
}

