/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.IAbstractDebugger;
import org.eclipse.ptp.debug.core.IDebugCommand;
import org.eclipse.ptp.debug.core.cdi.PCDIException;

public class DebugCommandQueue
extends Thread {
    private List queue = null;
    private boolean isTerminated = false;
    private IDebugCommand currentCommand = null;
    private IAbstractDebugger debugger = null;
    private int command_timeout = 10000;

    public DebugCommandQueue(IAbstractDebugger debugger, int timeout) {
        this.debugger = debugger;
        this.command_timeout = timeout;
        this.queue = Collections.synchronizedList(new LinkedList());
    }

    public void setTerminated() {
        this.isTerminated = true;
        this.cleanup();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (!this.isTerminated) {
            Object var2_2;
            if (!this.waitForCommand()) {
                return;
            }
            this.currentCommand = this.getCommand();
            try {
                try {
                    System.out.println("***** CURRENT COMMAND: " + this.currentCommand);
                    this.currentCommand.execCommand(this.debugger, this.command_timeout);
                    this.currentCommand.waitForReturn();
                }
                catch (PCDIException e) {
                    this.debugger.handleErrorEvent(this.currentCommand.getTasks(), e.getMessage(), e.getErrorCode());
                }
            }
            catch (Throwable throwable) {
                var2_2 = null;
                this.currentCommand = null;
                throw throwable;
            }
            {
                var2_2 = null;
                this.currentCommand = null;
                continue;
            }
            break;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForCommand() {
        List list = this.queue;
        synchronized (list) {
            try {
                while (this.currentCommand != null || this.queue.isEmpty()) {
                    this.queue.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDebugCommand getCommand() {
        List list = this.queue;
        synchronized (list) {
            return (IDebugCommand)this.queue.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommand(IDebugCommand command) {
        List list = this.queue;
        synchronized (list) {
            if (!this.contains(command)) {
                if (command.canInterrupt() && this.currentCommand != null) {
                    this.setCommandReturn(null, null);
                    try {
                        this.queue.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.queue.add(command);
                this.queue.notifyAll();
            } else {
                System.err.println("************ ERROR in DebugCommandQueue -- duplicate, cmd: " + this.currentCommand);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean contains(IDebugCommand command) {
        List list = this.queue;
        synchronized (list) {
            int size = this.queue.size();
            if (size > 0) {
                return ((IDebugCommand)this.queue.get(size - 1)).compareTo((Object)command) == 0;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCommands() {
        List list = this.queue;
        synchronized (list) {
            IDebugCommand[] commands = this.queue.toArray(new IDebugCommand[0]);
            int i = commands.length - 1;
            while (i > -1) {
                commands[i].flush();
                --i;
            }
            this.queue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCommandReturn(BitList tasks, Object result) {
        List list = this.queue;
        synchronized (list) {
            if (this.currentCommand != null) {
                if (result == null) {
                    this.flushCommands();
                    this.currentCommand.flush();
                } else {
                    this.currentCommand.setReturn(tasks, result);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        List list = this.queue;
        synchronized (list) {
            this.flushCommands();
        }
    }
}

