/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.cdi;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.debug.core.cdi.ICDICondition;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.IDebugCommand;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.cdi.IPCDIAddressLocation;
import org.eclipse.ptp.debug.core.cdi.IPCDIBreakpointManager;
import org.eclipse.ptp.debug.core.cdi.IPCDICondition;
import org.eclipse.ptp.debug.core.cdi.IPCDIFunctionLocation;
import org.eclipse.ptp.debug.core.cdi.IPCDILineLocation;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIAddressBreakpoint;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIBreakpoint;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIExceptionpoint;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIFunctionBreakpoint;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILineBreakpoint;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocation;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIWatchpoint;
import org.eclipse.ptp.debug.core.model.IPAddressBreakpoint;
import org.eclipse.ptp.debug.core.model.IPBreakpoint;
import org.eclipse.ptp.debug.core.model.IPFunctionBreakpoint;
import org.eclipse.ptp.debug.core.model.IPLineBreakpoint;
import org.eclipse.ptp.debug.core.model.IPWatchpoint;
import org.eclipse.ptp.debug.core.sourcelookup.IPSourceLookupDirector;
import org.eclipse.ptp.debug.external.core.PTPDebugExternalPlugin;
import org.eclipse.ptp.debug.external.core.cdi.Condition;
import org.eclipse.ptp.debug.external.core.cdi.Manager;
import org.eclipse.ptp.debug.external.core.cdi.Session;
import org.eclipse.ptp.debug.external.core.cdi.breakpoints.AddressBreakpoint;
import org.eclipse.ptp.debug.external.core.cdi.breakpoints.Breakpoint;
import org.eclipse.ptp.debug.external.core.cdi.breakpoints.FunctionBreakpoint;
import org.eclipse.ptp.debug.external.core.cdi.breakpoints.LineBreakpoint;
import org.eclipse.ptp.debug.external.core.cdi.breakpoints.Watchpoint;
import org.eclipse.ptp.debug.external.core.cdi.model.AddressLocation;
import org.eclipse.ptp.debug.external.core.cdi.model.FunctionLocation;
import org.eclipse.ptp.debug.external.core.cdi.model.LineLocation;
import org.eclipse.ptp.debug.external.core.cdi.model.Target;
import org.eclipse.ptp.debug.external.core.commands.AbstractBreakpointCommand;
import org.eclipse.ptp.debug.external.core.commands.ConditionBreakpointCommand;
import org.eclipse.ptp.debug.external.core.commands.DeleteBreakpointCommand;
import org.eclipse.ptp.debug.external.core.commands.DisableBreakpointCommand;
import org.eclipse.ptp.debug.external.core.commands.EnableBreakpointCommand;
import org.eclipse.ptp.debug.external.core.commands.SetFunctionBreakpointCommand;
import org.eclipse.ptp.debug.external.core.commands.SetLineBreakpointCommand;

public class BreakpointManager
extends Manager
implements IPCDIBreakpointManager,
IBreakpointsListener {
    public static IPCDIBreakpoint[] EMPTY_BREAKPOINTS = new IPCDIBreakpoint[0];
    Map breakMap = new HashMap();
    Map cdiBbreakMap = new HashMap();
    Map cdiBreakIDMap = new HashMap();
    boolean allowInterrupt = true;

    public BreakpointManager(Session session) {
        super(session, false);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointsListener)this);
    }

    public void shutdown() {
        this.breakMap.clear();
        this.cdiBbreakMap.clear();
        this.cdiBreakIDMap.clear();
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this);
    }

    private void addBreakpoint(IPBreakpoint bpt, IPCDIBreakpoint cdiBpt) {
        this.breakMap.put(bpt, cdiBpt);
        this.cdiBbreakMap.put(cdiBpt, bpt);
        this.cdiBreakIDMap.put(new Integer(cdiBpt.getBreakpointId()), cdiBpt);
    }

    private void removeBreakpoint(IPBreakpoint bpt) {
        IPCDIBreakpoint cdiBpt = (IPCDIBreakpoint)this.breakMap.remove(bpt);
        this.cdiBbreakMap.remove(cdiBpt);
        this.cdiBreakIDMap.remove(new Integer(cdiBpt.getBreakpointId()));
    }

    public IPBreakpoint findBreakpoint(IPCDIBreakpoint cdiBpt) {
        return (IPBreakpoint)this.cdiBbreakMap.get(cdiBpt);
    }

    public IPBreakpoint findBreakpoint(int bpid) {
        IPCDIBreakpoint cdiBpt = this.findCDIBreakpoint(bpid);
        if (cdiBpt != null) {
            return this.findBreakpoint(cdiBpt);
        }
        return null;
    }

    public IPCDIBreakpoint findCDIBreakpoint(IPBreakpoint bpt) {
        return (IPCDIBreakpoint)this.breakMap.get(bpt);
    }

    public IPCDIBreakpoint findCDIBreakpoint(int bpid) {
        return (IPCDIBreakpoint)this.cdiBreakIDMap.get(new Integer(bpid));
    }

    public void setConditionBreakpoint(String job_id, IPBreakpoint bpt) throws CoreException {
        this.deleteBreakpoint(job_id, bpt);
        this.setBreakpoint(job_id, bpt);
    }

    public void setEnableBreakpoint(String job_id, IPBreakpoint bpt) throws CoreException {
        BitList tasks = PTPDebugCorePlugin.getDebugModel().getTasks(job_id, bpt.getSetId());
        if (this.breakMap.containsKey(bpt)) {
            IPCDIBreakpoint cdiBpt = this.findCDIBreakpoint(bpt);
            boolean isEnable = bpt.isEnabled();
            AbstractBreakpointCommand command = isEnable ? this.getEnableBreakpointCommand(tasks, cdiBpt) : this.getDisableBreakpointCommand(tasks, cdiBpt);
            ((Session)this.getSession()).getDebugger().postCommand((IDebugCommand)command);
            try {
                command.waitFinish();
                cdiBpt.setEnabled(isEnable);
            }
            catch (PCDIException e) {
                throw new CoreException((IStatus)new Status(4, PTPDebugExternalPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
            }
        }
    }

    public void deleteBreakpoint(String job_id, IPBreakpoint bpt) throws CoreException {
        BitList tasks = PTPDebugCorePlugin.getDebugModel().getTasks(job_id, bpt.getSetId());
        if (this.breakMap.containsKey(bpt)) {
            IPCDIBreakpoint cdiBpt = this.findCDIBreakpoint(bpt);
            AbstractBreakpointCommand command = this.getDeleteBreakpointCommand(tasks, cdiBpt);
            ((Session)this.getSession()).getDebugger().postCommand((IDebugCommand)command);
            try {
                command.waitFinish();
                this.removeBreakpoint(bpt);
            }
            catch (PCDIException e) {
                throw new CoreException((IStatus)new Status(4, PTPDebugExternalPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
            }
        }
    }

    public void setBreakpoint(String job_id, IPBreakpoint bpt) throws CoreException {
        BitList tasks = PTPDebugCorePlugin.getDebugModel().getTasks(job_id, bpt.getSetId());
        IPCDIBreakpoint cdiBpt = null;
        if (bpt instanceof IPLineBreakpoint) {
            cdiBpt = this.setLocationBreakpoint(tasks, (IPLineBreakpoint)bpt);
        } else if (bpt instanceof IPWatchpoint) {
            cdiBpt = this.setWatchPoint(tasks, (IPWatchpoint)bpt);
        } else {
            throw new CoreException((IStatus)new Status(4, PTPDebugExternalPlugin.getUniqueIdentifier(), 4, "This is not ptp breakpoint supported", null));
        }
        if (cdiBpt != null && !this.breakMap.containsKey(bpt)) {
            this.addBreakpoint(bpt, cdiBpt);
        }
    }

    private IPCDIBreakpoint setLocationBreakpoint(BitList tasks, IPLineBreakpoint bpt) throws CoreException {
        IPCDILocation location = this.getLocation((IPBreakpoint)bpt);
        IPCDICondition condition = this.getCondition((IPBreakpoint)bpt);
        try {
            return this.setLocationBreakpointOnSession(bpt, location, condition, bpt.isEnabled(), tasks);
        }
        catch (PCDIException e) {
            throw new CoreException((IStatus)new Status(4, PTPDebugExternalPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
        }
    }

    private IPCDIBreakpoint setWatchPoint(BitList tasks, IPWatchpoint bpt) throws CoreException {
        int accessType = 0;
        accessType |= bpt.isWriteType() ? 1 : 0;
        accessType |= bpt.isReadType() ? 2 : 0;
        String expression = bpt.getExpression();
        IPCDICondition condition = this.getCondition((IPBreakpoint)bpt);
        try {
            return this.setWatchpoint(tasks, 0, accessType, expression, condition);
        }
        catch (PCDIException e) {
            throw new CoreException((IStatus)new Status(4, PTPDebugExternalPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
        }
    }

    public void setInitialBreakpoints() throws CoreException {
        String job_id = ((Session)this.getSession()).getJob().getIDString();
        IPBreakpoint[] bpts = PTPDebugCorePlugin.getDebugModel().findPBreakpointsByJob(job_id, true);
        int i = 0;
        while (i < bpts.length) {
            this.setBreakpoint(job_id, bpts[i]);
            ++i;
        }
    }

    private IPCDICondition getCondition(IPBreakpoint breakpoint) throws CoreException {
        return this.createCondition(breakpoint.getIgnoreCount(), breakpoint.getCondition(), null);
    }

    private IPCDILocation getLocation(IPBreakpoint bpt) throws CoreException {
        IPath path = this.convertPath(bpt.getSourceHandle());
        if (bpt instanceof IPLineBreakpoint) {
            return this.createLineLocation(path.lastSegment(), ((IPLineBreakpoint)bpt).getLineNumber());
        }
        if (bpt instanceof IPFunctionBreakpoint) {
            return this.createFunctionLocation(path.lastSegment(), ((IPFunctionBreakpoint)bpt).getFunction());
        }
        return null;
    }

    private IPCDIBreakpoint setLocationBreakpointOnSession(IPLineBreakpoint bpt, IPCDILocation location, IPCDICondition condition, boolean enabled, BitList tasks) throws PCDIException {
        Object cdiBpt = null;
        cdiBpt = bpt instanceof IPFunctionBreakpoint ? this.createFunctionBreakpoint(tasks, 0, (IPCDIFunctionLocation)location, condition, enabled) : (bpt instanceof IPAddressBreakpoint ? this.createAddressBreakpoint(tasks, 0, (IPCDIAddressLocation)location, condition, enabled) : this.createLineBreakpoint(tasks, 0, (IPCDILineLocation)location, condition, enabled));
        return this.setBreakpointCommand(tasks, (IPCDIBreakpoint)cdiBpt);
    }

    private IPath convertPath(String sourceHandle) {
        IPath path = null;
        if (Path.EMPTY.isValidPath(sourceHandle)) {
            ISourceLocator sl = ((Session)this.getSession()).getLaunch().getSourceLocator();
            if (sl instanceof IPSourceLookupDirector) {
                path = ((IPSourceLookupDirector)sl).getCompilationPath(sourceHandle);
            }
            if (path == null) {
                path = new Path(sourceHandle);
            }
        }
        return path;
    }

    public void setInternalTemporaryBreakpoint(BitList tasks, IPCDILocation location) throws DebugException {
        IPCDIFunctionBreakpoint cdiBpt = null;
        try {
            if (location instanceof IPCDIFunctionLocation) {
                cdiBpt = this.createFunctionBreakpoint(tasks, 1, (IPCDIFunctionLocation)location, null, false);
            } else if (location instanceof IPCDILineLocation) {
                cdiBpt = this.createLineBreakpoint(tasks, 1, (IPCDILineLocation)location, null, false);
            } else if (location instanceof IPCDIAddressLocation) {
                cdiBpt = this.createAddressBreakpoint(tasks, 1, (IPCDIAddressLocation)location, null, false);
            }
            cdiBpt = this.setBreakpointCommand(tasks, (IPCDIBreakpoint)cdiBpt);
        }
        catch (PCDIException e) {
            throw new DebugException((IStatus)new Status(4, PTPDebugExternalPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
        }
        this.cdiBreakIDMap.put(new Integer(cdiBpt.getBreakpointId()), cdiBpt);
    }

    public IPCDILineBreakpoint setLineBreakpoint(BitList tasks, int type, IPCDILineLocation location, IPCDICondition condition, boolean deferred) throws PCDIException {
        IPCDILineBreakpoint cdiLineBpt = this.createLineBreakpoint(tasks, type, location, condition, deferred);
        IPCDIBreakpoint cdiBpt = this.setBreakpointCommand(tasks, (IPCDIBreakpoint)cdiLineBpt);
        this.cdiBreakIDMap.put(new Integer(cdiBpt.getBreakpointId()), cdiBpt);
        return cdiLineBpt;
    }

    public IPCDIFunctionBreakpoint setFunctionBreakpoint(BitList tasks, int type, IPCDIFunctionLocation location, IPCDICondition condition, boolean deferred) throws PCDIException {
        IPCDIFunctionBreakpoint cdiFuncBpt = this.createFunctionBreakpoint(tasks, type, location, condition, deferred);
        IPCDIBreakpoint cdiBpt = this.setBreakpointCommand(tasks, (IPCDIBreakpoint)cdiFuncBpt);
        this.cdiBreakIDMap.put(new Integer(cdiBpt.getBreakpointId()), cdiBpt);
        return cdiFuncBpt;
    }

    public IPCDIAddressBreakpoint setAddressBreakpoint(BitList tasks, int type, IPCDIAddressLocation location, IPCDICondition condition, boolean deferred) throws PCDIException {
        IPCDIAddressBreakpoint cdiAddrBpt = this.createAddressBreakpoint(tasks, type, location, condition, deferred);
        IPCDIBreakpoint cdiBpt = this.setBreakpointCommand(tasks, (IPCDIBreakpoint)cdiAddrBpt);
        this.cdiBreakIDMap.put(new Integer(cdiBpt.getBreakpointId()), cdiBpt);
        return cdiAddrBpt;
    }

    public IPCDIWatchpoint setWatchpoint(BitList tasks, int type, int watchType, String expression, IPCDICondition condition) throws PCDIException {
        try {
            Integer.decode(expression);
            expression = String.valueOf('*') + expression;
        }
        catch (NumberFormatException numberFormatException) {}
        Watchpoint bkpt = new Watchpoint(expression, type, watchType, condition);
        this.setWatchpoint(tasks, bkpt);
        throw new PCDIException("Not implement - setWatchpoint");
    }

    public void setWatchpoint(BitList tasks, Watchpoint watchpoint) throws PCDIException {
        throw new PCDIException("Not implement yet - setWatchpoint");
    }

    public IPCDIExceptionpoint setExceptionpoint(BitList tasks, String clazz, boolean stopOnThrow, boolean stopOnCatch) throws PCDIException {
        if (!stopOnThrow && !stopOnCatch) {
            throw new PCDIException("Must suspend on throw or catch");
        }
        throw new PCDIException("Not implement yet - setExceptionpoint");
    }

    public void setBreakpointPending(BitList tasks, boolean set) throws PCDIException {
        throw new PCDIException("Not implement yet - setBreakpointPending");
    }

    public IPCDICondition createCondition(int ignoreCount, String expression, String[] tids) {
        return new Condition(ignoreCount, expression, tids);
    }

    public IPCDILineLocation createLineLocation(String file, int line) {
        return new LineLocation(file, line);
    }

    public IPCDIFunctionLocation createFunctionLocation(String file, String function) {
        return new FunctionLocation(file, function);
    }

    public IPCDIAddressLocation createAddressLocation(BigInteger address) {
        return new AddressLocation(address);
    }

    public void update(Target target) throws PCDIException {
        if (target == null) {
            throw new PCDIException("No target");
        }
        throw new PCDIException("Not implement yet -- BreakpointManager: update");
    }

    public void setCondition(Breakpoint breakpoint, IPCDICondition newCondition) throws PCDIException {
        throw new PCDIException("Not implement yet -- BreakpointManager: setCondition");
    }

    private IPCDILineBreakpoint createLineBreakpoint(BitList tasks, int type, IPCDILineLocation location, IPCDICondition condition, boolean deferred) throws PCDIException {
        return new LineBreakpoint(type, location, condition);
    }

    private IPCDIFunctionBreakpoint createFunctionBreakpoint(BitList tasks, int type, IPCDIFunctionLocation location, IPCDICondition condition, boolean deferred) throws PCDIException {
        return new FunctionBreakpoint(type, (IPCDILocation)location, condition);
    }

    private IPCDIAddressBreakpoint createAddressBreakpoint(BitList tasks, int type, IPCDIAddressLocation location, IPCDICondition condition, boolean deferred) throws PCDIException {
        return new AddressBreakpoint(type, (IPCDILocation)location, condition);
    }

    private IPCDIBreakpoint setBreakpointCommand(BitList tasks, IPCDIBreakpoint bkpt) throws PCDIException {
        Session session = (Session)this.getSession();
        AbstractBreakpointCommand command = this.getSetBreakpointCommand(tasks, bkpt);
        if (command != null) {
            session.getDebugger().postCommand((IDebugCommand)command);
            IPCDIBreakpoint cdiBpt = command.getBreakpoint();
            if (cdiBpt != null) {
                return cdiBpt;
            }
        }
        throw new PCDIException("No breakpoint created");
    }

    private AbstractBreakpointCommand getSetBreakpointCommand(BitList tasks, IPCDIBreakpoint bkpt) {
        if (bkpt instanceof IPCDILineBreakpoint) {
            return new SetLineBreakpointCommand(tasks, (IPCDILineBreakpoint)bkpt);
        }
        if (bkpt instanceof IPCDIFunctionBreakpoint) {
            return new SetFunctionBreakpointCommand(tasks, (IPCDIFunctionBreakpoint)bkpt);
        }
        boolean cfr_ignored_0 = bkpt instanceof IPCDIAddressBreakpoint;
        return null;
    }

    private AbstractBreakpointCommand getDeleteBreakpointCommand(BitList tasks, IPCDIBreakpoint bkpt) {
        return new DeleteBreakpointCommand(tasks, bkpt);
    }

    private AbstractBreakpointCommand getEnableBreakpointCommand(BitList tasks, IPCDIBreakpoint bkpt) {
        return new EnableBreakpointCommand(tasks, bkpt);
    }

    private AbstractBreakpointCommand getDisableBreakpointCommand(BitList tasks, IPCDIBreakpoint bkpt) {
        return new DisableBreakpointCommand(tasks, bkpt);
    }

    private AbstractBreakpointCommand getConditionBreakpointCommand(BitList tasks, IPCDIBreakpoint bkpt, String expr) {
        return new ConditionBreakpointCommand(tasks, bkpt, expr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointsAdded(IBreakpoint[] breakpoints) {
        Map map = this.breakMap;
        synchronized (map) {
            int i = 0;
            while (i < breakpoints.length) {
                if (breakpoints[i] instanceof IPBreakpoint) {
                    String job_id = this.getSession().getJob().getIDString();
                    try {
                        String bp_job_id = ((IPBreakpoint)breakpoints[i]).getJobId();
                        if (bp_job_id.equals(job_id) || bp_job_id.equals("Global")) {
                            this.setBreakpoint(job_id, (IPBreakpoint)breakpoints[i]);
                        }
                    }
                    catch (CoreException e) {
                        PTPDebugExternalPlugin.log(e.getStatus());
                    }
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        Map map = this.breakMap;
        synchronized (map) {
            int i = 0;
            while (i < breakpoints.length) {
                if (breakpoints[i] instanceof IPBreakpoint) {
                    IPBreakpoint breakpoint = (IPBreakpoint)breakpoints[i];
                    String job_id = this.getSession().getJob().getIDString();
                    try {
                        IPCDIBreakpoint cdiBpt;
                        String bp_job_id = ((IPBreakpoint)breakpoints[i]).getJobId();
                        if ((bp_job_id.equals(job_id) || bp_job_id.equals("Global")) && (cdiBpt = this.findCDIBreakpoint(breakpoint)) != null) {
                            IPCDICondition cdiCondition;
                            boolean oldEnabled;
                            IPCDICondition condition0 = null;
                            int ignoreCount = breakpoint.getIgnoreCount();
                            int oldIgnoreCount = deltas != null ? deltas[i].getAttribute("org.eclipse.ptp.debug.core.ignoreCount", 0) : ignoreCount;
                            String condition = breakpoint.getCondition();
                            String oldCondition = deltas != null ? deltas[i].getAttribute("org.eclipse.ptp.debug.core.condition", "") : condition;
                            Boolean enabled0 = null;
                            boolean enabled = breakpoint.isEnabled();
                            boolean bl = oldEnabled = deltas[i] != null ? deltas[i].getAttribute("org.eclipse.debug.core.enabled", true) : enabled;
                            if (enabled != oldEnabled && enabled != cdiBpt.isEnabled()) {
                                Boolean bl2 = enabled0 = enabled ? Boolean.TRUE : Boolean.FALSE;
                            }
                            if (!(ignoreCount == oldIgnoreCount && condition.compareTo(oldCondition) == 0 || (cdiCondition = this.createCondition(ignoreCount, condition, null)).equals((ICDICondition)cdiBpt.getCondition()))) {
                                condition0 = cdiCondition;
                            }
                            if (enabled0 != null) {
                                this.setEnableBreakpoint(job_id, breakpoint);
                            }
                            if (condition0 != null) {
                                this.setConditionBreakpoint(job_id, breakpoint);
                            }
                        }
                    }
                    catch (CoreException e) {
                        PTPDebugExternalPlugin.log(e.getStatus());
                    }
                    catch (PCDIException e1) {
                        PTPDebugExternalPlugin.log(e1);
                    }
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        Map map = this.breakMap;
        synchronized (map) {
            int i = 0;
            while (i < breakpoints.length) {
                if (breakpoints[i] instanceof IPBreakpoint) {
                    String job_id = this.getSession().getJob().getIDString();
                    try {
                        String bp_job_id = ((IPBreakpoint)breakpoints[i]).getJobId();
                        if (bp_job_id.equals(job_id) || bp_job_id.equals("Global")) {
                            this.deleteBreakpoint(job_id, (IPBreakpoint)breakpoints[i]);
                        }
                    }
                    catch (CoreException e) {
                        PTPDebugExternalPlugin.log(e.getStatus());
                    }
                }
                ++i;
            }
        }
    }
}

