/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.ptp.debug.core.cdi.IPCDIEventManager;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIChangedEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDICreatedEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIDisconnectedEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIEventListener;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIExitedEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIResumedEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDISuspendedEvent;
import org.eclipse.ptp.debug.external.core.PTPDebugExternalPlugin;
import org.eclipse.ptp.debug.external.core.cdi.Session;
import org.eclipse.ptp.debug.external.core.cdi.SessionObject;
import org.eclipse.ptp.debug.external.core.cdi.model.Target;
import org.eclipse.ptp.debug.external.core.cdi.model.Thread;

public class EventManager
extends SessionObject
implements IPCDIEventManager,
Observer {
    List list = Collections.synchronizedList(new ArrayList(1));

    public void update(Observable o, Object arg) {
        IPCDIEvent event = (IPCDIEvent)arg;
        ArrayList<IPCDIEvent> cdiList = new ArrayList<IPCDIEvent>(1);
        cdiList.add(event);
        if (event instanceof IPCDISuspendedEvent) {
            this.processSuspendedEvent((IPCDISuspendedEvent)event);
        } else if (!(event instanceof IPCDIResumedEvent || event instanceof IPCDIExitedEvent || event instanceof IPCDIDisconnectedEvent || event instanceof IPCDICreatedEvent)) {
            boolean cfr_ignored_0 = event instanceof IPCDIChangedEvent;
        }
        IPCDIEvent[] cdiEvents = cdiList.toArray(new IPCDIEvent[0]);
        this.fireEvents(cdiEvents);
    }

    public EventManager(Session session) {
        super(session);
    }

    public void shutdown() {
        this.list.clear();
    }

    public void addEventListener(IPCDIEventListener listener) {
        if (!this.list.contains(listener)) {
            this.list.add(listener);
        }
    }

    public void removeEventListener(IPCDIEventListener listener) {
        if (this.list.contains(listener)) {
            this.list.remove(listener);
        }
    }

    public void removeEventListeners() {
        this.list.clear();
    }

    public synchronized void fireEvents(IPCDIEvent[] cdiEvents) {
        if (cdiEvents != null && cdiEvents.length > 0) {
            IPCDIEventListener[] listeners = this.list.toArray(new IPCDIEventListener[0]);
            int i = 0;
            while (i < listeners.length) {
                listeners[i].handleDebugEvents(cdiEvents);
                ++i;
            }
        }
    }

    boolean processSuspendedEvent(IPCDISuspendedEvent event) {
        Session session = (Session)this.getSession();
        int[] procs = event.getAllRegisteredProcesses().toArray();
        int i = 0;
        while (i < procs.length) {
            Target currentTarget = (Target)session.getTarget(procs[i]);
            currentTarget.setSupended(true);
            currentTarget.updateState(0);
            try {
                Thread cthread = (Thread)currentTarget.getCurrentThread();
                if (cthread != null) {
                    cthread.getCurrentStackFrame();
                }
            }
            catch (PCDIException e1) {
                PTPDebugExternalPlugin.log(e1);
            }
            ++i;
        }
        return true;
    }
}

