/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIExpression;
import org.eclipse.ptp.debug.external.core.cdi.Manager;
import org.eclipse.ptp.debug.external.core.cdi.Session;
import org.eclipse.ptp.debug.external.core.cdi.model.Expression;
import org.eclipse.ptp.debug.external.core.cdi.model.StackFrame;
import org.eclipse.ptp.debug.external.core.cdi.model.Target;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.Variable;

public class ExpressionManager
extends Manager {
    static final IPCDIExpression[] EMPTY_EXPRESSIONS = new IPCDIExpression[0];
    Map expMap = new Hashtable();
    Map varMap = new Hashtable();

    public void update(Target target) throws PCDIException {
    }

    public ExpressionManager(Session session) {
        super(session, true);
    }

    public void shutdown() {
        this.expMap.clear();
        this.varMap.clear();
    }

    synchronized List getExpressionList(Target target) {
        List expList = (List)this.expMap.get(target);
        if (expList == null) {
            expList = Collections.synchronizedList(new ArrayList());
            this.expMap.put(target, expList);
        }
        return expList;
    }

    synchronized List getVariableList(Target target) {
        List varList = (List)this.varMap.get(target);
        if (varList == null) {
            varList = Collections.synchronizedList(new ArrayList());
            this.varMap.put(target, varList);
        }
        return varList;
    }

    public IPCDIExpression createExpression(Target target, String name) throws PCDIException {
        Expression expression = new Expression(target, name);
        List exprList = this.getExpressionList(target);
        exprList.add(expression);
        return expression;
    }

    public IPCDIExpression[] getExpressions(Target target) throws PCDIException {
        List expList = (List)this.expMap.get(target);
        if (expList != null) {
            return expList.toArray(EMPTY_EXPRESSIONS);
        }
        return EMPTY_EXPRESSIONS;
    }

    public void destroyExpressions(Target target, IPCDIExpression[] expressions) throws PCDIException {
        List expList = this.getExpressionList(target);
        int i = 0;
        while (i < expressions.length) {
            expList.remove(expressions[i]);
            ++i;
        }
    }

    public void destroyAllExpressions(Target target) throws PCDIException {
        IPCDIExpression[] expressions = this.getExpressions(target);
        this.destroyExpressions(target, expressions);
    }

    public Variable getVariable(Target target, String varName) {
        if (target == null) {
            return null;
        }
        List varList = this.getVariableList(target);
        Variable[] vars = varList.toArray(new Variable[0]);
        int i = 0;
        while (i < vars.length) {
            if (vars[i].getName().equals(varName)) {
                return vars[i];
            }
            Variable v = vars[i].getChild(varName);
            if (v != null) {
                return v;
            }
            ++i;
        }
        return null;
    }

    public Variable createVariable(StackFrame frame, String code) throws PCDIException {
        throw new PCDIException("Not implement yet - ExpressManager: createVaraible");
    }

    public Variable removeVariableFromList(Target target, String varName) {
        Variable var = this.getVariable(target, varName);
        if (var != null) {
            List varList = this.getVariableList(target);
            varList.remove(var);
            return var;
        }
        return null;
    }

    public void deleteAllVariables(Target target) throws PCDIException {
        List varList = this.getVariableList(target);
        Variable[] variables = varList.toArray(new Variable[varList.size()]);
        int i = 0;
        while (i < variables.length) {
            this.deleteVariable(variables[i]);
            ++i;
        }
    }

    public void deleteVariable(Variable variable) throws PCDIException {
        throw new PCDIException("Not implement yet - ExpressionManager: deleteVariable");
    }
}

