/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.cdi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.model.IPCDITarget;
import org.eclipse.ptp.debug.external.core.cdi.Manager;
import org.eclipse.ptp.debug.external.core.cdi.Session;
import org.eclipse.ptp.debug.external.core.cdi.model.Target;

public class ProcessManager
extends Manager {
    static final Target[] EMPTY_TARGETS = new Target[0];
    Map debugTargetMap = Collections.synchronizedMap(new HashMap());

    public ProcessManager(Session session) {
        super(session, true);
    }

    public void shutdown() {
        this.debugTargetMap.clear();
    }

    public Target[] getTargets() {
        return this.debugTargetMap.values().toArray(new Target[0]);
    }

    public IPCDITarget[] getCDITargets() {
        return this.debugTargetMap.values().toArray(new IPCDITarget[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitList getRegisteredTargets() {
        BitList regTasks = ((Session)this.getSession()).createEmptyBitList();
        Map map = this.debugTargetMap;
        synchronized (map) {
            Iterator i = this.debugTargetMap.keySet().iterator();
            while (i.hasNext()) {
                regTasks.set(((Integer)i.next()).intValue());
            }
        }
        return regTasks;
    }

    public int[] getRegisteredTargetIDs() {
        return this.getRegisteredTargets().toArray();
    }

    public void addTargets(IPCDITarget[] targets, BitList regTasks) {
        int i = 0;
        while (i < targets.length) {
            IPCDITarget target = targets[i];
            Integer key = new Integer(target.getTargetID());
            if (!this.debugTargetMap.containsKey(key)) {
                this.debugTargetMap.put(key, target);
                regTasks.set(target.getTargetID());
            }
            ++i;
        }
    }

    public boolean removeTarget(int target_id) {
        Integer key = new Integer(target_id);
        if (!this.debugTargetMap.containsKey(key)) {
            return false;
        }
        this.debugTargetMap.remove(key);
        return true;
    }

    public void removeTargets(int[] target_ids, BitList regTasks) {
        int i = 0;
        while (i < target_ids.length) {
            if (this.removeTarget(target_ids[i])) {
                regTasks.set(target_ids[i]);
            }
            ++i;
        }
    }

    public void removeTargets(IPCDITarget[] targets, BitList regTasks) {
        int i = 0;
        while (i < targets.length) {
            if (this.removeTarget(targets[i].getTargetID())) {
                regTasks.set(targets[i].getTargetID());
            }
            ++i;
        }
    }

    public boolean containTarget(int target_id) {
        return this.debugTargetMap.containsKey(new Integer(target_id));
    }

    public Target getTarget(int target_id) {
        return (Target)this.debugTargetMap.get(new Integer(target_id));
    }

    public void update(Target target) throws PCDIException {
    }
}

