/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.cdi;

import java.util.ArrayList;
import java.util.Observer;
import java.util.Properties;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.IAbstractDebugger;
import org.eclipse.ptp.debug.core.IDebugCommand;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.aif.IAIF;
import org.eclipse.ptp.debug.core.cdi.IPCDIBreakpointManager;
import org.eclipse.ptp.debug.core.cdi.IPCDIEventManager;
import org.eclipse.ptp.debug.core.cdi.IPCDISession;
import org.eclipse.ptp.debug.core.cdi.IPCDISessionConfiguration;
import org.eclipse.ptp.debug.core.cdi.IPCDISessionObject;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocation;
import org.eclipse.ptp.debug.core.cdi.model.IPCDITarget;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.debug.external.core.PTPDebugExternalPlugin;
import org.eclipse.ptp.debug.external.core.cdi.BreakpointManager;
import org.eclipse.ptp.debug.external.core.cdi.EventManager;
import org.eclipse.ptp.debug.external.core.cdi.ExpressionManager;
import org.eclipse.ptp.debug.external.core.cdi.ProcessManager;
import org.eclipse.ptp.debug.external.core.cdi.SessionConfiguration;
import org.eclipse.ptp.debug.external.core.cdi.SourceManager;
import org.eclipse.ptp.debug.external.core.cdi.VariableManager;
import org.eclipse.ptp.debug.external.core.cdi.model.Target;
import org.eclipse.ptp.debug.external.core.commands.GetAIFCommand;
import org.eclipse.ptp.debug.external.core.commands.GoCommand;
import org.eclipse.ptp.debug.external.core.commands.HaltCommand;
import org.eclipse.ptp.debug.external.core.commands.KillCommand;
import org.eclipse.ptp.debug.external.core.commands.StepFinishCommand;
import org.eclipse.ptp.debug.external.core.commands.StepIntoCommand;
import org.eclipse.ptp.debug.external.core.commands.StepOverCommand;

public class Session
implements IPCDISession,
IPCDISessionObject {
    public static final Target[] EMPTY_TARGETS = new Target[0];
    Properties props;
    ProcessManager processManager;
    EventManager eventManager;
    BreakpointManager breakpointManager;
    ExpressionManager expressionManager;
    VariableManager variableManager;
    SourceManager sourceManager;
    IPCDISessionConfiguration configuration;
    IAbstractDebugger debugger = null;
    IPJob job = null;
    IPLaunch launch = null;
    IBinaryParser.IBinaryObject file;

    public Session(IAbstractDebugger debugger, IPJob job, IPLaunch launch, IBinaryParser.IBinaryObject file) throws CoreException {
        this.debugger = debugger;
        this.job = job;
        this.launch = launch;
        this.file = file;
        this.commonSetup();
    }

    private void commonSetup() {
        this.props = new Properties();
        this.setConfiguration(new SessionConfiguration(this));
        this.processManager = new ProcessManager(this);
        this.breakpointManager = new BreakpointManager(this);
        this.eventManager = new EventManager(this);
        this.expressionManager = new ExpressionManager(this);
        this.variableManager = new VariableManager(this);
        this.sourceManager = new SourceManager(this);
        this.debugger.addDebuggerObserver((Observer)this.eventManager);
    }

    public void shutdown() {
        try {
            this.debugger.exit();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        DebugPlugin.getDefault().getLaunchManager().removeLaunch((ILaunch)this.launch);
        this.variableManager.shutdown();
        this.expressionManager.shutdown();
        this.breakpointManager.shutdown();
        this.eventManager.shutdown();
        this.sourceManager.shutdown();
        this.processManager.shutdown();
    }

    public IPLaunch getLaunch() {
        return this.launch;
    }

    public IAbstractDebugger getDebugger() {
        return this.debugger;
    }

    public IPJob getJob() {
        return this.job;
    }

    public IBinaryParser.IBinaryObject getBinaryFile() {
        return this.file;
    }

    public void start(IProgressMonitor monitor) throws CoreException {
        IWorkspaceRunnable r = new IWorkspaceRunnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor m) throws CoreException {
                m.beginTask("", 3);
                m.setTaskName("Creating debugging session...");
                PTPDebugCorePlugin.getDebugModel().newJob(Session.this.getJob().getIDString(), Session.this.getTotalProcesses());
                Session.this.launch.launchedStarted();
                m.worked(1);
                boolean stopInMain = Session.this.getLaunch().getLaunchConfiguration().getAttribute("org.eclipse.ptp.launch.STOP_IN_MAIN", false);
                m.subTask("Initialing breakpoints...");
                Session.this.breakpointManager.setInitialBreakpoints();
                if (stopInMain) {
                    Session.this.breakpointManager.setInternalTemporaryBreakpoint(Session.this.createBitList(), (IPCDILocation)Session.this.breakpointManager.createFunctionLocation("", "main"));
                }
                m.worked(1);
                if (m.isCanceled()) {
                    throw new CoreException(Status.CANCEL_STATUS);
                }
                try {
                    try {
                        Session.this.resume(Session.this.createBitList());
                        m.worked(1);
                    }
                    catch (PCDIException e) {
                        throw new CoreException((IStatus)new Status(4, PTPDebugExternalPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
                    }
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    m.done();
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                }
                m.done();
            }
        };
        ResourcesPlugin.getWorkspace().run(r, monitor);
    }

    public void registerTarget(int procNum, boolean sendEvent) {
        this.registerTarget(procNum, sendEvent, false);
    }

    public void registerTargets(int[] procNums, boolean sendEvent) {
        this.registerTargets(procNums, sendEvent, false);
    }

    public void registerTarget(int procNum, boolean sendEvent, boolean resumeTarget) {
        this.registerTargets(new int[]{procNum}, sendEvent, resumeTarget);
    }

    public void registerTargets(int[] procNums, boolean sendEvent, boolean resumeTarget) {
        ArrayList<Target> targetList = new ArrayList<Target>();
        int i = 0;
        while (i < procNums.length) {
            if (!this.processManager.containTarget(procNums[i])) {
                targetList.add(new Target(this, procNums[i]));
            }
            ++i;
        }
        IPCDITarget[] targets = targetList.toArray(new IPCDITarget[0]);
        if (targets.length > 0) {
            BitList regTasks = this.createEmptyBitList();
            this.processManager.addTargets(targets, regTasks);
            PTPDebugCorePlugin.getDebugModel().addNewDebugTargets(this.launch, regTasks, targets, this.file, resumeTarget, sendEvent);
        }
    }

    public void unregisterTarget(int procNum, boolean sendEvent) {
        this.unregisterTargets(new int[]{procNum}, sendEvent);
    }

    public void unregisterTargets(int[] procNums, boolean sendEvent) {
        BitList unregTasks = this.createEmptyBitList();
        int i = 0;
        while (i < procNums.length) {
            if (this.processManager.removeTarget(procNums[i])) {
                unregTasks.set(procNums[i]);
            }
            ++i;
        }
        PTPDebugCorePlugin.getDebugModel().removeDebugTarget(this.launch, unregTasks, sendEvent);
    }

    public String getAttribute(String key) {
        return this.props.getProperty(key);
    }

    public ProcessManager getProcessManager() {
        return this.processManager;
    }

    public IPCDIBreakpointManager getBreakpointManager() {
        return this.breakpointManager;
    }

    public IPCDIEventManager getEventManager() {
        return this.eventManager;
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public VariableManager getVariableManager() {
        return this.variableManager;
    }

    public SourceManager getSourceManager() {
        return this.sourceManager;
    }

    public IPCDITarget[] getTargets() {
        return this.getProcessManager().getCDITargets();
    }

    public BitList getRegisteredTargets() {
        return this.getProcessManager().getRegisteredTargets();
    }

    public IPCDITarget getTarget(int target_id) {
        return this.getProcessManager().getTarget(target_id);
    }

    public void setAttribute(String key, String value) {
        this.props.setProperty(key, value);
    }

    public IPCDISessionConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(IPCDISessionConfiguration conf) {
        this.configuration = conf;
    }

    public IPCDISession getSession() {
        return this;
    }

    public Process getSessionProcess() throws PCDIException {
        return null;
    }

    public BitList createEmptyBitList() {
        return new BitList(this.getTotalProcesses());
    }

    public BitList createBitList() {
        BitList tasks = this.createEmptyBitList();
        tasks.set(0, this.getTotalProcesses());
        return tasks;
    }

    public BitList createBitList(int index) {
        BitList tasks = this.createEmptyBitList();
        tasks.set(index);
        return tasks;
    }

    public int getTotalProcesses() {
        return this.job.totalProcesses();
    }

    public void terminate() throws PCDIException {
        this.stop(this.createBitList());
    }

    public void stop(BitList tasks) throws PCDIException {
        this.getDebugger().postCommand((IDebugCommand)new KillCommand(tasks));
    }

    public void resume(BitList tasks) throws PCDIException {
        this.getDebugger().postCommand((IDebugCommand)new GoCommand(tasks));
    }

    public void suspend(BitList tasks) throws PCDIException {
        this.getDebugger().postCommand((IDebugCommand)new HaltCommand(tasks));
    }

    public void steppingInto(BitList tasks) throws PCDIException {
        this.getDebugger().postCommand((IDebugCommand)new StepIntoCommand(tasks));
    }

    public void steppingOver(BitList tasks) throws PCDIException {
        this.getDebugger().postCommand((IDebugCommand)new StepOverCommand(tasks));
    }

    public void steppingReturn(BitList tasks) throws PCDIException {
        this.getDebugger().postCommand((IDebugCommand)new StepFinishCommand(tasks));
    }

    public IAIF getExpressionValue(BitList tasks, String variable) throws PCDIException {
        GetAIFCommand command = new GetAIFCommand(tasks, variable);
        this.getDebugger().postCommand((IDebugCommand)command);
        return command.getAIF();
    }

    public IAIF getExpressionValue(int task_id, String variable) throws PCDIException {
        return this.getExpressionValue(this.createBitList(task_id), variable);
    }
}

