/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.IDebugCommand;
import org.eclipse.ptp.debug.core.aif.AIF;
import org.eclipse.ptp.debug.core.aif.AIFException;
import org.eclipse.ptp.debug.core.aif.AIFFactory;
import org.eclipse.ptp.debug.core.aif.IAIF;
import org.eclipse.ptp.debug.core.aif.IAIFValue;
import org.eclipse.ptp.debug.core.aif.IAIFValueArray;
import org.eclipse.ptp.debug.core.aif.IAIFValuePointer;
import org.eclipse.ptp.debug.core.aif.IAIFValueReference;
import org.eclipse.ptp.debug.core.aif.ITypeAggregate;
import org.eclipse.ptp.debug.core.aif.IValueAggregate;
import org.eclipse.ptp.debug.core.aif.IValueParent;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIEvent;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIArgument;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIArgumentDescriptor;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIGlobalVariable;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocalVariable;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocalVariableDescriptor;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIStackFrame;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIThread;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIThreadStorageDescriptor;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIVariable;
import org.eclipse.ptp.debug.external.core.cdi.EventManager;
import org.eclipse.ptp.debug.external.core.cdi.Manager;
import org.eclipse.ptp.debug.external.core.cdi.Session;
import org.eclipse.ptp.debug.external.core.cdi.model.StackFrame;
import org.eclipse.ptp.debug.external.core.cdi.model.Target;
import org.eclipse.ptp.debug.external.core.cdi.model.Thread;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.Argument;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.ArgumentDescriptor;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.GlobalVariable;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.GlobalVariableDescriptor;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.LocalVariable;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.LocalVariableDescriptor;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.ThreadStorage;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.ThreadStorageDescriptor;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.Variable;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.VariableDescriptor;
import org.eclipse.ptp.debug.external.core.commands.GetAIFCommand;
import org.eclipse.ptp.debug.external.core.commands.ListArgumentsCommand;
import org.eclipse.ptp.debug.external.core.commands.ListGlobalVariablesCommand;
import org.eclipse.ptp.debug.external.core.commands.ListLocalVariablesCommand;

public class VariableManager
extends Manager {
    static final IPCDIVariable[] EMPTY_VARIABLES = new IPCDIVariable[0];
    int MAX_STACK_DEPTH = 200;
    private Map variablesMap = new Hashtable();

    public VariableManager(Session session) {
        super(session, true);
    }

    public void shutdown() {
        this.variablesMap.clear();
    }

    synchronized List getVariablesList(Target target) {
        List variablesList = (List)this.variablesMap.get(target);
        if (variablesList == null) {
            variablesList = Collections.synchronizedList(new ArrayList());
            this.variablesMap.put(target, variablesList);
        }
        return variablesList;
    }

    public Variable getVariable(int task_id, String varName) {
        Target target = (Target)((Session)this.getSession()).getTarget(task_id);
        return this.getVariable(target, varName);
    }

    public Variable getVariable(Target target, String varName) {
        Variable[] vars = this.getVariables(target);
        int i = 0;
        while (i < vars.length) {
            if (vars[i].getName().equals(varName)) {
                return vars[i];
            }
            Variable v = vars[i].getChild(varName);
            if (v != null) {
                return v;
            }
            ++i;
        }
        return null;
    }

    Variable findVariable(VariableDescriptor v) throws PCDIException {
        Target target = (Target)v.getTarget();
        IPCDIStackFrame vstack = v.getStackFrame();
        IPCDIThread vthread = v.getThread();
        String name = v.getName();
        int position = v.getPosition();
        int depth = v.getStackDepth();
        Variable[] vars = this.getVariables(target);
        int i = 0;
        while (i < vars.length) {
            if (vars[i].getName().equals(name) && vars[i].getCastingArrayStart() == v.getCastingArrayStart() && vars[i].getCastingArrayEnd() == v.getCastingArrayEnd() && VariableDescriptor.equalsCasting(vars[i], v)) {
                IPCDIThread thread = vars[i].getThread();
                if (vthread == null && thread == null || vthread != null && thread != null && thread.equals(vthread)) {
                    IPCDIStackFrame frame = vars[i].getStackFrame();
                    if (vstack == null && frame == null) {
                        vars[i].setAIF(v.getAIF());
                        return vars[i];
                    }
                    if (frame != null && vstack != null && frame.equals(vstack) && vars[i].getPosition() == position && vars[i].getStackDepth() == depth) {
                        vars[i].setAIF(v.getAIF());
                        return vars[i];
                    }
                }
            }
            ++i;
        }
        return null;
    }

    Variable[] getVariables(Target target) {
        List variableList = (List)this.variablesMap.get(target);
        if (variableList != null) {
            return variableList.toArray(new Variable[variableList.size()]);
        }
        return new Variable[0];
    }

    public void checkType(StackFrame frame, String type) throws PCDIException {
        if (type != null && type.length() > 0) {
            Target target = (Target)frame.getTarget();
            Thread currentThread = (Thread)target.getCurrentThread();
            StackFrame currentFrame = currentThread.getCurrentStackFrame();
            target.setCurrentThread(frame.getThread(), false);
            ((Thread)frame.getThread()).setCurrentStackFrame(frame, false);
            try {
                throw new PCDIException("Not implemented yet - VariableManager: checkType");
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                target.setCurrentThread(currentThread, false);
                currentThread.setCurrentStackFrame(currentFrame, false);
                throw throwable;
            }
        }
        throw new PCDIException("VariableManager Unknown_type");
    }

    void removeVar(Target target, Variable var) throws PCDIException {
        throw new PCDIException("Not implement yet - VariableManager: removeVar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Variable removeVariableFromList(Target target, String varName) {
        List varList;
        List list = varList = this.getVariablesList(target);
        synchronized (list) {
            Iterator iterator = varList.iterator();
            while (iterator.hasNext()) {
                Variable variable = (Variable)iterator.next();
                if (!variable.getName().equals(varName)) continue;
                iterator.remove();
                return variable;
            }
        }
        return null;
    }

    private IPCDIVariable[] getVariables(IValueAggregate aggrValue, VariableDescriptor varDesc) throws PCDIException {
        ITypeAggregate aggrType = (ITypeAggregate)aggrValue.getType();
        try {
            int length = aggrValue.getChildrenNumber();
            IPCDIVariable[] vars = new IPCDIVariable[length];
            int i = 0;
            while (i < length) {
                IValueParent parentValue;
                AIF newAIF = null;
                IAIFValue aifValue = aggrValue.getValue(i);
                newAIF = aifValue instanceof IAIFValueReference ? ((parentValue = ((IAIFValueReference)aifValue).getParent()) == null ? new AIF(AIFFactory.UNKNOWNTYPE, AIFFactory.UNKNOWNVALUE) : new AIF(parentValue.getType(), (IAIFValue)parentValue)) : new AIF(aifValue.getType(), aggrValue.getValue(i));
                vars[i] = this.createVariable(this.createVariableDescriptor(varDesc, (IAIF)newAIF, aggrType.getField(i), false));
                ++i;
            }
            return vars;
        }
        catch (AIFException e) {
            throw new PCDIException((Throwable)e);
        }
    }

    public IPCDIVariable[] getVariables(VariableDescriptor varDesc) throws PCDIException {
        IAIFValuePointer valuePointer;
        IAIFValue aifValue;
        IAIFValue parentValue = varDesc.getAIF().getValue();
        if (parentValue instanceof IValueAggregate) {
            return this.getVariables((IValueAggregate)parentValue, varDesc);
        }
        if (parentValue instanceof IAIFValuePointer && (aifValue = (valuePointer = (IAIFValuePointer)parentValue).getValue()) instanceof IValueAggregate) {
            return this.getVariables((IValueAggregate)aifValue, varDesc);
        }
        return new IPCDIVariable[0];
    }

    public IPCDIVariable[] getVariablesAsArray(VariableDescriptor varDesc, int start, int length) throws PCDIException {
        IAIFValue parrentValue = varDesc.getAIF().getValue();
        if (parrentValue instanceof IAIFValueArray) {
            IAIFValueArray parentArrayValue = (IAIFValueArray)parrentValue;
            try {
                Object[] values = parentArrayValue.getCurrentValues();
                boolean hasMoreDim = parentArrayValue.hasMoreDimension(values);
                IPCDIVariable[] vars = new IPCDIVariable[values.length];
                int i = 0;
                while (i < values.length) {
                    if (hasMoreDim) {
                        IAIF newAIF = AIFFactory.createAIFIndexedArray((IAIFValueArray)parentArrayValue, (int)i);
                        vars[i] = this.createVariable(this.getVariableDescriptorAsArray(varDesc, newAIF, "[" + i + "]", start, ((Object[])values[i]).length));
                    } else {
                        IAIFValue aifValue = (IAIFValue)values[i];
                        AIF newAIF = new AIF(aifValue.getType(), aifValue);
                        vars[i] = this.createVariable(this.getVariableDescriptorAsArray(varDesc, (IAIF)newAIF, "[" + i + "]", 0, 1));
                    }
                    ++i;
                }
                return vars;
            }
            catch (AIFException e) {
                throw new PCDIException((Throwable)e);
            }
        }
        return new IPCDIVariable[0];
    }

    private VariableDescriptor createVariableDescriptor(VariableDescriptor varDesc, IAIF aif, String eName, boolean extName) throws PCDIException {
        Target target = (Target)varDesc.getTarget();
        Thread thread = (Thread)varDesc.getThread();
        StackFrame frame = (StackFrame)varDesc.getStackFrame();
        String name = extName ? String.valueOf(varDesc.getName()) + eName : eName;
        String fullName = extName ? String.valueOf(varDesc.getFullName()) + eName : eName;
        int pos = varDesc.getPosition();
        int depth = varDesc.getStackDepth();
        if (varDesc instanceof ArgumentDescriptor || varDesc instanceof Argument) {
            return new ArgumentDescriptor(target, thread, frame, name, fullName, pos, depth, aif);
        }
        if (varDesc instanceof LocalVariableDescriptor || varDesc instanceof LocalVariable) {
            return new LocalVariableDescriptor(target, thread, frame, name, fullName, pos, depth, aif);
        }
        if (varDesc instanceof GlobalVariableDescriptor || varDesc instanceof GlobalVariable) {
            return new GlobalVariableDescriptor(target, thread, frame, name, fullName, pos, depth, aif);
        }
        if (varDesc instanceof ThreadStorageDescriptor || varDesc instanceof ThreadStorage) {
            return new ThreadStorageDescriptor(target, thread, frame, name, fullName, pos, depth, aif);
        }
        throw new PCDIException("VariableManager.Unknown_variable_object");
    }

    private VariableDescriptor createVariableDescriptor(VariableDescriptor varDesc, IAIF aif) throws PCDIException {
        Target target = (Target)varDesc.getTarget();
        Thread thread = (Thread)varDesc.getThread();
        StackFrame frame = (StackFrame)varDesc.getStackFrame();
        String name = varDesc.getName();
        String fullName = varDesc.getFullName();
        int pos = varDesc.getPosition();
        int depth = varDesc.getStackDepth();
        if (varDesc instanceof ArgumentDescriptor || varDesc instanceof Argument) {
            return new ArgumentDescriptor(target, thread, frame, name, fullName, pos, depth, aif);
        }
        if (varDesc instanceof LocalVariableDescriptor || varDesc instanceof LocalVariable) {
            return new LocalVariableDescriptor(target, thread, frame, name, fullName, pos, depth, aif);
        }
        if (varDesc instanceof GlobalVariableDescriptor || varDesc instanceof GlobalVariable) {
            return new GlobalVariableDescriptor(target, thread, frame, name, fullName, pos, depth, aif);
        }
        if (varDesc instanceof ThreadStorageDescriptor || varDesc instanceof ThreadStorage) {
            return new ThreadStorageDescriptor(target, thread, frame, name, fullName, pos, depth, aif);
        }
        throw new PCDIException("VariableManager.Unknown_variable_object");
    }

    public VariableDescriptor getVariableDescriptorAsArray(VariableDescriptor varDesc, IAIF aif, String eName, int start, int length) throws PCDIException {
        VariableDescriptor vo = this.createVariableDescriptor(varDesc, aif, eName, true);
        vo.setCastingArrayStart(start);
        vo.setCastingArrayEnd(length);
        return vo;
    }

    public VariableDescriptor getVariableDescriptorAsArray(VariableDescriptor varDesc, IAIF aif, int start, int length) throws PCDIException {
        VariableDescriptor vo = this.createVariableDescriptor(varDesc, aif);
        vo.setCastingArrayStart(varDesc.getCastingArrayStart() + start);
        vo.setCastingArrayEnd(length);
        return vo;
    }

    public VariableDescriptor getVariableDescriptorAsArray(VariableDescriptor varDesc, int start, int length) throws PCDIException {
        return this.getVariableDescriptorAsArray(varDesc, varDesc.getAIF(), start, length);
    }

    public VariableDescriptor getVariableDescriptorAsType(VariableDescriptor varDesc, String type) throws PCDIException {
        Target target = (Target)varDesc.getTarget();
        Thread thread = (Thread)varDesc.getThread();
        StackFrame frame = (StackFrame)varDesc.getStackFrame();
        String name = varDesc.getName();
        String fullName = varDesc.getFullName();
        int pos = varDesc.getPosition();
        int depth = varDesc.getStackDepth();
        IAIF aif = varDesc.getAIF();
        StackFrame f = frame;
        if (f == null) {
            if (thread != null) {
                f = thread.getCurrentStackFrame();
            } else {
                Thread t = (Thread)target.getCurrentThread();
                f = t.getCurrentStackFrame();
            }
        }
        this.checkType(f, type);
        VariableDescriptor vo = null;
        if (varDesc instanceof ArgumentDescriptor || varDesc instanceof Argument) {
            vo = new ArgumentDescriptor(target, thread, frame, name, fullName, pos, depth, aif);
        } else if (varDesc instanceof LocalVariableDescriptor || varDesc instanceof LocalVariable) {
            vo = new LocalVariableDescriptor(target, thread, frame, name, fullName, pos, depth, aif);
        } else if (varDesc instanceof GlobalVariableDescriptor || varDesc instanceof GlobalVariable) {
            vo = new GlobalVariableDescriptor(target, thread, frame, name, fullName, pos, depth, aif);
        } else if (varDesc instanceof ThreadStorageDescriptor || varDesc instanceof ThreadStorage) {
            vo = new ThreadStorageDescriptor(target, thread, frame, name, fullName, pos, depth, aif);
        } else {
            throw new PCDIException("VariableManager.Unknown_variable_object");
        }
        String[] castings = varDesc.getCastingTypes();
        if (castings == null) {
            castings = new String[]{type};
        } else {
            String[] temp = new String[castings.length + 1];
            System.arraycopy(castings, 0, temp, 0, castings.length);
            temp[castings.length] = type;
            castings = temp;
        }
        vo.setCastingTypes(castings);
        return vo;
    }

    public Variable createVariable(VariableDescriptor varDesc) throws PCDIException {
        if (varDesc instanceof ArgumentDescriptor) {
            return this.createArgument((ArgumentDescriptor)varDesc);
        }
        if (varDesc instanceof LocalVariableDescriptor) {
            return this.createLocalVariable((LocalVariableDescriptor)varDesc);
        }
        if (varDesc instanceof GlobalVariableDescriptor) {
            return this.createGlobalVariable((GlobalVariableDescriptor)varDesc);
        }
        if (varDesc instanceof ThreadStorageDescriptor) {
            return this.createThreadStorage((ThreadStorageDescriptor)varDesc);
        }
        throw new PCDIException("VariableManager.Unknown_variable_object");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Argument createArgument(ArgumentDescriptor argDesc) throws PCDIException {
        Variable variable = this.findVariable(argDesc);
        Argument argument = null;
        if (variable != null && variable instanceof Argument) {
            argument = (Argument)variable;
        }
        if (argument != null) return argument;
        StackFrame stack = (StackFrame)argDesc.getStackFrame();
        Target target = (Target)argDesc.getTarget();
        Thread currentThread = (Thread)target.getCurrentThread();
        StackFrame currentFrame = currentThread.getCurrentStackFrame();
        target.setCurrentThread(stack.getThread(), false);
        ((Thread)stack.getThread()).setCurrentStackFrame(stack, false);
        try {
            argument = new Argument(argDesc);
            List variablesList = this.getVariablesList(target);
            if (!variablesList.contains(argument)) {
                variablesList.add(argument);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            target.setCurrentThread(currentThread, false);
            currentThread.setCurrentStackFrame(currentFrame, false);
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        target.setCurrentThread(currentThread, false);
        currentThread.setCurrentStackFrame(currentFrame, false);
        return argument;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IPCDIArgumentDescriptor[] getArgumentDescriptors(StackFrame frame) throws PCDIException {
        ArrayList<ArgumentDescriptor> argObjects = new ArrayList<ArgumentDescriptor>();
        Target target = (Target)frame.getTarget();
        Thread currentThread = (Thread)target.getCurrentThread();
        StackFrame currentFrame = currentThread.getCurrentStackFrame();
        target.setCurrentThread(frame.getThread(), false);
        ((Thread)frame.getThread()).setCurrentStackFrame(frame, false);
        try {
            Session session = (Session)this.getSession();
            BitList tasks = session.createBitList(target.getTargetID());
            ListArgumentsCommand argCmd = new ListArgumentsCommand(tasks, frame);
            session.getDebugger().postCommand((IDebugCommand)argCmd);
            IPCDIArgument[] args = argCmd.getArguments();
            if (args != null) {
                int i = 0;
                while (i < args.length) {
                    VariableDescriptor varDesc = (VariableDescriptor)args[i];
                    Thread thread = (Thread)varDesc.getThread();
                    String name = varDesc.getName();
                    String fName = varDesc.getQualifiedName();
                    int pos = varDesc.getPosition();
                    int depth = varDesc.getStackDepth();
                    IAIF aif = varDesc.getAIF();
                    if (aif == null) {
                        GetAIFCommand aifCmd = new GetAIFCommand(tasks, fName);
                        session.getDebugger().postCommand((IDebugCommand)aifCmd);
                        aif = aifCmd.getAIF();
                    }
                    argObjects.add(new ArgumentDescriptor(target, thread, frame, name, fName, pos, depth, aif));
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            Object var19_20 = null;
            target.setCurrentThread(currentThread, false);
            currentThread.setCurrentStackFrame(currentFrame, false);
            throw throwable;
        }
        {
            Object var19_21 = null;
        }
        target.setCurrentThread(currentThread, false);
        currentThread.setCurrentStackFrame(currentFrame, false);
        return argObjects.toArray(new IPCDIArgumentDescriptor[0]);
    }

    public GlobalVariableDescriptor getGlobalVariableDescriptor(Target target, String filename, String function, String name) throws PCDIException {
        if (filename == null) {
            filename = new String();
        }
        if (function == null) {
            function = new String();
        }
        if (name == null) {
            name = new String();
        }
        StringBuffer buffer = new StringBuffer();
        if (filename.length() > 0) {
            buffer.append('\'').append(filename).append('\'').append("::");
        }
        if (function.length() > 0) {
            buffer.append(function).append("::");
        }
        buffer.append(name);
        return new GlobalVariableDescriptor(target, null, null, buffer.toString(), null, 0, 0, null);
    }

    public GlobalVariable createGlobalVariable(GlobalVariableDescriptor varDesc) throws PCDIException {
        Variable variable = this.findVariable(varDesc);
        GlobalVariable global = null;
        if (variable instanceof GlobalVariable) {
            global = (GlobalVariable)variable;
        }
        if (global == null) {
            String name = varDesc.getQualifiedName();
            Target target = (Target)varDesc.getTarget();
            Session session = (Session)this.getSession();
            ListGlobalVariablesCommand varCmd = new ListGlobalVariablesCommand(session.createBitList(target.getTargetID()));
            session.getDebugger().postCommand((IDebugCommand)varCmd);
            IPCDIGlobalVariable[] vars = varCmd.getGlobalVariables();
            System.out.println(" ++++++++++++++++ listGlobalVariables: " + vars.length + " ++++++++++++++++");
            int i = 0;
            while (i < vars.length) {
                if (name.equals(vars[i].getQualifiedName())) {
                    global = new GlobalVariable(varDesc);
                    List variablesList = this.getVariablesList(target);
                    variablesList.add(global);
                    break;
                }
                ++i;
            }
        }
        return global;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IPCDILocalVariableDescriptor[] getLocalVariableDescriptors(StackFrame frame) throws PCDIException {
        ArrayList<LocalVariableDescriptor> varObjects = new ArrayList<LocalVariableDescriptor>();
        Target target = (Target)frame.getTarget();
        Thread currentThread = (Thread)target.getCurrentThread();
        StackFrame currentFrame = currentThread.getCurrentStackFrame();
        target.setCurrentThread(frame.getThread(), false);
        ((Thread)frame.getThread()).setCurrentStackFrame(frame, false);
        try {
            Session session = (Session)this.getSession();
            BitList tasks = session.createBitList(target.getTargetID());
            ListLocalVariablesCommand varCmd = new ListLocalVariablesCommand(tasks, currentFrame);
            session.getDebugger().postCommand((IDebugCommand)varCmd);
            IPCDILocalVariable[] vars = varCmd.getLocalVariables();
            if (vars != null) {
                int i = 0;
                while (i < vars.length) {
                    VariableDescriptor varDesc = (VariableDescriptor)vars[i];
                    Thread thread = (Thread)varDesc.getThread();
                    String name = varDesc.getName();
                    String fName = varDesc.getQualifiedName();
                    int pos = varDesc.getPosition();
                    int depth = varDesc.getStackDepth();
                    IAIF aif = varDesc.getAIF();
                    if (aif == null) {
                        GetAIFCommand aifCmd = new GetAIFCommand(tasks, fName);
                        session.getDebugger().postCommand((IDebugCommand)aifCmd);
                        aif = aifCmd.getAIF();
                    }
                    varObjects.add(new LocalVariableDescriptor(target, thread, frame, name, fName, pos, depth, aif));
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            Object var19_20 = null;
            target.setCurrentThread(currentThread, false);
            currentThread.setCurrentStackFrame(currentFrame, false);
            throw throwable;
        }
        {
            Object var19_21 = null;
        }
        target.setCurrentThread(currentThread, false);
        currentThread.setCurrentStackFrame(currentFrame, false);
        return varObjects.toArray(new IPCDILocalVariableDescriptor[0]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LocalVariable createLocalVariable(LocalVariableDescriptor varDesc) throws PCDIException {
        Variable variable = this.findVariable(varDesc);
        LocalVariable local = null;
        if (variable instanceof LocalVariable) {
            local = (LocalVariable)variable;
        }
        if (local != null) return local;
        StackFrame stack = (StackFrame)varDesc.getStackFrame();
        Target target = (Target)varDesc.getTarget();
        Thread currentThread = (Thread)target.getCurrentThread();
        StackFrame currentFrame = currentThread.getCurrentStackFrame();
        target.setCurrentThread(stack.getThread(), false);
        ((Thread)stack.getThread()).setCurrentStackFrame(stack, false);
        try {
            local = new LocalVariable(varDesc);
            List variablesList = this.getVariablesList(target);
            if (!variablesList.contains(local)) {
                variablesList.add(local);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            target.setCurrentThread(currentThread, false);
            currentThread.setCurrentStackFrame(currentFrame, false);
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        target.setCurrentThread(currentThread, false);
        currentThread.setCurrentStackFrame(currentFrame, false);
        return local;
    }

    public IPCDIThreadStorageDescriptor[] getThreadStorageDescriptors(Thread thread) throws PCDIException {
        return new IPCDIThreadStorageDescriptor[0];
    }

    public ThreadStorage createThreadStorage(ThreadStorageDescriptor desc) throws PCDIException {
        throw new PCDIException("cdi.VariableManager.Unknown_variable_object");
    }

    public void destroyVariable(Variable variable) throws PCDIException {
        Target target = (Target)variable.getTarget();
        List varList = this.getVariablesList(target);
        if (varList.contains(variable)) {
            this.removeVar(target, variable);
        }
    }

    public void destroyAllVariables(Target target) throws PCDIException {
        Variable[] variables = this.getVariables(target);
        int i = 0;
        while (i < variables.length) {
            this.removeVar(target, variables[i]);
            ++i;
        }
    }

    public void update(Target target) throws PCDIException {
        int highLevel = 0;
        int lowLevel = 0;
        ArrayList eventList = new ArrayList();
        Variable[] vars = this.getVariables(target);
        IPCDIStackFrame[] frames = null;
        StackFrame currentStack = null;
        Thread currentThread = (Thread)target.getCurrentThread();
        if (currentThread != null) {
            currentStack = currentThread.getCurrentStackFrame();
            if (currentStack != null) {
                highLevel = currentStack.getLevel();
            }
            if (highLevel > this.MAX_STACK_DEPTH) {
                highLevel = this.MAX_STACK_DEPTH;
            }
            if ((lowLevel = highLevel - this.MAX_STACK_DEPTH) < 0) {
                lowLevel = 0;
            }
            frames = currentThread.getStackFrames(0, highLevel);
        }
        Session session = (Session)target.getSession();
        int i = 0;
        while (i < vars.length) {
            Variable variable = vars[i];
            if (this.isVariableNeedsToBeUpdate(variable, currentStack, frames, lowLevel)) {
                variable.setUpdated(true);
            } else {
                variable.setUpdated(false);
            }
            ++i;
        }
        IPCDIEvent[] events = eventList.toArray(new IPCDIEvent[0]);
        ((EventManager)session.getEventManager()).fireEvents(events);
    }

    public void update(Variable variable) throws PCDIException {
        Target target = (Target)variable.getTarget();
        ArrayList eventList = new ArrayList();
        this.update(target, variable, eventList);
        IPCDIEvent[] events = eventList.toArray(new IPCDIEvent[0]);
        ((EventManager)((Session)this.getSession()).getEventManager()).fireEvents(events);
    }

    public void update(Target target, Variable variable, List eventList) throws PCDIException {
        throw new PCDIException("Not implement yet - VariableManager: update");
    }

    boolean isVariableNeedsToBeUpdate(Variable variable, IPCDIStackFrame current, IPCDIStackFrame[] frames, int lowLevel) throws PCDIException {
        IPCDIStackFrame varStack = variable.getStackFrame();
        boolean inScope = false;
        if (current == null || frames == null) {
            return false;
        }
        if (varStack == null) {
            return true;
        }
        if (varStack.equals(current)) {
            return true;
        }
        if (varStack.getLevel() >= lowLevel) {
            int i = 0;
            while (i < frames.length) {
                if (varStack.equals(frames[i])) {
                    inScope = true;
                }
                ++i;
            }
        } else {
            inScope = true;
        }
        return !inScope;
    }
}

