/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.cdi.event;

import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.cdi.IPCDISession;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIEvent;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIObject;

public abstract class AbstractEvent
implements IPCDIEvent {
    IPCDISession session = null;
    BitList tasks = null;
    IPCDIObject object = null;

    public AbstractEvent(IPCDISession session, BitList tasks, IPCDIObject object) {
        this.session = session;
        this.tasks = tasks;
        this.object = object;
    }

    public AbstractEvent(IPCDISession session, BitList tasks) {
        this(session, tasks, null);
    }

    public IPJob getDebugJob() {
        return this.session.getJob();
    }

    public BitList getAllProcesses() {
        return this.tasks;
    }

    public BitList getAllUnregisteredProcesses() {
        BitList regTasks = this.session.getRegisteredTargets();
        BitList orgTasks = this.tasks.copy();
        orgTasks.andNot(regTasks);
        return orgTasks;
    }

    public BitList getAllRegisteredProcesses() {
        BitList regTasks = this.session.getRegisteredTargets();
        BitList orgTasks = this.tasks.copy();
        orgTasks.and(regTasks);
        return orgTasks;
    }

    public IPCDIObject getSource() {
        return this.object;
    }

    public IPCDIObject getSource(int task_id) {
        if (this.containTask(task_id)) {
            return this.session.getTarget(task_id);
        }
        return null;
    }

    public boolean containTask(int task_id) {
        try {
            return this.tasks.get(task_id);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
    }
}

