/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.cdi.model;

import java.math.BigInteger;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.ExtFormat;
import org.eclipse.ptp.debug.core.IDebugCommand;
import org.eclipse.ptp.debug.core.aif.AIFException;
import org.eclipse.ptp.debug.core.aif.IAIFValue;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIArgument;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIArgumentDescriptor;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocalVariable;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocalVariableDescriptor;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocator;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIStackFrame;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIThread;
import org.eclipse.ptp.debug.external.core.cdi.Locator;
import org.eclipse.ptp.debug.external.core.cdi.Session;
import org.eclipse.ptp.debug.external.core.cdi.VariableManager;
import org.eclipse.ptp.debug.external.core.cdi.model.PObject;
import org.eclipse.ptp.debug.external.core.cdi.model.Target;
import org.eclipse.ptp.debug.external.core.cdi.model.Thread;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.ArgumentDescriptor;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.LocalVariableDescriptor;
import org.eclipse.ptp.debug.external.core.commands.GetAIFCommand;
import org.eclipse.ptp.debug.external.core.commands.StepFinishCommand;

public class StackFrame
extends PObject
implements IPCDIStackFrame {
    Thread cthread;
    IPCDIArgumentDescriptor[] argDescs;
    IPCDILocalVariableDescriptor[] localDescs;
    Locator fLocator;
    int level = -1;
    String addr = "";
    String file = "";
    int line = -1;
    String func = "";

    public StackFrame(Thread thread, int level, String file, String func, int line, String addr) {
        super((Target)thread.getTarget());
        this.cthread = thread;
        this.level = level;
        this.addr = addr;
        this.file = file;
        this.line = line;
        this.func = func;
    }

    public IPCDIThread getThread() {
        return this.cthread;
    }

    public IPCDIArgumentDescriptor[] getArgumentDescriptors() throws PCDIException {
        if (this.argDescs == null) {
            Session session = (Session)this.getTarget().getSession();
            VariableManager mgr = session.getVariableManager();
            this.argDescs = mgr.getArgumentDescriptors(this);
        } else {
            Target target = (Target)this.getTarget();
            Session session = (Session)target.getSession();
            BitList tasks = session.createBitList(target.getTargetID());
            int i = 0;
            while (i < this.argDescs.length) {
                ArgumentDescriptor argDesc = (ArgumentDescriptor)this.argDescs[i];
                GetAIFCommand command = new GetAIFCommand(tasks, argDesc.getQualifiedName());
                session.getDebugger().postCommand((IDebugCommand)command);
                argDesc.setAIF(command.getAIF());
                ++i;
            }
        }
        return this.argDescs;
    }

    public IPCDILocalVariableDescriptor[] getLocalVariableDescriptors() throws PCDIException {
        if (this.localDescs == null) {
            Session session = (Session)this.getTarget().getSession();
            VariableManager mgr = session.getVariableManager();
            this.localDescs = mgr.getLocalVariableDescriptors(this);
        } else {
            Target target = (Target)this.getTarget();
            Session session = (Session)target.getSession();
            BitList tasks = session.createBitList(target.getTargetID());
            int i = 0;
            while (i < this.localDescs.length) {
                LocalVariableDescriptor localDesc = (LocalVariableDescriptor)this.localDescs[i];
                GetAIFCommand command = new GetAIFCommand(tasks, localDesc.getQualifiedName());
                session.getDebugger().postCommand((IDebugCommand)command);
                localDesc.setAIF(command.getAIF());
                ++i;
            }
        }
        return this.localDescs;
    }

    public IPCDIArgument createArgument(IPCDIArgumentDescriptor varDesc) throws PCDIException {
        if (varDesc instanceof ArgumentDescriptor) {
            Session session = (Session)this.getTarget().getSession();
            VariableManager mgr = session.getVariableManager();
            return mgr.createArgument((ArgumentDescriptor)varDesc);
        }
        return null;
    }

    public IPCDILocalVariable createLocalVariable(IPCDILocalVariableDescriptor varDesc) throws PCDIException {
        if (varDesc instanceof ArgumentDescriptor) {
            return this.createArgument((IPCDIArgumentDescriptor)varDesc);
        }
        if (varDesc instanceof LocalVariableDescriptor) {
            Session session = (Session)this.getTarget().getSession();
            VariableManager mgr = session.getVariableManager();
            return mgr.createLocalVariable((LocalVariableDescriptor)varDesc);
        }
        return null;
    }

    public IPCDILocator getLocator() {
        BigInteger bigAddr = BigInteger.ZERO;
        if (this.fLocator == null) {
            bigAddr = ExtFormat.getBigInteger((String)this.getAddress());
            this.fLocator = new Locator(this.getFile(), this.getFunction(), this.getLine(), bigAddr);
        }
        return this.fLocator;
    }

    public boolean equals(IPCDIStackFrame stackframe) {
        if (stackframe instanceof StackFrame) {
            boolean equal;
            StackFrame stack = (StackFrame)stackframe;
            boolean bl = equal = this.cthread != null && this.cthread.equals(stack.getThread()) && this.getLevel() == stack.getLevel();
            if (equal) {
                IPCDILocator otherLocator = stack.getLocator();
                IPCDILocator myLocator = this.getLocator();
                if (Locator.equalString(myLocator.getFile(), otherLocator.getFile()) && Locator.equalString(myLocator.getFunction(), otherLocator.getFunction())) {
                    return true;
                }
            }
        }
        return super.equals(stackframe);
    }

    public void stepReturn() throws PCDIException {
        try {
            this.finish();
        }
        catch (PCDIException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    public void stepReturn(IAIFValue value) throws PCDIException {
        try {
            this.execReturn(value.getValueString());
        }
        catch (AIFException e) {
            throw new PCDIException(e.getMessage());
        }
    }

    protected void finish() throws PCDIException {
        ((Thread)this.getThread()).setCurrentStackFrame(this, false);
        Target target = (Target)this.getTarget();
        target.getDebugger().postCommand((IDebugCommand)new StepFinishCommand(((Session)target.getSession()).createBitList(target.getTargetID())));
    }

    protected void execReturn(String value) throws PCDIException {
        ((Thread)this.getThread()).setCurrentStackFrame(this, false);
        Target target = (Target)this.getTarget();
        target.getDebugger().postCommand((IDebugCommand)new StepFinishCommand(((Session)target.getSession()).createBitList(target.getTargetID())));
    }

    public int getLevel() {
        return this.level;
    }

    public String getAddress() {
        return this.addr;
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public String getFunction() {
        return this.func;
    }
}

