/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.cdi.model;

import java.math.BigInteger;
import java.util.ArrayList;
import org.eclipse.cdt.debug.core.cdi.ICDIAddressLocation;
import org.eclipse.cdt.debug.core.cdi.ICDIFunctionLocation;
import org.eclipse.cdt.debug.core.cdi.ICDILineLocation;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.model.ICDIInstruction;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMemoryBlock;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMixedInstruction;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegister;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegisterDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegisterGroup;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRuntimeOptions;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.core.cdi.model.ICDISignal;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.debug.core.IAbstractDebugger;
import org.eclipse.ptp.debug.core.IDebugCommand;
import org.eclipse.ptp.debug.core.aif.IAIF;
import org.eclipse.ptp.debug.core.cdi.IPCDIAddressLocation;
import org.eclipse.ptp.debug.core.cdi.IPCDICondition;
import org.eclipse.ptp.debug.core.cdi.IPCDIFunctionLocation;
import org.eclipse.ptp.debug.core.cdi.IPCDILineLocation;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIAddressBreakpoint;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIBreakpoint;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIExceptionpoint;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIExpression;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIFunctionBreakpoint;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIGlobalVariable;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIGlobalVariableDescriptor;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILineBreakpoint;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocation;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIStackFrame;
import org.eclipse.ptp.debug.core.cdi.model.IPCDITarget;
import org.eclipse.ptp.debug.core.cdi.model.IPCDITargetConfiguration;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIThread;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIWatchpoint;
import org.eclipse.ptp.debug.external.core.cdi.ExpressionManager;
import org.eclipse.ptp.debug.external.core.cdi.Session;
import org.eclipse.ptp.debug.external.core.cdi.SessionObject;
import org.eclipse.ptp.debug.external.core.cdi.VariableManager;
import org.eclipse.ptp.debug.external.core.cdi.model.StackFrame;
import org.eclipse.ptp.debug.external.core.cdi.model.TargetConfiguration;
import org.eclipse.ptp.debug.external.core.cdi.model.Thread;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.GlobalVariableDescriptor;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.Variable;
import org.eclipse.ptp.debug.external.core.commands.EvaluteExpressionCommand;
import org.eclipse.ptp.debug.external.core.commands.GoCommand;
import org.eclipse.ptp.debug.external.core.commands.HaltCommand;
import org.eclipse.ptp.debug.external.core.commands.KillCommand;
import org.eclipse.ptp.debug.external.core.commands.StepIntoCommand;
import org.eclipse.ptp.debug.external.core.commands.StepOverCommand;

public class Target
extends SessionObject
implements IPCDITarget {
    IPCDITargetConfiguration fConfiguration;
    Thread[] noThreads = new Thread[0];
    Thread[] currentThreads;
    int currentThreadId;
    String fEndian = null;
    boolean suspended = true;
    private int task_id = -1;

    public Target(Session session, int task_id) {
        super(session);
        this.task_id = task_id;
        this.currentThreads = this.noThreads;
    }

    public IAbstractDebugger getDebugger() {
        return ((Session)this.getSession()).getDebugger();
    }

    public void setConfiguration(IPCDITargetConfiguration configuration) {
        this.fConfiguration = configuration;
    }

    public IPCDITarget getTarget() {
        return this;
    }

    public void setCurrentThread(IPCDIThread cthread) throws PCDIException {
        if (!(cthread instanceof Thread)) {
            throw new PCDIException("Target - Unknown_thread");
        }
        this.setCurrentThread(cthread, true);
    }

    public void setCurrentThread(IPCDIThread cthread, boolean doUpdate) throws PCDIException {
        if (cthread instanceof Thread) {
            try {
                this.setCurrentThread((Thread)cthread, doUpdate);
            }
            catch (PCDIException e) {
                throw new PCDIException(e.getMessage());
            }
        } else {
            throw new PCDIException("Target - Unknown_thread");
        }
    }

    public synchronized void setSupended(boolean state) {
        this.suspended = state;
        this.notifyAll();
    }

    public void setCurrentThread(Thread cthread, boolean doUpdate) throws PCDIException {
        int id = cthread.getId();
        if (id == 0) {
            return;
        }
        if (this.currentThreadId != id) {
            throw new PCDIException("Cannot switch to thread " + id);
        }
    }

    public synchronized void updateState(int newThreadId) {
        Thread[] oldThreads = this.currentThreads;
        this.currentThreadId = newThreadId;
        try {
            this.currentThreads = this.getCThreads();
        }
        catch (PCDIException pCDIException) {
            this.currentThreads = this.noThreads;
        }
        ArrayList<Integer> cList = new ArrayList<Integer>(this.currentThreads.length);
        int i = 0;
        while (i < this.currentThreads.length) {
            boolean found = false;
            int j = 0;
            while (j < oldThreads.length) {
                if (this.currentThreads[i].getId() == oldThreads[j].getId()) {
                    oldThreads[j].clearState();
                    this.currentThreads[i] = oldThreads[j];
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                cList.add(new Integer(this.currentThreads[i].getId()));
            }
            ++i;
        }
        cList.isEmpty();
        ArrayList<Integer> dList = new ArrayList<Integer>(oldThreads.length);
        int i2 = 0;
        while (i2 < oldThreads.length) {
            boolean found = false;
            int j = 0;
            while (j < this.currentThreads.length) {
                if (this.currentThreads[j].getId() == oldThreads[i2].getId()) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                dList.add(new Integer(oldThreads[i2].getId()));
            }
            ++i2;
        }
        dList.isEmpty();
    }

    private Thread[] getCThreads() throws PCDIException {
        Thread[] cthreads = this.noThreads;
        cthreads = new Thread[]{new Thread(this, 0)};
        if (this.currentThreadId == 0 && cthreads.length > 0) {
            this.currentThreadId = cthreads[0].getId();
        }
        return cthreads;
    }

    public IPCDIThread getCurrentThread() throws PCDIException {
        IPCDIThread[] threads = this.getThreads();
        int i = 0;
        while (i < threads.length) {
            Thread cthread = (Thread)threads[i];
            if (cthread.getId() == this.currentThreadId) {
                return cthread;
            }
            ++i;
        }
        return null;
    }

    public synchronized IPCDIThread[] getThreads() throws PCDIException {
        if (this.currentThreads.length == 0) {
            this.currentThreads = this.getCThreads();
        }
        return this.currentThreads;
    }

    public IPCDIThread getThread(int tid) throws PCDIException {
        Thread th = null;
        if (this.currentThreads != null) {
            int i = 0;
            while (i < this.currentThreads.length) {
                Thread cthread = this.currentThreads[i];
                if (cthread.getId() == tid) {
                    th = cthread;
                    break;
                }
                ++i;
            }
        }
        return th;
    }

    public void restart() throws PCDIException {
        this.getDebugger().restart();
    }

    public void stepInto() throws PCDIException {
        this.stepInto(1);
    }

    public void stepInto(int count) throws PCDIException {
        this.getDebugger().postCommand((IDebugCommand)new StepIntoCommand(((Session)this.getSession()).createBitList(this.getTargetID()), count));
    }

    public void stepIntoInstruction() throws PCDIException {
        this.stepIntoInstruction(1);
    }

    public void stepIntoInstruction(int count) throws PCDIException {
        throw new PCDIException("Not implement yet - Target: stepIntoInstruction");
    }

    public void stepOver() throws PCDIException {
        this.stepOver(1);
    }

    public void stepOver(int count) throws PCDIException {
        this.getDebugger().postCommand((IDebugCommand)new StepOverCommand(((Session)this.getSession()).createBitList(this.getTargetID()), count));
    }

    public void stepOverInstruction() throws PCDIException {
        this.stepOverInstruction(1);
    }

    public void stepOverInstruction(int count) throws PCDIException {
        throw new PCDIException("Not implement yet - Target: stepOverInstruction");
    }

    public void stepReturn() throws PCDIException {
        ((Thread)this.getCurrentThread()).getCurrentStackFrame().stepReturn();
    }

    public void runUntil(ICDILocation location) throws PCDIException {
        this.stepUntil(location);
    }

    public void stepUntil(ICDILocation location) throws PCDIException {
        ICDIAddressLocation addrLocation;
        if (location instanceof ICDILineLocation) {
            ICDILineLocation lineLocation = (ICDILineLocation)location;
            if (lineLocation.getFile() != null && lineLocation.getFile().length() > 0) {
                lineLocation.getFile();
                lineLocation.getLineNumber();
            }
        } else if (location instanceof ICDIFunctionLocation) {
            ICDIFunctionLocation funcLocation = (ICDIFunctionLocation)location;
            if (funcLocation.getFunction() != null && funcLocation.getFunction().length() > 0) {
                funcLocation.getFunction();
            }
            if (funcLocation.getFile() != null && funcLocation.getFile().length() > 0) {
                funcLocation.getFile();
            }
        } else if (location instanceof ICDIAddressLocation && !(addrLocation = (ICDIAddressLocation)location).getAddress().equals(BigInteger.ZERO)) {
            String cfr_ignored_0 = "*0x" + addrLocation.getAddress().toString(16);
        }
        throw new PCDIException("Not implement yet - stepUntil(location)");
    }

    public void suspend() throws PCDIException {
        this.getDebugger().postCommand((IDebugCommand)new HaltCommand(((Session)this.getSession()).createBitList(this.getTargetID())));
    }

    public void disconnect() throws PCDIException {
    }

    public void resume() throws PCDIException {
        this.resume(false);
    }

    public void resume(IPCDILocation location) throws PCDIException {
        this.resume(location);
    }

    public void resume(ICDISignal signal) throws PCDIException {
        this.signal(signal);
    }

    public void resume(boolean passSignal) throws PCDIException {
        String state = this.getPProcess().getStatus();
        if (state.equals("running")) {
            throw new PCDIException("The process is already running");
        }
        if (state.equals("stopped")) {
            if (passSignal) {
                this.signal();
            } else {
                this.continuation();
            }
        } else if (state.equals("exited")) {
            this.restart();
        } else {
            this.restart();
        }
    }

    public void continuation() throws PCDIException {
        this.getDebugger().postCommand((IDebugCommand)new GoCommand(((Session)this.getSession()).createBitList(this.getTargetID())));
    }

    public void jump(ICDILocation location) throws PCDIException {
        ICDIAddressLocation addrLocation;
        if (location instanceof ICDILineLocation) {
            ICDILineLocation lineLocation = (ICDILineLocation)location;
            if (lineLocation.getFile() != null && lineLocation.getFile().length() > 0) {
                lineLocation.getFile();
                lineLocation.getLineNumber();
            }
        } else if (location instanceof ICDIFunctionLocation) {
            ICDIFunctionLocation funcLocation = (ICDIFunctionLocation)location;
            if (funcLocation.getFunction() != null && funcLocation.getFunction().length() > 0) {
                funcLocation.getFunction();
            }
            if (funcLocation.getFile() != null && funcLocation.getFile().length() > 0) {
                funcLocation.getFile();
            }
        } else if (location instanceof ICDIAddressLocation && !(addrLocation = (ICDIAddressLocation)location).getAddress().equals(BigInteger.ZERO)) {
            String cfr_ignored_0 = "*0x" + addrLocation.getAddress().toString(16);
        }
        throw new PCDIException("Not implement yet - jump(location)");
    }

    public void signal() throws PCDIException {
        throw new PCDIException("Not implement yet - signal");
    }

    public void signal(ICDISignal signal) throws PCDIException {
        throw new PCDIException("Not implement yet - signal(ICDISignal)");
    }

    public String evaluateExpressionToString(IPCDIStackFrame frame, String expressionText) throws PCDIException {
        Session session;
        StackFrame currentFrame;
        Thread currentThread;
        Target target;
        block5: {
            Variable var;
            block4: {
                String string;
                target = (Target)frame.getTarget();
                currentThread = (Thread)target.getCurrentThread();
                currentFrame = currentThread.getCurrentStackFrame();
                target.setCurrentThread(frame.getThread(), false);
                ((Thread)frame.getThread()).setCurrentStackFrame((StackFrame)frame, false);
                try {
                    session = (Session)target.getSession();
                    var = session.getVariableManager().getVariable(target, expressionText);
                    if (var != null) break block4;
                    string = null;
                    Object var10_11 = null;
                }
                catch (Throwable throwable) {
                    Object var10_14 = null;
                    target.setCurrentThread(currentThread, false);
                    currentThread.setCurrentStackFrame(currentFrame, false);
                    throw throwable;
                }
                target.setCurrentThread(currentThread, false);
                currentThread.setCurrentStackFrame(currentFrame, false);
                return string;
            }
            IAIF aif = var.getAIF();
            if (aif == null) break block5;
            String string = aif.getValue().toString();
            Object var10_12 = null;
            target.setCurrentThread(currentThread, false);
            currentThread.setCurrentStackFrame(currentFrame, false);
            return string;
        }
        EvaluteExpressionCommand command = new EvaluteExpressionCommand(session.createBitList(target.getTargetID()), expressionText);
        session.getDebugger().postCommand((IDebugCommand)command);
        String string = command.getExpressionValue();
        Object var10_13 = null;
        target.setCurrentThread(currentThread, false);
        currentThread.setCurrentStackFrame(currentFrame, false);
        return string;
    }

    public void terminate() throws PCDIException {
        this.getDebugger().postCommand((IDebugCommand)new KillCommand(((Session)this.getSession()).createBitList(this.getTargetID())));
    }

    public boolean isTerminated() {
        return this.getPProcess().isTerminated();
    }

    public boolean isDisconnected() {
        return this.isTerminated();
    }

    public boolean isSuspended() {
        return this.getPProcess().getStatus().equals("stopped");
    }

    public boolean isRunning() {
        return this.getPProcess().getStatus().equals("running");
    }

    public Process getProcess() {
        return null;
    }

    public IPCDILineBreakpoint setLineBreakpoint(int type, IPCDILineLocation location, IPCDICondition condition, boolean deferred) throws PCDIException {
        return this.getSession().getBreakpointManager().setLineBreakpoint(this.getSession().createBitList(this.getTargetID()), type, location, condition, deferred);
    }

    public IPCDIFunctionBreakpoint setFunctionBreakpoint(int type, IPCDIFunctionLocation location, IPCDICondition condition, boolean deferred) throws PCDIException {
        return this.getSession().getBreakpointManager().setFunctionBreakpoint(this.getSession().createBitList(this.getTargetID()), type, location, condition, deferred);
    }

    public IPCDIAddressBreakpoint setAddressBreakpoint(int type, IPCDIAddressLocation location, IPCDICondition condition, boolean deferred) throws PCDIException {
        return this.getSession().getBreakpointManager().setAddressBreakpoint(this.getSession().createBitList(this.getTargetID()), type, location, condition, deferred);
    }

    public IPCDIWatchpoint setWatchpoint(int type, int watchType, String expression, IPCDICondition condition) throws PCDIException {
        return this.getSession().getBreakpointManager().setWatchpoint(this.getSession().createBitList(this.getTargetID()), type, watchType, expression, condition);
    }

    public IPCDIExceptionpoint setExceptionBreakpoint(String clazz, boolean stopOnThrow, boolean stopOnCatch) throws PCDIException {
        throw new PCDIException("Not implemented yet setExceptionBreakpoint");
    }

    public IPCDIBreakpoint[] getBreakpoints() throws PCDIException {
        throw new PCDIException("Not implemented yet - Target: getBreakpoints");
    }

    public void deleteBreakpoints(IPCDIBreakpoint[] breakpoints) throws PCDIException {
        throw new PCDIException("Not implemented yet - Target: deleteBreakpoints");
    }

    public void deleteAllBreakpoints() throws PCDIException {
        throw new PCDIException("Not implemented yet - Target: deleteAllBreakpoints");
    }

    public IPCDICondition createCondition(int ignoreCount, String expression) {
        return this.createCondition(ignoreCount, expression, null);
    }

    public IPCDICondition createCondition(int ignoreCount, String expression, String[] tids) {
        return this.getSession().getBreakpointManager().createCondition(ignoreCount, expression, tids);
    }

    public IPCDILineLocation createLineLocation(String file, int line) {
        return this.getSession().getBreakpointManager().createLineLocation(file, line);
    }

    public IPCDIFunctionLocation createFunctionLocation(String file, String function) {
        return this.getSession().getBreakpointManager().createFunctionLocation(file, function);
    }

    public IPCDIAddressLocation createAddressLocation(BigInteger address) {
        return this.getSession().getBreakpointManager().createAddressLocation(address);
    }

    public ICDIRuntimeOptions getRuntimeOptions() {
        return null;
    }

    public IPCDIExpression createExpression(String code) throws PCDIException {
        ExpressionManager expMgr = ((Session)this.getSession()).getExpressionManager();
        return expMgr.createExpression(this, code);
    }

    public IPCDIExpression[] getExpressions() throws PCDIException {
        ExpressionManager expMgr = ((Session)this.getSession()).getExpressionManager();
        return expMgr.getExpressions(this);
    }

    public void destroyExpressions(IPCDIExpression[] expressions) throws PCDIException {
        ExpressionManager expMgr = ((Session)this.getSession()).getExpressionManager();
        expMgr.destroyExpressions(this, expressions);
    }

    public void destroyAllExpressions() throws PCDIException {
        ExpressionManager expMgr = ((Session)this.getSession()).getExpressionManager();
        expMgr.destroyAllExpressions(this);
    }

    public ICDISignal[] getSignals() throws PCDIException {
        throw new PCDIException("Not implemented yet - Target: getSignals");
    }

    public void setSourcePaths(String[] srcPaths) throws PCDIException {
    }

    public String[] getSourcePaths() throws PCDIException {
        throw new PCDIException("Not implemented yet - Target: getSourcePaths");
    }

    public ICDIInstruction[] getInstructions(BigInteger startAddress, BigInteger endAddress) throws PCDIException {
        throw new PCDIException("Not implemented yet - Target: getInstructions");
    }

    public ICDIInstruction[] getInstructions(String filename, int linenum) throws PCDIException {
        throw new PCDIException("Not implemented yet - Target: getInstructions");
    }

    public ICDIInstruction[] getInstructions(String filename, int linenum, int lines) throws PCDIException {
        throw new PCDIException("Not implemented yet - Target: getInstructions");
    }

    public ICDIMixedInstruction[] getMixedInstructions(BigInteger startAddress, BigInteger endAddress) throws PCDIException {
        throw new PCDIException("Not implemented yet - Target: getMixedInstructions");
    }

    public ICDIMixedInstruction[] getMixedInstructions(String filename, int linenum) throws PCDIException {
        throw new PCDIException("Not implemented yet - Target: getMixedInstructions");
    }

    public ICDIMixedInstruction[] getMixedInstructions(String filename, int linenum, int lines) throws PCDIException {
        throw new PCDIException("Not implemented yet - Target: getMixedInstructions");
    }

    public ICDIMemoryBlock createMemoryBlock(String address, int units, int wordSize) throws PCDIException {
        throw new PCDIException("Not implemented yet - Target: createMemoryBlock");
    }

    public void removeBlocks(ICDIMemoryBlock[] memoryBlocks) throws PCDIException {
        throw new PCDIException("Not implemented yet - Target: removeBlocks");
    }

    public void removeAllBlocks() throws PCDIException {
        throw new PCDIException("Not implemented yet - Target: removeAllBlocks");
    }

    public ICDIMemoryBlock[] getMemoryBlocks() throws PCDIException {
        throw new PCDIException("Not implemented yet - Target: getMemoryBlocks");
    }

    public ICDISharedLibrary[] getSharedLibraries() throws PCDIException {
        throw new PCDIException("Not implemented yet - Target: getSharedLibraries");
    }

    public IPCDIGlobalVariableDescriptor getGlobalVariableDescriptors(String filename, String function, String name) throws PCDIException {
        throw new PCDIException("Not implemented yet - Target: getGlobalVariableDescriptors");
    }

    public ICDIRegisterGroup[] getRegisterGroups() throws PCDIException {
        throw new PCDIException("Not implemented yet - Target: getRegisterGroups");
    }

    public IPCDITargetConfiguration getConfiguration() {
        if (this.fConfiguration == null) {
            this.fConfiguration = new TargetConfiguration(this);
        }
        return this.fConfiguration;
    }

    public IPCDIGlobalVariable createGlobalVariable(IPCDIGlobalVariableDescriptor varDesc) throws PCDIException {
        if (varDesc instanceof GlobalVariableDescriptor) {
            VariableManager varMgr = ((Session)this.getSession()).getVariableManager();
            return varMgr.createGlobalVariable((GlobalVariableDescriptor)varDesc);
        }
        return null;
    }

    public ICDIRegister createRegister(ICDIRegisterDescriptor varDesc) throws PCDIException {
        throw new PCDIException("Not implemented yet - Target: createRegister");
    }

    public IPProcess getPProcess() {
        return this.getDebugger().getProcess(this.task_id);
    }

    public int getTargetID() {
        return this.task_id;
    }
}

