/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.cdi.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.model.ICDISignal;
import org.eclipse.ptp.debug.core.IDebugCommand;
import org.eclipse.ptp.debug.core.cdi.IPCDICondition;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIBreakpoint;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocation;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIStackFrame;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIThread;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIThreadStorage;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIThreadStorageDescriptor;
import org.eclipse.ptp.debug.external.core.cdi.Session;
import org.eclipse.ptp.debug.external.core.cdi.VariableManager;
import org.eclipse.ptp.debug.external.core.cdi.model.PObject;
import org.eclipse.ptp.debug.external.core.cdi.model.StackFrame;
import org.eclipse.ptp.debug.external.core.cdi.model.Target;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.ThreadStorageDescriptor;
import org.eclipse.ptp.debug.external.core.commands.ListStackFramesCommand;
import org.eclipse.ptp.debug.external.core.commands.SetCurrentStackFrameCommand;

public class Thread
extends PObject
implements IPCDIThread {
    static IPCDIStackFrame[] noStack = new IPCDIStackFrame[0];
    int id;
    String name;
    StackFrame currentFrame;
    List currentFrames;
    int stackdepth = 0;
    public static final int STACKFRAME_DEFAULT_DEPTH = 200;

    public Thread(Target target, int threadId) {
        this(target, threadId, null);
    }

    public Thread(Target target, int threadId, String threadName) {
        super(target);
        this.id = threadId;
        this.name = threadName;
    }

    public int getId() {
        return this.id;
    }

    public void clearState() {
        this.stackdepth = 0;
        this.currentFrame = null;
        this.currentFrames = null;
    }

    public String toString() {
        String str = Integer.toString(this.id);
        if (this.name != null) {
            str = String.valueOf(str) + " " + this.name;
        }
        return str;
    }

    public StackFrame getCurrentStackFrame() throws PCDIException {
        IPCDIStackFrame[] frames;
        if (this.currentFrame == null && (frames = this.getStackFrames(0, 0)).length > 0) {
            this.currentFrame = (StackFrame)frames[0];
        }
        return this.currentFrame;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IPCDIStackFrame[] getStackFrames() throws PCDIException {
        int depth = this.getStackFrameCount();
        if (this.currentFrames == null || this.currentFrames.size() < depth) {
            this.currentFrames = new ArrayList();
            Target target = (Target)this.getTarget();
            IPCDIThread currentThread = target.getCurrentThread();
            target.setCurrentThread(this, false);
            Session session = (Session)target.getSession();
            try {
                ListStackFramesCommand command = new ListStackFramesCommand(session.createBitList(target.getTargetID()));
                session.getDebugger().postCommand((IDebugCommand)command);
                IPCDIStackFrame[] frames = command.getStackFrames();
                int i = 0;
                while (i < frames.length) {
                    this.currentFrames.add(frames[i]);
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                target.setCurrentThread(currentThread, false);
                throw throwable;
            }
            {
                Object var8_11 = null;
            }
            target.setCurrentThread(currentThread, false);
            if (this.currentFrame == null) {
                int i = 0;
                while (i < this.currentFrames.size()) {
                    IPCDIStackFrame stack = (IPCDIStackFrame)this.currentFrames.get(i);
                    if (stack.getLevel() == depth) {
                        this.currentFrame = (StackFrame)stack;
                    }
                    ++i;
                }
            }
        }
        return this.currentFrames.toArray(noStack);
    }

    public int getStackFrameCount() throws PCDIException {
        if (this.stackdepth == 0 || this.currentFrames == null) {
            this.currentFrames = new ArrayList();
            Target target = (Target)this.getTarget();
            Session session = (Session)target.getSession();
            ListStackFramesCommand command = new ListStackFramesCommand(session.createBitList(target.getTargetID()));
            session.getDebugger().postCommand((IDebugCommand)command);
            IPCDIStackFrame[] frames = command.getStackFrames();
            int i = 0;
            while (i < frames.length) {
                this.currentFrames.add(frames[i]);
                ++i;
            }
            this.stackdepth = this.currentFrames.size();
            if (frames.length > 0) {
                this.currentFrame = (StackFrame)frames[0];
            }
        }
        return this.stackdepth;
    }

    public IPCDIStackFrame[] getStackFrames(int low, int high) throws PCDIException {
        if (this.currentFrames == null || this.currentFrames.size() < high) {
            this.getStackFrames();
        }
        List list = high - low + 1 <= this.currentFrames.size() ? this.currentFrames.subList(low, high + 1) : this.currentFrames;
        return list.toArray(noStack);
    }

    public void setCurrentStackFrame(StackFrame stackframe, boolean doUpdate) throws PCDIException {
        VariableManager varMgr;
        Thread aThread;
        int frameLevel = 0;
        if (stackframe != null) {
            frameLevel = stackframe.getLevel();
        }
        if (this.currentFrame != null && this.currentFrame.getLevel() == frameLevel && stackframe != null && (aThread = (Thread)stackframe.getThread()) != null && aThread.getId() == this.getId()) {
            return;
        }
        Target target = (Target)this.getTarget();
        Session session = (Session)target.getSession();
        SetCurrentStackFrameCommand command = new SetCurrentStackFrameCommand(session.createBitList(target.getTargetID()), stackframe);
        session.getDebugger().postCommand((IDebugCommand)command);
        command.waitFinish();
        this.currentFrame = stackframe;
        if (doUpdate && (varMgr = session.getVariableManager()).isAutoUpdate()) {
            varMgr.update(target);
        }
    }

    public void stepInto() throws PCDIException {
        this.stepInto(1);
    }

    public void stepInto(int count) throws PCDIException {
        ((Target)this.getTarget()).setCurrentThread(this);
        try {
            this.getTarget().stepInto(count);
        }
        catch (CDIException e) {
            throw new PCDIException((Throwable)e);
        }
    }

    public void stepIntoInstruction() throws PCDIException {
        this.stepIntoInstruction(1);
    }

    public void stepIntoInstruction(int count) throws PCDIException {
        ((Target)this.getTarget()).setCurrentThread(this);
        try {
            this.getTarget().stepIntoInstruction(count);
        }
        catch (CDIException e) {
            throw new PCDIException((Throwable)e);
        }
    }

    public void stepOver() throws PCDIException {
        this.stepOver(1);
    }

    public void stepOver(int count) throws PCDIException {
        ((Target)this.getTarget()).setCurrentThread(this);
        try {
            this.getTarget().stepOver(count);
        }
        catch (CDIException e) {
            throw new PCDIException((Throwable)e);
        }
    }

    public void stepOverInstruction() throws PCDIException {
        this.stepOverInstruction(1);
    }

    public void stepOverInstruction(int count) throws PCDIException {
        ((Target)this.getTarget()).setCurrentThread(this);
        try {
            this.getTarget().stepOverInstruction(count);
        }
        catch (CDIException e) {
            throw new PCDIException((Throwable)e);
        }
    }

    public void stepReturn() throws PCDIException {
        this.getCurrentStackFrame().stepReturn();
    }

    public void runUntil(ICDILocation location) throws PCDIException {
        this.stepUntil(location);
    }

    public void stepUntil(ICDILocation location) throws PCDIException {
        ((Target)this.getTarget()).setCurrentThread(this);
        try {
            this.getTarget().stepUntil(location);
        }
        catch (CDIException e) {
            throw new PCDIException((Throwable)e);
        }
    }

    public boolean isSuspended() {
        return this.getTarget().isSuspended();
    }

    public void suspend() throws PCDIException {
        try {
            this.getTarget().suspend();
        }
        catch (CDIException e) {
            throw new PCDIException((Throwable)e);
        }
    }

    public void resume() throws PCDIException {
        this.resume(false);
    }

    public void resume(boolean passSignal) throws PCDIException {
        ((Target)this.getTarget()).setCurrentThread(this);
        this.getTarget().resume(passSignal);
    }

    public void resume(IPCDILocation location) throws PCDIException {
        ((Target)this.getTarget()).setCurrentThread(this);
        this.getTarget().resume(location);
    }

    public void resume(ICDISignal signal) throws PCDIException {
        ((Target)this.getTarget()).setCurrentThread(this);
        this.getTarget().resume(signal);
    }

    public void jump(IPCDILocation location) throws PCDIException {
        this.resume(location);
    }

    public void signal() throws PCDIException {
        this.resume(false);
    }

    public void signal(ICDISignal signal) throws PCDIException {
        this.resume(signal);
    }

    public boolean equals(IPCDIThread thread) {
        if (thread instanceof Thread) {
            Thread cthread = (Thread)thread;
            return this.id == cthread.getId();
        }
        return super.equals(thread);
    }

    public IPCDIBreakpoint[] getBreakpoints() throws PCDIException {
        Target target = (Target)this.getTarget();
        IPCDIBreakpoint[] bps = target.getBreakpoints();
        ArrayList<IPCDIBreakpoint> list = new ArrayList<IPCDIBreakpoint>(bps.length);
        int i = 0;
        while (i < bps.length) {
            IPCDICondition condition = bps[i].getCondition();
            if (condition != null) {
                String[] threadIds = condition.getThreadIds();
                int j = 0;
                while (j < threadIds.length) {
                    int tid = 0;
                    try {
                        tid = Integer.parseInt(threadIds[j]);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    if (tid == this.getId()) {
                        list.add(bps[i]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return list.toArray(new IPCDIBreakpoint[list.size()]);
    }

    public IPCDIThreadStorageDescriptor[] getThreadStorageDescriptors() throws PCDIException {
        Session session = (Session)this.getTarget().getSession();
        VariableManager varMgr = session.getVariableManager();
        return varMgr.getThreadStorageDescriptors(this);
    }

    public IPCDIThreadStorage createThreadStorage(IPCDIThreadStorageDescriptor varDesc) throws PCDIException {
        if (varDesc instanceof ThreadStorageDescriptor) {
            Session session = (Session)this.getTarget().getSession();
            VariableManager varMgr = session.getVariableManager();
            return varMgr.createThreadStorage((ThreadStorageDescriptor)varDesc);
        }
        return null;
    }
}

