/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.cdi.model.variable;

import java.util.ArrayList;
import org.eclipse.ptp.debug.core.IDebugCommand;
import org.eclipse.ptp.debug.core.aif.IAIF;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocalVariable;
import org.eclipse.ptp.debug.core.cdi.model.IPCDITarget;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIVariable;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIVariableDescriptor;
import org.eclipse.ptp.debug.external.core.cdi.ExpressionManager;
import org.eclipse.ptp.debug.external.core.cdi.Session;
import org.eclipse.ptp.debug.external.core.cdi.VariableManager;
import org.eclipse.ptp.debug.external.core.cdi.model.StackFrame;
import org.eclipse.ptp.debug.external.core.cdi.model.Target;
import org.eclipse.ptp.debug.external.core.cdi.model.Thread;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.VariableDescriptor;
import org.eclipse.ptp.debug.external.core.commands.GetAIFCommand;
import org.eclipse.ptp.debug.external.core.commands.ListLocalVariablesCommand;

public abstract class Variable
extends VariableDescriptor
implements IPCDIVariable {
    public IPCDIVariable[] children = new IPCDIVariable[0];
    String editable = null;
    String language;
    boolean isFake = false;
    boolean isUpdated = true;

    public Variable(VariableDescriptor obj) {
        super(obj);
    }

    public Variable(Target target, Thread thread, StackFrame frame, String name, String fullName, int pos, int depth, IAIF aif) {
        super(target, thread, frame, name, fullName, pos, depth, aif);
    }

    public void setUpdated(boolean update) {
        this.isUpdated = update;
    }

    public boolean isUpdated() {
        return this.isUpdated;
    }

    public void update() throws PCDIException {
        Session session = (Session)this.getTarget().getSession();
        VariableManager mgr = session.getVariableManager();
        mgr.update(this);
    }

    public Variable getChild(String name) {
        int i = 0;
        while (i < this.children.length) {
            Variable variable = (Variable)this.children[i];
            if (name.equals(variable.getName())) {
                return variable;
            }
            Variable grandChild = variable.getChild(name);
            if (grandChild != null) {
                return grandChild;
            }
            ++i;
        }
        return null;
    }

    void setIsFake(boolean f) {
        this.isFake = f;
    }

    boolean isFake() {
        return this.isFake;
    }

    public IPCDIVariable[] getChildren() throws PCDIException {
        return this.getChildren(-1);
    }

    public IPCDIVariable[] getChildren(int timeout) throws PCDIException {
        ArrayList<IPCDILocalVariable> varList = new ArrayList<IPCDILocalVariable>(1);
        Target target = (Target)this.getTarget();
        Session session = (Session)target.getSession();
        String name = this.getQualifiedName();
        ListLocalVariablesCommand command = new ListLocalVariablesCommand(session.createBitList(target.getTargetID()), this.getStackFrame());
        session.getDebugger().postCommand((IDebugCommand)command);
        IPCDILocalVariable[] vars = command.getLocalVariables();
        int i = 0;
        while (i < vars.length) {
            if (name.equals(vars[i].getQualifiedName())) {
                varList.add(vars[i]);
            }
            ++i;
        }
        return varList.toArray(new IPCDIVariable[0]);
    }

    protected abstract Variable createVariable(Target var1, Thread var2, StackFrame var3, String var4, String var5, int var6, int var7, IAIF var8);

    public int getChildrenNumber() throws PCDIException {
        return 1;
    }

    public void setValue(IAIF aif) throws PCDIException {
        this.setAIF(aif);
    }

    public void setValue(String expression) throws PCDIException {
        VariableManager varMgr;
        Target target = (Target)this.getTarget();
        Session session = (Session)target.getSession();
        ExpressionManager expMgr = ((Session)target.getSession()).getExpressionManager();
        if (expMgr.isAutoUpdate()) {
            expMgr.update(target);
        }
        if ((varMgr = session.getVariableManager()).isAutoUpdate()) {
            varMgr.update(target);
        }
        throw new PCDIException("Not implemented yet - Variable: setValue");
    }

    public boolean isEditable() throws PCDIException {
        if (this.editable == null) {
            throw new PCDIException("Not implement yet - Variable: isEditable");
        }
        return this.editable == null ? false : this.editable.equalsIgnoreCase("true");
    }

    public void setFormat(int format) throws PCDIException {
        throw new PCDIException("Not implement yet - Variable: setFormat");
    }

    public boolean equals(IPCDIVariable var) {
        if (var instanceof Variable) {
            Variable variable = (Variable)var;
            return this.equals(variable);
        }
        return super.equals((IPCDIVariableDescriptor)var);
    }

    public boolean equals(Variable variable) {
        return this.getName().equals(variable.getName());
    }

    public void dispose() throws PCDIException {
        IPCDITarget target = this.getTarget();
        VariableManager varMgr = ((Session)target.getSession()).getVariableManager();
        varMgr.destroyVariable(this);
    }

    public String getTypeName() throws PCDIException {
        if (this.aif == null) {
            Target target = (Target)this.getTarget();
            Session session = (Session)target.getSession();
            GetAIFCommand command = new GetAIFCommand(session.createBitList(target.getTargetID()), this.getName());
            session.getDebugger().postCommand((IDebugCommand)command);
            this.aif = command.getAIF();
        }
        return this.aif.getDescription();
    }
}

