/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.cdi.model.variable;

import org.eclipse.ptp.debug.core.aif.IAIF;
import org.eclipse.ptp.debug.core.aif.IAIFType;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIStackFrame;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIThread;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIVariable;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIVariableDescriptor;
import org.eclipse.ptp.debug.external.core.cdi.Session;
import org.eclipse.ptp.debug.external.core.cdi.SourceManager;
import org.eclipse.ptp.debug.external.core.cdi.VariableManager;
import org.eclipse.ptp.debug.external.core.cdi.model.PObject;
import org.eclipse.ptp.debug.external.core.cdi.model.StackFrame;
import org.eclipse.ptp.debug.external.core.cdi.model.Target;
import org.eclipse.ptp.debug.external.core.cdi.model.Thread;

public abstract class VariableDescriptor
extends PObject
implements IPCDIVariableDescriptor {
    String[] castingTypes;
    int castingIndex;
    int castingLength;
    String fName;
    int position;
    StackFrame fStackFrame;
    Thread fThread;
    int stackdepth;
    String qualifiedName = null;
    String fFullName = null;
    protected IAIFType fType = null;
    IAIF aif = null;

    public VariableDescriptor(VariableDescriptor desc) {
        super((Target)desc.getTarget());
        this.fName = desc.getName();
        this.fFullName = desc.fFullName;
        this.fType = desc.fType;
        this.aif = desc.getAIF();
        try {
            this.fStackFrame = (StackFrame)desc.getStackFrame();
            this.fThread = (Thread)desc.getThread();
        }
        catch (PCDIException pCDIException) {}
        this.position = desc.getPosition();
        this.stackdepth = desc.getStackDepth();
        this.castingIndex = desc.getCastingArrayStart();
        this.castingLength = desc.getCastingArrayEnd();
        this.castingTypes = desc.getCastingTypes();
    }

    public VariableDescriptor(Target target, Thread thread, StackFrame stack, String n, String fn, int pos, int depth, IAIF aif) {
        super(target);
        this.fName = n;
        this.fFullName = fn;
        this.fStackFrame = stack;
        this.fThread = thread;
        this.position = pos;
        this.stackdepth = depth;
        this.aif = aif;
    }

    public IAIF getAIF() {
        return this.aif;
    }

    public void setAIF(IAIF aif) {
        this.aif = aif;
    }

    public int getPosition() {
        return this.position;
    }

    public int getStackDepth() {
        return this.stackdepth;
    }

    public void setCastingArrayStart(int start) {
        this.castingIndex = start;
    }

    public int getCastingArrayStart() {
        return this.castingIndex;
    }

    public void setCastingArrayEnd(int end) {
        this.castingLength = end;
    }

    public int getCastingArrayEnd() {
        return this.castingLength;
    }

    public void setCastingTypes(String[] t) {
        this.castingTypes = t;
    }

    public String[] getCastingTypes() {
        return this.castingTypes;
    }

    public String encodeVariable() {
        String fn = this.getFullName();
        if (this.castingLength > 0 || this.castingIndex > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("*(");
            buffer.append('(').append(fn).append(')');
            if (this.castingIndex != 0) {
                buffer.append('+').append(this.castingIndex);
            }
            buffer.append(')');
            buffer.append('@').append(this.castingLength);
            fn = buffer.toString();
        } else if (this.castingTypes != null && this.castingTypes.length > 0) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < this.castingTypes.length) {
                if (this.castingTypes[i] != null && this.castingTypes[i].length() > 0) {
                    if (buffer.length() == 0) {
                        buffer.append('(').append(this.castingTypes[i]).append(')');
                        buffer.append(fn);
                    } else {
                        buffer.insert(0, '(');
                        buffer.append(')');
                        StringBuffer b = new StringBuffer();
                        b.append('(').append(this.castingTypes[i]).append(')');
                        buffer.insert(0, b.toString());
                    }
                }
                ++i;
            }
            fn = buffer.toString();
        }
        return fn;
    }

    public String getFullName() {
        if (this.fFullName == null) {
            this.fFullName = this.getName();
        }
        return this.fFullName;
    }

    public String getName() {
        return this.fName;
    }

    public IAIFType getType() throws PCDIException {
        if (this.fType == null) {
            this.fType = this.getAIF().getType();
        }
        return this.fType;
    }

    public int sizeof() throws PCDIException {
        return this.getType().sizeof();
    }

    public IPCDIStackFrame getStackFrame() throws PCDIException {
        return this.fStackFrame;
    }

    public IPCDIThread getThread() throws PCDIException {
        return this.fThread;
    }

    public String getTypeName() throws PCDIException {
        if (this.aif == null) {
            Target target = (Target)this.getTarget();
            StackFrame frame = (StackFrame)this.getStackFrame();
            if (frame == null) {
                Thread thread = (Thread)this.getThread();
                frame = thread != null ? thread.getCurrentStackFrame() : ((Thread)target.getCurrentThread()).getCurrentStackFrame();
            }
            Session session = (Session)target.getSession();
            SourceManager sourceMgr = session.getSourceManager();
            this.aif = frame != null ? sourceMgr.getAIFFromVariable(frame, this.getQualifiedName()) : sourceMgr.getAIF(target, this.getQualifiedName());
        }
        return this.aif.getDescription();
    }

    public String getQualifiedName() throws PCDIException {
        if (this.qualifiedName == null) {
            this.qualifiedName = this.encodeVariable();
        }
        return this.qualifiedName;
    }

    public static boolean equalsCasting(VariableDescriptor var1, VariableDescriptor var2) {
        String[] castings1 = var1.getCastingTypes();
        String[] castings2 = var2.getCastingTypes();
        if (castings1 == null && castings2 == null) {
            return true;
        }
        if (castings1 != null && castings2 != null && castings1.length == castings2.length) {
            int i = 0;
            while (i < castings1.length) {
                if (!castings1[i].equals(castings2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean equals(IPCDIVariableDescriptor varDesc) {
        VariableDescriptor desc;
        if (varDesc instanceof VariableDescriptor && (desc = (VariableDescriptor)varDesc).getName().equals(this.getName()) && desc.getCastingArrayStart() == this.getCastingArrayStart() && desc.getCastingArrayEnd() == this.getCastingArrayEnd() && VariableDescriptor.equalsCasting(desc, this)) {
            IPCDIThread varThread = null;
            IPCDIThread ourThread = null;
            try {
                varThread = desc.getThread();
                ourThread = this.getThread();
            }
            catch (PCDIException pCDIException) {}
            if (ourThread == null && varThread == null || varThread != null && ourThread != null && varThread.equals(ourThread)) {
                IPCDIStackFrame varFrame = null;
                IPCDIStackFrame ourFrame = null;
                try {
                    varFrame = desc.getStackFrame();
                    ourFrame = this.getStackFrame();
                }
                catch (PCDIException pCDIException) {}
                if (ourFrame == null && varFrame == null) {
                    return true;
                }
                if (varFrame != null && ourFrame != null && varFrame.equals(ourFrame) && desc.getStackDepth() == this.getStackDepth() && desc.getPosition() == this.getPosition()) {
                    return true;
                }
            }
            return false;
        }
        return super.equals(varDesc);
    }

    public IPCDIVariable[] getVariables() throws PCDIException {
        Session session = (Session)this.getTarget().getSession();
        VariableManager mgr = session.getVariableManager();
        return mgr.getVariables(this);
    }

    public IPCDIVariableDescriptor getVariableDescriptorAsArray(int start, int length) throws PCDIException {
        Session session = (Session)this.getTarget().getSession();
        VariableManager mgr = session.getVariableManager();
        return mgr.getVariableDescriptorAsArray(this, start, length);
    }

    public IPCDIVariable[] getVariablesAsArray(int start, int length) throws PCDIException {
        Session session = (Session)this.getTarget().getSession();
        VariableManager mgr = session.getVariableManager();
        return mgr.getVariablesAsArray(this, start, length);
    }

    public IPCDIVariableDescriptor getVariableDescriptorAsType(String type) throws PCDIException {
        Session session = (Session)this.getTarget().getSession();
        VariableManager mgr = session.getVariableManager();
        return mgr.getVariableDescriptorAsType(this, type);
    }

    public IPCDIVariable createVariable() throws PCDIException {
        Session session = (Session)this.getTarget().getSession();
        VariableManager mgr = session.getVariableManager();
        return mgr.createVariable(this);
    }
}

